/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.graph;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.sx.scholix.Scholix;
import eu.dnetlib.dhp.schema.sx.summary.ScholixSummary;
import eu.dnetlib.dhp.sx.graph.SparkCreateScholix$;
import eu.dnetlib.dhp.sx.graph.scholix.ScholixUtils;
import eu.dnetlib.dhp.sx.graph.scholix.ScholixUtils$;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class SparkCreateScholix$ {
    public static final SparkCreateScholix$ MODULE$;

    static {
        new SparkCreateScholix$();
    }

    public void main(String[] args) {
        Logger log = LoggerFactory.getLogger(this.getClass());
        SparkConf conf = new SparkConf();
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/create_scholix_params.json")));
        parser.parseArgument(args);
        SparkSession spark = SparkSession$.MODULE$.builder().config(conf).appName(this.getClass().getSimpleName()).getOrCreate();
        String relationPath = parser.get("relationPath");
        log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"relationPath  -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{relationPath})));
        String summaryPath = parser.get("summaryPath");
        log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"summaryPath  -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{summaryPath})));
        String targetPath = parser.get("targetPath");
        log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"targetPath  -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetPath})));
        boolean dumpCitations = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(parser){
            public static final long serialVersionUID = 0L;
            private final ArgumentApplicationParser parser$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return new StringOps(Predef$.MODULE$.augmentString(this.parser$1.get("dumpCitations"))).toBoolean();
            }
            {
                this.parser$1 = parser$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }));
        log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"dumpCitations  -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)dumpCitations)})));
        Encoder relEncoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Relation.class));
        Encoder summaryEncoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(ScholixSummary.class));
        Encoder scholixEncoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Scholix.class));
        Dataset relationDS = spark.read().load(relationPath).as(relEncoder).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Relation r) {
                return (r.getDataInfo() == null || BoxesRunTime.equals((Object)r.getDataInfo().getDeletedbyinference(), (Object)BoxesRunTime.boxToBoolean((boolean)false))) && !r.getRelClass().toLowerCase().contains("merge");
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Relation> apply(Relation r) {
                return new Tuple2((Object)r.getSource(), (Object)r);
            }
        }, Encoders$.MODULE$.tuple(Encoders$.MODULE$.STRING(), relEncoder));
        Dataset summaryDS = spark.read().load(summaryPath).as(summaryEncoder).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, ScholixSummary> apply(ScholixSummary r) {
                return new Tuple2((Object)r.getId(), (Object)r);
            }
        }, Encoders$.MODULE$.tuple(Encoders$.MODULE$.STRING(), summaryEncoder));
        relationDS.joinWith(summaryDS, relationDS.apply("_1").equalTo((Object)summaryDS.apply("_1")), "left").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Scholix> apply(Tuple2<Tuple2<String, Relation>, Tuple2<String, ScholixSummary>> input) {
                Tuple2 tuple2;
                if (input._1() == null || input._2() == null) {
                    tuple2 = null;
                } else {
                    Relation rel = (Relation)((Tuple2)input._1())._2();
                    ScholixSummary source = (ScholixSummary)((Tuple2)input._2())._2();
                    tuple2 = new Tuple2((Object)rel.getTarget(), (Object)ScholixUtils$.MODULE$.scholixFromSource(rel, source));
                }
                return tuple2;
            }
        }, Encoders$.MODULE$.tuple(Encoders$.MODULE$.STRING(), scholixEncoder)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Scholix> r) {
                return r != null;
            }
        }).write().mode(SaveMode.Overwrite).save(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/scholix_from_source"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetPath})));
        Dataset scholixSource = spark.read().load(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/scholix_from_source"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetPath}))).as(Encoders$.MODULE$.tuple(Encoders$.MODULE$.STRING(), scholixEncoder));
        scholixSource.joinWith(summaryDS, scholixSource.apply("_1").equalTo((Object)summaryDS.apply("_1")), "left").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Scholix apply(Tuple2<Tuple2<String, Scholix>, Tuple2<String, ScholixSummary>> input) {
                Scholix scholix;
                if (input._2() == null) {
                    scholix = null;
                } else {
                    Scholix s = (Scholix)((Tuple2)input._1())._2();
                    ScholixSummary target = (ScholixSummary)((Tuple2)input._2())._2();
                    scholix = ScholixUtils$.MODULE$.generateCompleteScholix(s, target);
                }
                return scholix;
            }
        }, scholixEncoder).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Scholix s) {
                return s != null;
            }
        }).write().mode(SaveMode.Overwrite).save(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/scholix_one_verse"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetPath})));
        Dataset scholix_o_v = spark.read().load(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/scholix_one_verse"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetPath}))).as(scholixEncoder);
        scholix_o_v.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Scholix> apply(Scholix s) {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Scholix[]{s, ScholixUtils$.MODULE$.createInverseScholixRelation(s)}));
            }
        }, scholixEncoder).as(scholixEncoder).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Scholix> apply(Scholix s) {
                return new Tuple2((Object)s.getIdentifier(), (Object)s);
            }
        }, Encoders$.MODULE$.tuple(Encoders$.MODULE$.STRING(), scholixEncoder)).groupByKey((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Scholix> x$1) {
                return (String)x$1._1();
            }
        }, spark.implicits().newStringEncoder()).agg(ScholixUtils$.MODULE$.scholixAggregator().toColumn()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Scholix apply(Tuple2<String, Scholix> s) {
                return (Scholix)s._2();
            }
        }, scholixEncoder).write().mode(SaveMode.Overwrite).save(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/scholix"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetPath})));
        Dataset scholix_final = spark.read().load(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/scholix"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetPath}))).as(scholixEncoder);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator39$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("java.lang.String").asType().toTypeConstructor(), $m.staticClass("java.lang.String").asType().toTypeConstructor()})));
            }

            public Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator39$1() {
            }
        }
        public final class Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator40$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), $m.staticClass("scala.Long").asType().toTypeConstructor()})));
            }

            public Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator40$1() {
            }
        }
        Dataset stats = scholix_final.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Scholix s) {
                return new Tuple2((Object)s.getSource().getDnetIdentifier(), (Object)s.getTarget().getObjectType());
            }
        }, spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator39$1()))).groupBy("_1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_2"})).agg((Column)functions$.MODULE$.count("_1"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).as(spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator40$1())));
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator44$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("eu")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx.graph")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx.graph.scholix")), (Symbols.SymbolApi)$m.staticModule("eu.dnetlib.dhp.sx.graph.scholix.ScholixUtils")), (Symbols.SymbolApi)$m.staticClass("eu.dnetlib.dhp.sx.graph.scholix.ScholixUtils.RelatedEntities"), (List)Nil$.MODULE$);
            }

            public Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator44$1() {
            }
        }
        public final class Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator52$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("eu")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx.graph")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx.graph.scholix")), (Symbols.SymbolApi)$m.staticModule("eu.dnetlib.dhp.sx.graph.scholix.ScholixUtils")), (Symbols.SymbolApi)$m.staticClass("eu.dnetlib.dhp.sx.graph.scholix.ScholixUtils.RelatedEntities"), (List)Nil$.MODULE$);
            }

            public Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator52$1() {
            }
        }
        stats.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ScholixUtils.RelatedEntities apply(Tuple3<String, String, Object> s) {
                return new ScholixUtils.RelatedEntities((String)s._1(), "dataset".equalsIgnoreCase((String)s._2()) ? BoxesRunTime.unboxToLong((Object)s._3()) : 0L, "publication".equalsIgnoreCase((String)s._2()) ? BoxesRunTime.unboxToLong((Object)s._3()) : 0L);
            }
        }, spark.implicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator44$1()))).groupByKey((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(ScholixUtils.RelatedEntities x$2) {
                return x$2.id();
            }
        }, spark.implicits().newStringEncoder()).reduceGroups((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ScholixUtils.RelatedEntities apply(ScholixUtils.RelatedEntities a, ScholixUtils.RelatedEntities b) {
                return new ScholixUtils.RelatedEntities(a.id(), a.relatedDataset() + b.relatedDataset(), a.relatedPublication() + b.relatedPublication());
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ScholixUtils.RelatedEntities apply(Tuple2<String, ScholixUtils.RelatedEntities> x$3) {
                return (ScholixUtils.RelatedEntities)x$3._2();
            }
        }, spark.implicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator52$1()))).write().mode(SaveMode.Overwrite).save(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/related_entities"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetPath})));
        JavaUniverse $u5 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m5 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator56$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("eu")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx.graph")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx.graph.scholix")), (Symbols.SymbolApi)$m.staticModule("eu.dnetlib.dhp.sx.graph.scholix.ScholixUtils")), (Symbols.SymbolApi)$m.staticClass("eu.dnetlib.dhp.sx.graph.scholix.ScholixUtils.RelatedEntities"), (List)Nil$.MODULE$);
            }

            public Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator56$1() {
            }
        }
        Dataset relatedEntitiesDS = spark.read().load(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/related_entities"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetPath}))).as(spark.implicits().newProductEncoder(((TypeTags)$u5).TypeTag().apply((Mirror)$m5, (TypeCreator)new Eu_dnetlib_dhp_sx_graph_SparkCreateScholix$$typecreator56$1()))).filter((Function1)new Serializable(dumpCitations){
            public static final long serialVersionUID = 0L;
            private final boolean dumpCitations$1;

            public final boolean apply(ScholixUtils.RelatedEntities r) {
                return this.dumpCitations$1 || r.relatedPublication() > 0L || r.relatedDataset() > 0L;
            }
            {
                this.dumpCitations$1 = dumpCitations$1;
            }
        });
        relatedEntitiesDS.joinWith(summaryDS, relatedEntitiesDS.apply("id").equalTo((Object)summaryDS.apply("_1")), "inner").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final ScholixSummary apply(Tuple2<ScholixUtils.RelatedEntities, Tuple2<String, ScholixSummary>> i) {
                void var3_3;
                ScholixUtils.RelatedEntities re = (ScholixUtils.RelatedEntities)i._1();
                ScholixSummary sum = (ScholixSummary)((Tuple2)i._2())._2();
                sum.setRelatedDatasets(re.relatedDataset());
                sum.setRelatedPublications(re.relatedPublication());
                return var3_3;
            }
        }, summaryEncoder).write().mode(SaveMode.Overwrite).save(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "_filtered"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{summaryPath})));
    }

    private SparkCreateScholix$() {
        MODULE$ = this;
    }
}

