/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.hostedbymap;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.collection.CollectorException;
import eu.dnetlib.dhp.common.collection.HttpConnector2;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadFile {
    private static final Logger log = LoggerFactory.getLogger(DownloadFile.class);
    public static final char DEFAULT_DELIMITER = ',';

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)Objects.requireNonNull(DownloadFile.class.getResourceAsStream("/eu/dnetlib/dhp/oa/graph/hostedbymap/download_file_parameters.json"))));
        parser.parseArgument(args);
        String fileURL = parser.get("fileURL");
        log.info("fileURL {}", (Object)fileURL);
        String outputFile = parser.get("outputFile");
        log.info("outputFile {}", (Object)outputFile);
        String hdfsNameNode = parser.get("hdfsNameNode");
        log.info("hdfsNameNode {}", (Object)hdfsNameNode);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", hdfsNameNode);
        FileSystem fileSystem = FileSystem.get((Configuration)conf);
        new DownloadFile().doDownload(fileURL, outputFile, fileSystem);
    }

    protected void doDownload(String fileURL, String outputFile, FileSystem fileSystem) throws IOException, CollectorException {
        try (InputStream reader = new HttpConnector2().getInputSourceAsBinary(fileURL);){
            Path hdfsWritePath = new Path(outputFile);
            if (fileSystem.exists(hdfsWritePath)) {
                fileSystem.delete(hdfsWritePath, false);
            }
            try (FSDataOutputStream fsDataOutputStream = fileSystem.create(hdfsWritePath);){
                int bytesRead;
                byte[] buffer = new byte[65536];
                while ((bytesRead = reader.read(buffer)) != -1) {
                    fsDataOutputStream.write(buffer, 0, bytesRead);
                }
            }
        }
    }
}

