/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.hostedbymap;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.collection.CollectorException;
import eu.dnetlib.dhp.common.collection.GetCSV;
import eu.dnetlib.dhp.common.collection.HttpConnector2;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadCSV {
    private static final Logger log = LoggerFactory.getLogger(DownloadCSV.class);
    public static final char DEFAULT_DELIMITER = ',';

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)Objects.requireNonNull(DownloadCSV.class.getResourceAsStream("/eu/dnetlib/dhp/oa/graph/hostedbymap/download_csv_parameters.json"))));
        parser.parseArgument(args);
        String fileURL = parser.get("fileURL");
        log.info("fileURL {}", (Object)fileURL);
        String outputFile = parser.get("outputFile");
        log.info("outputFile {}", (Object)outputFile);
        String hdfsNameNode = parser.get("hdfsNameNode");
        log.info("hdfsNameNode {}", (Object)hdfsNameNode);
        String classForName = parser.get("classForName");
        log.info("classForName {}", (Object)classForName);
        char delimiter = Optional.ofNullable(parser.get("delimiter")).map(s -> Character.valueOf(s.charAt(0))).orElse(Character.valueOf(',')).charValue();
        log.info("delimiter {}", (Object)Character.valueOf(delimiter));
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", hdfsNameNode);
        FileSystem fileSystem = FileSystem.get((Configuration)conf);
        new DownloadCSV().doDownload(fileURL, outputFile, classForName, delimiter, fileSystem);
    }

    protected void doDownload(String fileURL, String outputFile, String classForName, char delimiter, FileSystem fs) throws IOException, ClassNotFoundException, CollectorException {
        try (InputStreamReader reader = new InputStreamReader(new HttpConnector2().getInputSourceAsStream(fileURL));){
            GetCSV.getCsv((FileSystem)fs, (Reader)reader, (String)outputFile, (String)classForName, (char)delimiter);
        }
    }
}

