/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.graph;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.sx.scholix.Scholix;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixCollectedFrom;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixEntityId;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixIdentifier;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixRelationship;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixResource;
import eu.dnetlib.dhp.sx.graph.RelKeyValue;
import eu.dnetlib.dhp.sx.graph.RelationInfo;
import eu.dnetlib.dhp.sx.graph.ScholexplorerUtils;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class ScholexplorerUtils$ {
    public static final ScholexplorerUtils$ MODULE$;
    private final String OPENAIRE_IDENTIFIER_SCHEMA;
    private final ObjectMapper mapper;
    private final Map<String, ScholexplorerUtils.RelationVocabulary> relations;

    static {
        new ScholexplorerUtils$();
    }

    public String OPENAIRE_IDENTIFIER_SCHEMA() {
        return this.OPENAIRE_IDENTIFIER_SCHEMA;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public Map<String, ScholexplorerUtils.RelationVocabulary> relations() {
        return this.relations;
    }

    public String invRel(String rel) {
        ScholexplorerUtils.RelationVocabulary semanticRelation = (ScholexplorerUtils.RelationVocabulary)this.relations().getOrElse((Object)rel.toLowerCase(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        });
        return semanticRelation == null ? null : semanticRelation.inverse();
    }

    public String generateDatasourceOpenAIREURLS(String id) {
        return id != null && id.length() > 12 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"https://explore.openaire.eu/search/dataprovider?datasourceId=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id.substring(3)})) : null;
    }

    public List<Tuple2<StructuredProperty, String>> findURLForPID(List<StructuredProperty> pidValue, List<String> urls) {
        return (List)pidValue.map((Function1)new Serializable(urls){
            public static final long serialVersionUID = 0L;
            private final List urls$1;

            public final Tuple2<StructuredProperty, String> apply(StructuredProperty p) {
                String pv = p.getValue();
                Option r = this.urls$1.find((Function1)new Serializable(this, pv){
                    public static final long serialVersionUID = 0L;
                    private final String pv$1;

                    public final boolean apply(String u) {
                        return u.toLowerCase().contains(this.pv$1.toLowerCase());
                    }
                    {
                        this.pv$1 = pv$1;
                    }
                });
                return new Tuple2((Object)p, r.orNull(Predef$.MODULE$.$conforms()));
            }
            {
                this.urls$1 = urls$1;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public List<ScholixIdentifier> extractTypedIdentifierFromInstance(Result r) {
        if (r.getInstance() == null || r.getInstance().isEmpty()) {
            return Nil$.MODULE$;
        }
        return ((TraversableOnce)((SeqLike)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(r.getInstance()).asScala()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Instance i) {
                return i.getUrl() != null && !i.getUrl().isEmpty();
            }
        })).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Instance i) {
                return i.getPid() != null && i.getUrl() != null;
            }
        })).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Tuple2<StructuredProperty, String>> apply(Instance i) {
                return ScholexplorerUtils$.MODULE$.findURLForPID((List<StructuredProperty>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(i.getPid()).asScala()).toList(), (List<String>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(i.getUrl()).asScala()).toList());
            }
        }, Buffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ScholixIdentifier apply(Tuple2<StructuredProperty, String> i) {
                return new ScholixIdentifier(((StructuredProperty)i._1()).getValue(), ((StructuredProperty)i._1()).getQualifier().getClassid(), (String)i._2());
            }
        }, Buffer$.MODULE$.canBuildFrom())).distinct()).toList();
    }

    /*
     * WARNING - void declaration
     */
    public ScholixResource generateScholixResourceFromResult(Result result) {
        void var2_2;
        List dt;
        List authors;
        if (result.getInstance() == null || result.getInstance().size() == 0) {
            return null;
        }
        if (result.getPid() == null || result.getPid().isEmpty()) {
            return null;
        }
        ScholixResource r = new ScholixResource();
        r.setDnetIdentifier(result.getId());
        List<ScholixIdentifier> persistentIdentifiers = this.extractTypedIdentifierFromInstance(result);
        if (persistentIdentifiers.isEmpty()) {
            return null;
        }
        r.setIdentifier((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(persistentIdentifiers).asJava());
        r.setObjectType(result.getResulttype().getClassid());
        r.setObjectSubType((String)((IterableLike)((SeqLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(result.getInstance()).asScala()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Instance i) {
                return i != null && i.getInstancetype() != null;
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Instance i) {
                return i.getInstancetype().getClassname();
            }
        }, Buffer$.MODULE$.canBuildFrom())).distinct()).head());
        if (result.getTitle() != null && ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(result.getTitle()).asScala()).nonEmpty()) {
            List titles = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(result.getTitle()).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(StructuredProperty t) {
                    return t.getValue();
                }
            }, Buffer$.MODULE$.canBuildFrom())).toList();
            if (titles.nonEmpty()) {
                r.setTitle((String)titles.head());
            } else {
                return null;
            }
        }
        if (result.getAuthor() != null && !result.getAuthor().isEmpty() && (authors = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(result.getAuthor()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final ScholixEntityId apply(Author a) {
                void var2_2;
                ScholixEntityId entity = new ScholixEntityId();
                entity.setName(a.getFullname());
                if (a.getPid() != null && a.getPid().size() > 0) {
                    entity.setIdentifiers((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(a.getPid()).asScala()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        /*
                         * WARNING - void declaration
                         */
                        public final ScholixIdentifier apply(StructuredProperty sp2) {
                            void var2_2;
                            ScholixIdentifier id = new ScholixIdentifier();
                            id.setIdentifier(sp2.getValue());
                            id.setSchema(sp2.getQualifier().getClassid());
                            return var2_2;
                        }
                    }, Buffer$.MODULE$.canBuildFrom())).take(3)).toList()).asJava());
                }
                return var2_2;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList()).nonEmpty()) {
            r.setCreator((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)authors).asJava());
        }
        if ((dt = ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(result.getInstance()).asScala()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Instance i) {
                return i.getDateofacceptance() != null;
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Instance i) {
                return (String)i.getDateofacceptance().getValue();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList()).nonEmpty()) {
            r.setPublicationDate((String)((IterableLike)dt.distinct()).head());
        }
        r.setPublisher((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((SeqLike)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(result.getInstance()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final KeyValue apply(Instance i) {
                return i.getHostedby();
            }
        }, Buffer$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KeyValue h) {
                return !"unknown".equalsIgnoreCase(h.getValue());
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final ScholixEntityId apply(KeyValue h) {
                void var2_2;
                ScholixEntityId eid = new ScholixEntityId();
                eid.setName(h.getValue());
                ScholixIdentifier id = new ScholixIdentifier();
                id.setIdentifier(h.getKey());
                id.setSchema(ScholexplorerUtils$.MODULE$.OPENAIRE_IDENTIFIER_SCHEMA());
                id.setUrl(ScholexplorerUtils$.MODULE$.generateDatasourceOpenAIREURLS(h.getKey()));
                eid.setIdentifiers((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ScholixIdentifier[]{id}))).asJava());
                return var2_2;
            }
        }, Buffer$.MODULE$.canBuildFrom())).distinct()).asJava());
        r.setCollectedFrom((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(result.getCollectedfrom()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * WARNING - void declaration
             */
            public final ScholixCollectedFrom apply(KeyValue cf) {
                void var2_2;
                ScholixCollectedFrom scf = new ScholixCollectedFrom();
                scf.setProvisionMode("collected");
                scf.setCompletionStatus("complete");
                ScholixEntityId eid = new ScholixEntityId();
                eid.setName(cf.getValue());
                ScholixIdentifier id = new ScholixIdentifier();
                id.setIdentifier(cf.getKey());
                id.setSchema(ScholexplorerUtils$.MODULE$.OPENAIRE_IDENTIFIER_SCHEMA());
                id.setUrl(ScholexplorerUtils$.MODULE$.generateDatasourceOpenAIREURLS(cf.getKey()));
                eid.setIdentifiers((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ScholixIdentifier[]{id}))).asJava());
                scf.setProvider(eid);
                return var2_2;
            }
        }, Buffer$.MODULE$.canBuildFrom())).asJava());
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Scholix generateScholix(RelationInfo relation, ScholixResource source) {
        void var3_3;
        Scholix s = new Scholix();
        s.setSource(source);
        if (relation.collectedfrom() != null && relation.collectedfrom().nonEmpty()) {
            s.setLinkprovider((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)relation.collectedfrom().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                /*
                 * WARNING - void declaration
                 */
                public final ScholixEntityId apply(RelKeyValue cf) {
                    void var2_2;
                    ScholixEntityId eid = new ScholixEntityId();
                    eid.setName(cf.value());
                    ScholixIdentifier id = new ScholixIdentifier();
                    id.setIdentifier(cf.key());
                    id.setSchema(ScholexplorerUtils$.MODULE$.OPENAIRE_IDENTIFIER_SCHEMA());
                    id.setUrl(ScholexplorerUtils$.MODULE$.generateDatasourceOpenAIREURLS(cf.key()));
                    eid.setIdentifiers((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ScholixIdentifier[]{id}))).asJava());
                    return var2_2;
                }
            }, Seq$.MODULE$.canBuildFrom())).toList()).asJava());
        } else {
            ScholixEntityId eid = new ScholixEntityId();
            eid.setName("OpenAIRE");
            ScholixIdentifier id = new ScholixIdentifier();
            id.setIdentifier("10|infrastruct_::f66f1bd369679b5b077dcdf006089556");
            id.setSchema(this.OPENAIRE_IDENTIFIER_SCHEMA());
            id.setUrl(this.generateDatasourceOpenAIREURLS(id.getIdentifier()));
            eid.setIdentifiers((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ScholixIdentifier[]{id}))).asJava());
            s.setLinkprovider((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ScholixEntityId[]{eid}))).asJava());
        }
        s.setIdentifier(relation.id());
        ScholexplorerUtils.RelationVocabulary semanticRelation = (ScholexplorerUtils.RelationVocabulary)this.relations().getOrElse((Object)relation.relclass().toLowerCase(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        });
        if (semanticRelation == null) {
            return null;
        }
        s.setRelationship(new ScholixRelationship(semanticRelation.original(), "datacite", semanticRelation.inverse()));
        s.setPublicationDate(source.getPublicationDate());
        s.setPublisher(source.getPublisher());
        ScholixResource mockTarget = new ScholixResource();
        mockTarget.setDnetIdentifier(relation.target());
        s.setTarget(mockTarget);
        return var3_3;
    }

    public String updateTarget(Scholix s, ScholixResource t) {
        s.setTarget(t);
        Nil$ spublishers = s.getPublisher() == null || s.getPublisher().isEmpty() ? Nil$.MODULE$ : ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(s.getPublisher()).asScala()).toList();
        Nil$ tpublishers = t.getPublisher() == null || t.getPublisher().isEmpty() ? Nil$.MODULE$ : ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(t.getPublisher()).asScala()).toList();
        List mergedPublishers = ((TraversableOnce)((IterableLike)((SeqLike)spublishers.union((GenSeq)tpublishers, Seq$.MODULE$.canBuildFrom())).distinct()).take(10)).toList();
        s.setPublisher((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)mergedPublishers).asJava());
        return this.mapper().writeValueAsString((Object)s);
    }

    private final DefaultFormats$ formats$lzycompute$1(ObjectRef formats$lzy$1, VolatileByteRef bitmap$0$1) {
        ScholexplorerUtils$ scholexplorerUtils$ = this;
        synchronized (scholexplorerUtils$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                formats$lzy$1.elem = DefaultFormats$.MODULE$;
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (DefaultFormats$)formats$lzy$1.elem;
        }
    }

    private final DefaultFormats$ formats$1(ObjectRef formats$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.formats$lzycompute$1(formats$lzy$1, bitmap$0$1) : (DefaultFormats$)formats$lzy$1.elem;
    }

    private final JsonAST.JValue json$lzycompute$1(String input$1, ObjectRef json$lzy$1, VolatileByteRef bitmap$0$1) {
        ScholexplorerUtils$ scholexplorerUtils$ = this;
        synchronized (scholexplorerUtils$) {
            if ((byte)(bitmap$0$1.elem & 2) == 0) {
                json$lzy$1.elem = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(input$1), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 2);
            }
            return (JsonAST.JValue)json$lzy$1.elem;
        }
    }

    private final JsonAST.JValue json$1(String input$1, ObjectRef json$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 2) == 0 ? this.json$lzycompute$1(input$1, json$lzy$1, bitmap$0$1) : (JsonAST.JValue)json$lzy$1.elem;
    }

    private ScholexplorerUtils$() {
        MODULE$ = this;
        this.OPENAIRE_IDENTIFIER_SCHEMA = "OpenAIRE Identifier";
        this.mapper = new ObjectMapper();
        ObjectRef formats$lzy = ObjectRef.zero();
        ObjectRef json$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        String input = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/relation/relations.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        this.relations = (Map)package$.MODULE$.jvalue2extractable(this.json$1(input, json$lzy, bitmap$0)).extract((Formats)this.formats$1(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(ScholexplorerUtils.RelationVocabulary.class)})));
    }
}

