/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.hive;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHiveTableExporterJob {
    private static final Logger log = LoggerFactory.getLogger(GraphHiveTableExporterJob.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)GraphHiveTableExporterJob.class.getResourceAsStream("/eu/dnetlib/dhp/oa/graph/hive_db_exporter_parameters.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        int numPartitions = Optional.ofNullable(parser.get("numPartitions")).map(Integer::valueOf).orElse(-1);
        log.info("numPartitions: {}", (Object)numPartitions);
        String outputPath = parser.get("outputPath");
        log.info("outputPath: {}", (Object)outputPath);
        String hiveTableName = parser.get("hiveTableName");
        log.info("hiveTableName: {}", (Object)hiveTableName);
        String hiveMetastoreUris = parser.get("hiveMetastoreUris");
        log.info("hiveMetastoreUris: {}", (Object)hiveMetastoreUris);
        String mode = parser.get("mode");
        log.info("mode: {}", (Object)mode);
        SparkConf conf = new SparkConf();
        conf.set("hive.metastore.uris", hiveMetastoreUris);
        SparkSessionSupport.runWithSparkHiveSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> GraphHiveTableExporterJob.saveGraphTable(spark, outputPath, hiveTableName, mode, numPartitions));
    }

    private static <T extends Oaf> void saveGraphTable(SparkSession spark, String outputPath, String hiveTableName, String mode, int numPartitions) {
        Dataset dataset = spark.table(hiveTableName);
        if (numPartitions > 0) {
            log.info("repartitioning to {} partitions", (Object)numPartitions);
            dataset = dataset.repartition(numPartitions);
        }
        dataset.write().mode(mode).option("compression", "gzip").json(outputPath);
    }
}

