/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.raw;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.HdfsSupport;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.oa.graph.raw.MigrateMongoMdstoresApplication;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatchEntitiesApplication {
    private static final Logger log = LoggerFactory.getLogger(DispatchEntitiesApplication.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)MigrateMongoMdstoresApplication.class.getResourceAsStream("/eu/dnetlib/dhp/oa/graph/dispatch_entities_parameters.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String sourcePath = parser.get("sourcePath");
        String targetPath = parser.get("graphRawPath");
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            DispatchEntitiesApplication.removeOutputDir(spark, targetPath);
            ModelSupport.oafTypes.values().forEach(clazz -> DispatchEntitiesApplication.processEntity(spark, clazz, sourcePath, targetPath));
        });
    }

    private static <T extends Oaf> void processEntity(SparkSession spark, Class<T> clazz, String sourcePath, String targetPath) {
        String type = clazz.getSimpleName().toLowerCase();
        log.info("Processing entities ({}) in file: {}", (Object)type, (Object)sourcePath);
        spark.read().textFile(sourcePath).filter((FilterFunction & Serializable)value -> DispatchEntitiesApplication.isEntityType(value, type)).map((MapFunction & Serializable)l -> StringUtils.substringAfter((String)l, (String)"|"), Encoders.STRING()).write().option("compression", "gzip").mode(SaveMode.Overwrite).text(targetPath + "/" + type);
    }

    private static boolean isEntityType(String line, String type) {
        return StringUtils.substringBefore((String)line, (String)"|").equalsIgnoreCase(type);
    }

    private static void removeOutputDir(SparkSession spark, String path) {
        HdfsSupport.remove((String)path, (Configuration)spark.sparkContext().hadoopConfiguration());
    }
}

