/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.raw.common;

import eu.dnetlib.dhp.oa.graph.raw.common.VerifyNsPrefixPredicate;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Project;
import eu.dnetlib.dhp.schema.oaf.Relation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class VerifyNsPrefixPredicateTest {
    private VerifyNsPrefixPredicate predicate;

    VerifyNsPrefixPredicateTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.predicate = new VerifyNsPrefixPredicate("corda,nsf,wt");
    }

    @Test
    void testTestValue() {
        Assertions.assertFalse((boolean)this.predicate.testValue("corda__2020"));
        Assertions.assertFalse((boolean)this.predicate.testValue("nsf________"));
        Assertions.assertFalse((boolean)this.predicate.testValue("nsf"));
        Assertions.assertFalse((boolean)this.predicate.testValue("corda"));
        Assertions.assertFalse((boolean)this.predicate.testValue("10|corda_______::fjkdsfjksdhfksj"));
        Assertions.assertFalse((boolean)this.predicate.testValue("20|corda_______::fjkdsfjksdhfksj"));
        Assertions.assertTrue((boolean)this.predicate.testValue("xxxxxx_____"));
        Assertions.assertTrue((boolean)this.predicate.testValue("10|xxxxxx_____::sdasdasaddasad"));
        Assertions.assertTrue((boolean)this.predicate.testValue(null));
        Assertions.assertTrue((boolean)this.predicate.testValue(""));
    }

    @Test
    void testTest_ds_true() {
        Field prefix = new Field();
        prefix.setValue((Object)"xxxxxx______");
        Datasource ds = new Datasource();
        ds.setNamespaceprefix(prefix);
        Assertions.assertTrue((boolean)this.predicate.test((Oaf)ds));
    }

    @Test
    void testTest_ds_false() {
        Field prefix = new Field();
        prefix.setValue((Object)"corda__2020");
        Datasource ds = new Datasource();
        ds.setNamespaceprefix(prefix);
        Assertions.assertFalse((boolean)this.predicate.test((Oaf)ds));
    }

    @Test
    void testTest_rel_true() {
        Relation rel = new Relation();
        rel.setSource("10|yyyyyy______:sdfsfsffsdfs");
        rel.setTarget("10|xxxxxx______:sdfsfsffsdfs");
        Assertions.assertTrue((boolean)this.predicate.test((Oaf)rel));
    }

    @Test
    void testTest_rel_false() {
        Relation rel = new Relation();
        rel.setSource("10|corda_______:sdfsfsffsdfs");
        rel.setTarget("10|xxxxxx______:sdfsfsffsdfs");
        Assertions.assertFalse((boolean)this.predicate.test((Oaf)rel));
    }

    @Test
    void testTest_proj_true() {
        Project p = new Project();
        p.setId("10|xxxxxx______:sdfsfsffsdfs");
        Assertions.assertTrue((boolean)this.predicate.test((Oaf)p));
    }

    @Test
    void testTest_proj_false() {
        Project p = new Project();
        p.setId("10|corda_____:sdfsfsffsdfs");
        Assertions.assertFalse((boolean)this.predicate.test((Oaf)p));
    }
}

