/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.clean;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetDatasourceFromCountry
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(GetDatasourceFromCountry.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)GetDatasourceFromCountry.class.getResourceAsStream("/eu/dnetlib/dhp/oa/graph/input_datasource_country_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("inputPath");
        log.info("inputPath: {}", (Object)inputPath);
        String workingPath = parser.get("workingDir");
        log.info("workingDir: {}", (Object)workingPath);
        String country = parser.get("country");
        log.info("country: {}", (Object)country);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> GetDatasourceFromCountry.getDatasourceFromCountry(spark, country, inputPath, workingPath));
    }

    private static void getDatasourceFromCountry(SparkSession spark, String country, String inputPath, String workingDir) {
        Dataset organization = spark.read().textFile(inputPath + "/organization").map((MapFunction & Serializable)value -> (Organization)OBJECT_MAPPER.readValue(value, Organization.class), Encoders.bean(Organization.class)).filter((FilterFunction & Serializable)o -> o.getDataInfo().getDeletedbyinference() == false && o.getCountry() != null && o.getCountry().getClassid() != null && o.getCountry().getClassid().length() > 0 && o.getCountry().getClassid().equals(country));
        Dataset relation = spark.read().textFile(inputPath + "/relation").map((MapFunction & Serializable)value -> (Relation)OBJECT_MAPPER.readValue(value, Relation.class), Encoders.bean(Relation.class)).filter((FilterFunction & Serializable)rel -> rel.getRelClass().equalsIgnoreCase("isProvidedBy") && rel.getDataInfo().getDeletedbyinference() == false);
        organization.joinWith(relation, organization.col("id").equalTo((Object)relation.col("target"))).map((MapFunction & Serializable)t2 -> ((Relation)t2._2()).getSource(), Encoders.STRING()).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(workingDir);
    }
}

