/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.hive;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHiveImporterJob {
    private static final Logger log = LoggerFactory.getLogger(GraphHiveImporterJob.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)GraphHiveImporterJob.class.getResourceAsStream("/eu/dnetlib/dhp/oa/graph/input_graph_hive_parameters.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("inputPath");
        log.info("inputPath: {}", (Object)inputPath);
        String hiveDbName = parser.get("hiveDbName");
        log.info("hiveDbName: {}", (Object)hiveDbName);
        String hiveMetastoreUris = parser.get("hiveMetastoreUris");
        log.info("hiveMetastoreUris: {}", (Object)hiveMetastoreUris);
        SparkConf conf = new SparkConf();
        conf.set("hive.metastore.uris", hiveMetastoreUris);
        SparkSessionSupport.runWithSparkHiveSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> GraphHiveImporterJob.loadGraphAsHiveDB(spark, inputPath, hiveDbName));
    }

    private static void loadGraphAsHiveDB(SparkSession spark, String inputPath, String hiveDbName) {
        spark.sql(String.format("DROP DATABASE IF EXISTS %s CASCADE", hiveDbName));
        spark.sql(String.format("CREATE DATABASE IF NOT EXISTS %s", hiveDbName));
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        ModelSupport.oafTypes.forEach((name, clazz) -> spark.createDataset(sc.textFile(inputPath + "/" + name).map((Function & Serializable)s -> OBJECT_MAPPER.readValue(s, clazz)).rdd(), Encoders.bean((Class)clazz)).write().mode(SaveMode.Overwrite).saveAsTable(hiveDbName + "." + name));
    }
}

