/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.raw;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.MDStoreInfo;
import eu.dnetlib.dhp.common.MdstoreClient;
import eu.dnetlib.dhp.oa.graph.raw.common.AbstractMigrationApplication;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateMongoMdstoresApplication
extends AbstractMigrationApplication
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(MigrateMongoMdstoresApplication.class);
    private final MdstoreClient mdstoreClient;

    private static List<MDStoreInfo> snapshotsMDStores(MdstoreClient client, String format, String layout, String interpretation) {
        return client.mdStoreWithTimestamp(format, layout, interpretation);
    }

    private static MDStoreInfo extractPath(String path, String basePath) {
        String[] split;
        int res = path.indexOf(basePath);
        if (res > 0 && (split = path.substring(res).split("/")).length > 2) {
            String ts = split[split.length - 1];
            String mdStore = split[split.length - 2];
            return new MDStoreInfo(mdStore, null, Long.valueOf(Long.parseLong(ts)));
        }
        return null;
    }

    private static Map<String, MDStoreInfo> hdfsMDStoreInfo(FileSystem fs, String basePath) throws IOException {
        HashMap<String, MDStoreInfo> hdfs_store = new HashMap<String, MDStoreInfo>();
        Path p = new Path(basePath);
        if (!fs.exists(p)) {
            return hdfs_store;
        }
        RemoteIterator ls = fs.listFiles(p, true);
        while (ls.hasNext()) {
            String current = ((LocatedFileStatus)ls.next()).getPath().toString();
            MDStoreInfo info = MigrateMongoMdstoresApplication.extractPath(current, basePath);
            if (info == null) continue;
            hdfs_store.put(info.getMdstore(), info);
        }
        return hdfs_store;
    }

    private static String createMDStoreDir(String basePath, String mdStoreId) {
        if (basePath.endsWith("/")) {
            return basePath + mdStoreId;
        }
        return String.format("%s/%s", basePath, mdStoreId);
    }

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)Objects.requireNonNull(MigrateMongoMdstoresApplication.class.getResourceAsStream("/eu/dnetlib/dhp/oa/graph/migrate_mongo_mstores_parameters.json"))));
        parser.parseArgument(args);
        String mongoBaseUrl = parser.get("mongoBaseUrl");
        String mongoDb = parser.get("mongoDb");
        String mdFormat = parser.get("mdFormat");
        String mdLayout = parser.get("mdLayout");
        String mdInterpretation = parser.get("mdInterpretation");
        String hdfsPath = parser.get("hdfsPath");
        String nameNode = parser.get("nameNode");
        FileSystem fileSystem = FileSystem.get((Configuration)DHPUtils.getHadoopConfiguration((String)nameNode));
        MdstoreClient mdstoreClient = new MdstoreClient(mongoBaseUrl, mongoDb);
        List<MDStoreInfo> mongoMDStores = MigrateMongoMdstoresApplication.snapshotsMDStores(mdstoreClient, mdFormat, mdLayout, mdInterpretation);
        Map<String, MDStoreInfo> hdfsMDStores = MigrateMongoMdstoresApplication.hdfsMDStoreInfo(fileSystem, hdfsPath);
        mongoMDStores.stream().filter(currentMDStore -> currentMDStore.getLatestTimestamp() != null).forEach(MigrateMongoMdstoresApplication.consumeMDStore(mdFormat, mdLayout, mdInterpretation, hdfsPath, fileSystem, mongoBaseUrl, mongoDb, hdfsMDStores));
    }

    private static Consumer<MDStoreInfo> consumeMDStore(String mdFormat, String mdLayout, String mdInterpretation, String hdfsPath, FileSystem fileSystem, String mongoBaseUrl, String mongoDb, Map<String, MDStoreInfo> hdfsMDStores) {
        return currentMDStore -> {
            if (!hdfsMDStores.containsKey(currentMDStore.getMdstore())) {
                log.info("Adding store {}", (Object)currentMDStore.getMdstore());
                try {
                    MigrateMongoMdstoresApplication.synchMDStoreIntoHDFS(mdFormat, mdLayout, mdInterpretation, hdfsPath, fileSystem, mongoBaseUrl, mongoDb, currentMDStore);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            MDStoreInfo current = (MDStoreInfo)hdfsMDStores.get(currentMDStore.getMdstore());
            if (currentMDStore.getLatestTimestamp() > current.getLatestTimestamp()) {
                log.info("Updating MDStore {}", (Object)currentMDStore.getMdstore());
                String mdstoreDir = MigrateMongoMdstoresApplication.createMDStoreDir(hdfsPath, currentMDStore.getMdstore());
                String rmPath = MigrateMongoMdstoresApplication.createMDStoreDir(mdstoreDir, current.getLatestTimestamp().toString());
                try {
                    MigrateMongoMdstoresApplication.synchMDStoreIntoHDFS(mdFormat, mdLayout, mdInterpretation, hdfsPath, fileSystem, mongoBaseUrl, mongoDb, currentMDStore);
                    log.info("deleting {}", (Object)rmPath);
                    fileSystem.delete(new Path(rmPath), true);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to synch and remove path " + rmPath, e);
                }
            }
        };
    }

    private static void synchMDStoreIntoHDFS(String mdFormat, String mdLayout, String mdInterpretation, String hdfsPath, FileSystem fileSystem, String mongoBaseUrl, String mongoDb, MDStoreInfo currentMDStore) throws IOException {
        String mdstoreDir = MigrateMongoMdstoresApplication.createMDStoreDir(hdfsPath, currentMDStore.getMdstore());
        fileSystem.mkdirs(new Path(mdstoreDir));
        String currentIdDir = MigrateMongoMdstoresApplication.createMDStoreDir(mdstoreDir, currentMDStore.getLatestTimestamp().toString());
        try (MigrateMongoMdstoresApplication app = new MigrateMongoMdstoresApplication(mongoBaseUrl, mongoDb, currentIdDir);){
            app.execute(currentMDStore.getCurrentId(), mdFormat, mdLayout, mdInterpretation);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Error on sync mdstore with ID %s into path %s", currentMDStore.getMdstore(), currentIdDir), e);
        }
        log.info(String.format("Synchronized mdStore id : %s into path %s", currentMDStore.getMdstore(), currentIdDir));
    }

    public MigrateMongoMdstoresApplication(String mongoBaseUrl, String mongoDb, String hdfsPath) throws Exception {
        super(hdfsPath);
        this.mdstoreClient = new MdstoreClient(mongoBaseUrl, mongoDb);
    }

    public void execute(String currentColl, String format, String layout, String interpretation) {
        for (String xml : this.mdstoreClient.listRecords(currentColl)) {
            this.emit(xml, String.format("%s-%s-%s", format, layout, interpretation));
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.mdstoreClient.close();
    }
}

