/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.raw;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.HdfsSupport;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.oa.graph.raw.GenerateEntitiesApplication;
import eu.dnetlib.dhp.oa.graph.raw.common.AbstractMigrationApplication;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyRecordsApplication
extends AbstractMigrationApplication {
    private static final Logger log = LoggerFactory.getLogger(VerifyRecordsApplication.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)VerifyRecordsApplication.class.getResourceAsStream("/eu/dnetlib/dhp/oa/graph/verify_records_parameters.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String sourcePaths = parser.get("sourcePaths");
        log.info("sourcePaths: {}", (Object)sourcePaths);
        String invalidPath = parser.get("invalidPath");
        log.info("invalidPath: {}", (Object)invalidPath);
        String isLookupUrl = parser.get("isLookupUrl");
        log.info("isLookupUrl: {}", (Object)isLookupUrl);
        ISLookUpService isLookupService = ISLookupClientFactory.getLookUpService((String)isLookupUrl);
        VocabularyGroup vocs = VocabularyGroup.loadVocsFromIS((ISLookUpService)isLookupService);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            HdfsSupport.remove((String)invalidPath, (Configuration)spark.sparkContext().hadoopConfiguration());
            VerifyRecordsApplication.validateRecords(spark, sourcePaths, invalidPath, vocs);
        });
    }

    private static void validateRecords(SparkSession spark, String sourcePaths, String invalidPath, VocabularyGroup vocs) {
        List<String> existingSourcePaths = VerifyRecordsApplication.listEntityPaths(spark, sourcePaths);
        log.info("Verify records in files:");
        existingSourcePaths.forEach(arg_0 -> ((Logger)log).info(arg_0));
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        for (String sp2 : existingSourcePaths) {
            RDD invalidRecords = sc.sequenceFile(sp2, Text.class, Text.class).map((Function & Serializable)k -> VerifyRecordsApplication.tryApplyMapping(((Text)k._1()).toString(), ((Text)k._2()).toString(), true, vocs)).filter(Objects::nonNull).rdd();
            spark.createDataset(invalidRecords, Encoders.STRING()).write().mode(SaveMode.Append).option("compression", "gzip").text(invalidPath);
        }
    }

    private static String tryApplyMapping(String id, String xmlRecord, boolean shouldHashId, VocabularyGroup vocs) {
        List<Oaf> oaf = GenerateEntitiesApplication.convertToListOaf(id, xmlRecord, shouldHashId, vocs);
        if (Optional.ofNullable(oaf).map(List::isEmpty).orElse(false).booleanValue()) {
            return xmlRecord;
        }
        return null;
    }
}

