/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.graph.scholix;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixIdentifier;
import eu.dnetlib.dhp.schema.sx.summary.ScholixSummary;
import eu.dnetlib.dhp.sx.graph.bio.pubmed.AbstractVocabularyTest;
import eu.dnetlib.dhp.sx.graph.scholix.ScholixUtils$;
import java.io.Serializable;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

@ExtendWith(value={MockitoExtension.class})
@ScalaSignature(bytes="\u0006\u0001\t4A\u0001C\u0005\u0001-!)q\u0004\u0001C\u0001A!91\u0005\u0001b\u0001\n\u0003!\u0003BB\u0019\u0001A\u0003%Q\u0005C\u00033\u0001\u0011\u00051\u0007C\u0003H\u0001\u0011\u00051\u0007C\u0003M\u0001\u0011\u00051\u0007C\u0003O\u0001\u0011\u00051G\u0001\tTG\"|G.\u001b=He\u0006\u0004\b\u000eV3ti*\u0011!bC\u0001\bg\u000eDw\u000e\\5y\u0015\taQ\"A\u0003he\u0006\u0004\bN\u0003\u0002\u000f\u001f\u0005\u00111\u000f\u001f\u0006\u0003!E\t1\u0001\u001a5q\u0015\t\u00112#A\u0004e]\u0016$H.\u001b2\u000b\u0003Q\t!!Z;\u0004\u0001M\u0011\u0001a\u0006\t\u00031ui\u0011!\u0007\u0006\u00035m\ta\u0001];c[\u0016$'B\u0001\u000f\f\u0003\r\u0011\u0017n\\\u0005\u0003=e\u0011a#\u00112tiJ\f7\r\u001e,pG\u0006\u0014W\u000f\\1ssR+7\u000f^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0005\u0002\"A\t\u0001\u000e\u0003%\ta!\\1qa\u0016\u0014X#A\u0013\u0011\u0005\u0019zS\"A\u0014\u000b\u0005!J\u0013\u0001\u00033bi\u0006\u0014\u0017N\u001c3\u000b\u0005)Z\u0013a\u00026bG.\u001cxN\u001c\u0006\u0003Y5\n\u0011BZ1ti\u0016\u0014\b0\u001c7\u000b\u00039\n1aY8n\u0013\t\u0001tE\u0001\u0007PE*,7\r^'baB,'/A\u0004nCB\u0004XM\u001d\u0011\u0002\u000bM,G/\u00169\u0015\u0003Q\u0002\"!\u000e\u001d\u000e\u0003YR\u0011aN\u0001\u0006g\u000e\fG.Y\u0005\u0003sY\u0012A!\u00168ji\"\u0012Aa\u000f\t\u0003y\u0015k\u0011!\u0010\u0006\u0003}}\n1!\u00199j\u0015\t\u0001\u0015)A\u0004kkBLG/\u001a:\u000b\u0005\t\u001b\u0015!\u00026v]&$(\"\u0001#\u0002\u0007=\u0014x-\u0003\u0002G{\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002!Q,7\u000f^(B\rR{7+^7nCJL\bFA\u0003J!\ta$*\u0003\u0002L{\t!A+Z:u\u0003a!Xm\u001d;TG\"|G.\u001b=NKJ<Wm\u00148T_V\u00148-\u001a\u0015\u0003\r%\u000bQ\u0004^3tiN\u001b\u0007n\u001c7jqJ+G.\u0019;j_:\u001c\b.\u001b9t\u00072,\u0017M\u001c\u0015\u0003\u000f%CC\u0001A)X1B\u0011!+V\u0007\u0002'*\u0011A+P\u0001\nKb$XM\\:j_:L!AV*\u0003\u0015\u0015CH/\u001a8e/&$\b.A\u0003wC2,X\rL\u0001ZG\u0005Q\u0006CA.a\u001b\u0005a&B\u0001!^\u0015\t\u0011eL\u0003\u0002`\u0007\u00069Qn\\2lSR|\u0017BA1]\u0005AiunY6ji>,\u0005\u0010^3og&|g\u000e")
public class ScholixGraphTest
extends AbstractVocabularyTest {
    private final ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);

    public ObjectMapper mapper() {
        return this.mapper;
    }

    @BeforeEach
    public void setUp() {
        super.setUpVocabulary();
    }

    @Test
    public void testOAFToSummary() {
        String inputRelations = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/oaf_to_summary"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        List items = new StringOps(Predef$.MODULE$.augmentString(inputRelations)).linesWithSeparators().map((Function1 & Serializable & scala.Serializable)l -> new StringOps(Predef$.MODULE$.augmentString(l)).stripLineEnd()).toList();
        Assertions.assertNotNull((Object)items);
        items.foreach((Function1 & Serializable & scala.Serializable)i -> {
            ScholixGraphTest.$anonfun$testOAFToSummary$2(i);
            return BoxedUnit.UNIT;
        });
        List result = (List)((List)items.map((Function1 & Serializable & scala.Serializable)r -> (Result)this.mapper().readValue(r, Result.class), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)i -> ScholixUtils$.MODULE$.resultToSummary(i), List$.MODULE$.canBuildFrom());
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((int)result.size(), (int)items.size());
        Option d = result.find((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ScholixGraphTest.$anonfun$testOAFToSummary$5(s)));
        Assertions.assertFalse((boolean)d.isDefined());
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString(result.head()));
    }

    @Test
    public void testScholixMergeOnSource() {
        String inputRelations = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/merge_result_scholix"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        Iterator qual$1 = new StringOps(Predef$.MODULE$.augmentString(inputRelations)).linesWithSeparators().map((Function1 & Serializable & scala.Serializable)l -> new StringOps(Predef$.MODULE$.augmentString(l)).stripLineEnd());
        int x$1 = 2;
        int x$2 = qual$1.sliding$default$2();
        List result = qual$1.sliding(x$1, x$2).map((Function1 & Serializable & scala.Serializable)s -> new Tuple2(s.head(), s.apply(1))).map((Function1 & Serializable & scala.Serializable)p -> new Tuple2(this.mapper().readValue((String)p._1(), Relation.class), this.mapper().readValue((String)p._2(), ScholixSummary.class))).toList();
        Assertions.assertNotNull((Object)result);
        Assertions.assertTrue((boolean)result.nonEmpty());
        result.foreach((Function1 & Serializable & scala.Serializable)r -> {
            ScholixGraphTest.$anonfun$testScholixMergeOnSource$4(r);
            return BoxedUnit.UNIT;
        });
        List scholix = (List)result.map((Function1 & Serializable & scala.Serializable)r -> ScholixUtils$.MODULE$.scholixFromSource((Relation)r._1(), (ScholixSummary)r._2()), List$.MODULE$.canBuildFrom());
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString(scholix.head()));
    }

    @Test
    public void testScholixRelationshipsClean() {
        LazyRef formats$lzy = new LazyRef();
        LazyRef json$lzy = new LazyRef();
        String inputRelations = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/relation_transform.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        List l = (List)package$.MODULE$.jvalue2extractable(ScholixGraphTest.json$1(json$lzy, inputRelations)).extract((Formats)ScholixGraphTest.formats$1(formats$lzy), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        Assertions.assertNotNull((Object)l);
        Assertions.assertTrue((boolean)l.nonEmpty());
        Map relVocbaulary = ScholixUtils$.MODULE$.relations();
        l.foreach((Function1 & Serializable & scala.Serializable)r -> {
            ScholixGraphTest.$anonfun$testScholixRelationshipsClean$1(relVocbaulary, r);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testOAFToSummary$2(String i) {
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString(i)).nonEmpty());
    }

    public static final /* synthetic */ boolean $anonfun$testOAFToSummary$6(ScholixIdentifier i) {
        return i.getUrl() == null || i.getUrl().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$testOAFToSummary$5(ScholixSummary s) {
        return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(s.getLocalIdentifier()).asScala()).exists((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)ScholixGraphTest.$anonfun$testOAFToSummary$6(i)));
    }

    public static final /* synthetic */ void $anonfun$testScholixMergeOnSource$4(Tuple2 r) {
        Assertions.assertEquals((Object)((Relation)r._1()).getSource(), (Object)((ScholixSummary)r._2()).getId());
    }

    private static final /* synthetic */ DefaultFormats$ formats$lzycompute$1(LazyRef formats$lzy$1) {
        DefaultFormats$ defaultFormats$;
        LazyRef lazyRef = formats$lzy$1;
        synchronized (lazyRef) {
            defaultFormats$ = formats$lzy$1.initialized() ? (DefaultFormats$)formats$lzy$1.value() : (DefaultFormats$)formats$lzy$1.initialize((Object)DefaultFormats$.MODULE$);
        }
        return defaultFormats$;
    }

    private static final DefaultFormats$ formats$1(LazyRef formats$lzy$1) {
        if (formats$lzy$1.initialized()) {
            return (DefaultFormats$)formats$lzy$1.value();
        }
        return ScholixGraphTest.formats$lzycompute$1(formats$lzy$1);
    }

    private static final /* synthetic */ JsonAST.JValue json$lzycompute$1(LazyRef json$lzy$1, String inputRelations$1) {
        JsonAST.JValue jValue;
        LazyRef lazyRef = json$lzy$1;
        synchronized (lazyRef) {
            jValue = json$lzy$1.initialized() ? (JsonAST.JValue)json$lzy$1.value() : (JsonAST.JValue)json$lzy$1.initialize((Object)JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(inputRelations$1), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3()));
        }
        return jValue;
    }

    private static final JsonAST.JValue json$1(LazyRef json$lzy$1, String inputRelations$1) {
        if (json$lzy$1.initialized()) {
            return (JsonAST.JValue)json$lzy$1.value();
        }
        return ScholixGraphTest.json$lzycompute$1(json$lzy$1, inputRelations$1);
    }

    public static final /* synthetic */ void $anonfun$testScholixRelationshipsClean$1(Map relVocbaulary$1, String r) {
        Assertions.assertTrue((boolean)relVocbaulary$1.contains((Object)r.toLowerCase()));
    }

    public ScholixGraphTest() {
        this.mapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

