/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.merge;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.oa.graph.merge.MergeGraphTableSparkJob;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class MergeGraphTableSparkJobTest {
    private ObjectMapper mapper;

    MergeGraphTableSparkJobTest() {
    }

    @BeforeEach
    public void setUp() {
        this.mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Test
    void testMerge() throws IOException {
        Datasource d = (Datasource)MergeGraphTableSparkJob.mergeDatasource(this.d("datasource_cris.json"), this.d("datasource_openaire2.0.json"));
        Assertions.assertEquals((Object)"10|274269ac6f3b::2a2e2793b500f3f7b47ef24b1a9277b7", (Object)d.getId());
        Assertions.assertNotNull((Object)d.getOriginalId());
        Assertions.assertEquals((int)2, (int)d.getOriginalId().size());
        Assertions.assertNotNull((Object)d.getCollectedfrom());
        Assertions.assertEquals((int)2, (int)d.getCollectedfrom().size());
        Assertions.assertNotNull((Object)d.getPid());
        Assertions.assertEquals((int)1, (int)d.getPid().size());
    }

    @Test
    void testMergeCompatibility() throws IOException {
        Assertions.assertEquals((Object)"openaire-cris_1.1", (Object)((Datasource)MergeGraphTableSparkJob.mergeDatasource(this.d("datasource_cris.json"), this.d("datasource_UNKNOWN.json"))).getOpenairecompatibility().getClassid());
        Assertions.assertEquals((Object)"openaire-cris_1.1", (Object)((Datasource)MergeGraphTableSparkJob.mergeDatasource(this.d("datasource_UNKNOWN.json"), this.d("datasource_cris.json"))).getOpenairecompatibility().getClassid());
        Assertions.assertEquals((Object)"driver-openaire2.0", (Object)((Datasource)MergeGraphTableSparkJob.mergeDatasource(this.d("datasource_native.json"), this.d("datasource_driver-openaire2.0.json"))).getOpenairecompatibility().getClassid());
        Assertions.assertEquals((Object)"driver-openaire2.0", (Object)((Datasource)MergeGraphTableSparkJob.mergeDatasource(this.d("datasource_driver-openaire2.0.json"), this.d("datasource_native.json"))).getOpenairecompatibility().getClassid());
        Assertions.assertEquals((Object)"openaire4.0", (Object)((Datasource)MergeGraphTableSparkJob.mergeDatasource(this.d("datasource_notCompatible.json"), this.d("datasource_openaire4.0.json"))).getOpenairecompatibility().getClassid());
        Assertions.assertEquals((Object)"notCompatible", (Object)((Datasource)MergeGraphTableSparkJob.mergeDatasource(this.d("datasource_notCompatible.json"), this.d("datasource_UNKNOWN.json"))).getOpenairecompatibility().getClassid());
    }

    private Optional<Datasource> d(String file) throws IOException {
        String json = IOUtils.toString((InputStream)this.getClass().getResourceAsStream(file));
        return Optional.of((Datasource)this.mapper.readValue(json, Datasource.class));
    }
}

