/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.resolution;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.oa.graph.resolution.SparkResolveEntities$;
import eu.dnetlib.dhp.schema.common.EntityType;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.Software;
import eu.dnetlib.dhp.schema.oaf.utils.MergeUtils;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;

public final class SparkResolveEntities$ {
    public static SparkResolveEntities$ MODULE$;
    private final ObjectMapper mapper;
    private final List<EntityType> entities;

    static {
        new SparkResolveEntities$();
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public List<EntityType> entities() {
        return this.entities;
    }

    public void main(String[] args) {
        Logger log = LoggerFactory.getLogger(this.getClass());
        SparkConf conf = new SparkConf();
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/oa/graph/resolution/resolve_entities_params.json")));
        parser.parseArgument(args);
        SparkSession spark = SparkSession$.MODULE$.builder().config(conf).appName(this.getClass().getSimpleName()).getOrCreate();
        String graphBasePath = parser.get("graphBasePath");
        log.info(new StringBuilder(18).append("graphBasePath  -> ").append(graphBasePath).toString());
        String workingPath = parser.get("workingPath");
        log.info(new StringBuilder(16).append("workingPath  -> ").append(workingPath).toString());
        String unresolvedPath = parser.get("unresolvedPath");
        log.info(new StringBuilder(19).append("unresolvedPath  -> ").append(unresolvedPath).toString());
        String targetPath = parser.get("targetPath");
        log.info(new StringBuilder(15).append("targetPath  -> ").append(targetPath).toString());
        FileSystem fs = FileSystem.get((Configuration)spark.sparkContext().hadoopConfiguration());
        fs.mkdirs(new Path(workingPath));
        this.resolveEntities(spark, workingPath, unresolvedPath);
        this.generateResolvedEntities(spark, workingPath, graphBasePath, targetPath);
    }

    public void resolveEntities(SparkSession spark, String workingPath, String unresolvedPath) {
        Encoder resEncoder = Encoders$.MODULE$.kryo(Result.class);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Eu_dnetlib_dhp_oa_graph_resolution_SparkResolveEntities$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$), (List)Nil$.MODULE$)));
            }

            public Eu_dnetlib_dhp_oa_graph_resolution_SparkResolveEntities$$typecreator5$1() {
            }
        }
        org.apache.spark.sql.Dataset rPid = spark.read().load(new StringBuilder(20).append(workingPath).append("/relationResolvedPid").toString()).as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Eu_dnetlib_dhp_oa_graph_resolution_SparkResolveEntities$$typecreator5$1())));
        org.apache.spark.sql.Dataset up = spark.read().text(unresolvedPath).as(spark.implicits().newStringEncoder()).map((Function1 & Serializable & scala.Serializable)s -> (Result)MODULE$.mapper().readValue(s, Result.class), resEncoder).map((Function1 & Serializable & scala.Serializable)r -> new Tuple2((Object)r.getId(), r), Encoders$.MODULE$.tuple(Encoders$.MODULE$.STRING(), resEncoder));
        rPid.joinWith(up, rPid.apply("_2").equalTo((Object)up.apply("_1")), "inner").map((Function1 & Serializable & scala.Serializable)r -> {
            Result result = (Result)((Tuple2)r._2())._2();
            String dnetId = (String)((Tuple2)r._1())._1();
            result.setId(dnetId);
            return result;
        }, resEncoder).write().mode(SaveMode.Overwrite).save(new StringBuilder(17).append(workingPath).append("/resolvedEntities").toString());
    }

    public Result deserializeObject(String input, EntityType entity) {
        EntityType entityType = entity;
        if (EntityType.publication.equals(entityType)) {
            return (Result)this.mapper().readValue(input, Publication.class);
        }
        if (EntityType.dataset.equals(entityType)) {
            return (Result)this.mapper().readValue(input, Dataset.class);
        }
        if (EntityType.software.equals(entityType)) {
            return (Result)this.mapper().readValue(input, Software.class);
        }
        if (EntityType.otherresearchproduct.equals(entityType)) {
            return (Result)this.mapper().readValue(input, OtherResearchProduct.class);
        }
        throw new MatchError((Object)entityType);
    }

    public void generateResolvedEntities(SparkSession spark, String workingPath, String graphBasePath, String targetPath) {
        Encoder resEncoder = Encoders$.MODULE$.kryo(Result.class);
        org.apache.spark.sql.Dataset re = spark.read().load(new StringBuilder(17).append(workingPath).append("/resolvedEntities").toString()).as(resEncoder).map((Function1 & Serializable & scala.Serializable)r -> new Tuple2((Object)r.getId(), r), Encoders$.MODULE$.tuple(Encoders$.MODULE$.STRING(), resEncoder));
        this.entities().foreach((Function1 & Serializable & scala.Serializable)e -> {
            SparkResolveEntities$.$anonfun$generateResolvedEntities$2(spark, graphBasePath, resEncoder, re, targetPath, e);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$generateResolvedEntities$2(SparkSession spark$1, String graphBasePath$1, Encoder resEncoder$1, org.apache.spark.sql.Dataset re$1, String targetPath$1, EntityType e) {
        org.apache.spark.sql.Dataset currentEntityDataset = spark$1.read().text(new StringBuilder(1).append(graphBasePath$1).append("/").append(e).toString()).as(spark$1.implicits().newStringEncoder()).map((Function1 & Serializable & scala.Serializable)s -> MODULE$.deserializeObject((String)s, e), resEncoder$1).map((Function1 & Serializable & scala.Serializable)r -> new Tuple2((Object)r.getId(), r), Encoders$.MODULE$.tuple(Encoders$.MODULE$.STRING(), resEncoder$1));
        currentEntityDataset.joinWith(re$1, currentEntityDataset.apply("_1").equalTo((Object)re$1.apply("_1")), "left").map((Function1 & Serializable & scala.Serializable)k -> {
            Tuple2 a = (Tuple2)k._1();
            Tuple2 b = (Tuple2)k._2();
            if (b == null) {
                return (Result)a._2();
            }
            return MergeUtils.mergeResult((Result)((Result)a._2()), (Result)((Result)b._2()));
        }, resEncoder$1).map((Function1 & Serializable & scala.Serializable)r -> MODULE$.mapper().writeValueAsString(r), Encoders$.MODULE$.STRING()).write().mode(SaveMode.Overwrite).option("compression", "gzip").text(new StringBuilder(1).append(targetPath$1).append("/").append(e).toString());
    }

    private SparkResolveEntities$() {
        MODULE$ = this;
        this.mapper = new ObjectMapper();
        this.entities = new .colon.colon((Object)EntityType.dataset, (List)new .colon.colon((Object)EntityType.publication, (List)new .colon.colon((Object)EntityType.software, (List)new .colon.colon((Object)EntityType.otherresearchproduct, (List)Nil$.MODULE$))));
    }
}

