/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.graph;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.schema.sx.scholix.Scholix;
import eu.dnetlib.dhp.schema.sx.summary.ScholixSummary;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class SparkConvertObjectToJson$ {
    public static SparkConvertObjectToJson$ MODULE$;

    static {
        new SparkConvertObjectToJson$();
    }

    public Option<Object> toInt(String s) {
        Some some;
        try {
            some = new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(s)).toInt()));
        }
        catch (Exception e) {
            some = None$.MODULE$;
        }
        return some;
    }

    public void main(String[] args) {
        Logger log = LoggerFactory.getLogger(this.getClass());
        SparkConf conf = new SparkConf();
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/convert_object_json_params.json")));
        parser.parseArgument(args);
        SparkSession spark = SparkSession$.MODULE$.builder().config(conf).appName(this.getClass().getSimpleName()).getOrCreate();
        String sourcePath = parser.get("sourcePath");
        log.info(new StringBuilder(15).append("sourcePath  -> ").append(sourcePath).toString());
        String targetPath = parser.get("targetPath");
        log.info(new StringBuilder(15).append("targetPath  -> ").append(targetPath).toString());
        String objectType = parser.get("objectType");
        log.info(new StringBuilder(15).append("objectType  -> ").append(objectType).toString());
        String scholixUpdatePath = parser.get("scholixUpdatePath");
        log.info(new StringBuilder(22).append("scholixUpdatePath  -> ").append(scholixUpdatePath).toString());
        String maxPidNumberFilter = parser.get("maxPidNumberFilter");
        log.info(new StringBuilder(23).append("maxPidNumberFilter  -> ").append(maxPidNumberFilter).toString());
        Encoder scholixEncoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Scholix.class));
        Encoder summaryEncoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(ScholixSummary.class));
        ObjectMapper mapper = new ObjectMapper();
        String string = objectType.toLowerCase();
        if ("scholix".equals(string)) {
            log.info("Serialize Scholix");
            Dataset d = spark.read().load(sourcePath).as(scholixEncoder);
            if (maxPidNumberFilter != null && this.toInt(maxPidNumberFilter).isDefined()) {
                int mp = BoxesRunTime.unboxToInt((Object)this.toInt(maxPidNumberFilter).get());
                d.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)SparkConvertObjectToJson$.$anonfun$main$1(mp, s))).map((Function1 & Serializable & scala.Serializable)s -> mapper.writeValueAsString(s), Encoders$.MODULE$.STRING()).rdd().saveAsTextFile(targetPath, GzipCodec.class);
                return;
            }
            d.repartition(8000).map((Function1 & Serializable & scala.Serializable)s -> mapper.writeValueAsString(s), Encoders$.MODULE$.STRING()).rdd().saveAsTextFile(targetPath, GzipCodec.class);
            return;
        }
        if ("summary".equals(string)) {
            log.info("Serialize Summary");
            Dataset d = spark.read().load(sourcePath).as(summaryEncoder);
            d.map((Function1 & Serializable & scala.Serializable)s -> mapper.writeValueAsString(s), Encoders$.MODULE$.STRING()).rdd().repartition(1000, (Ordering)Ordering.String$.MODULE$).saveAsTextFile(targetPath, GzipCodec.class);
            return;
        }
        throw new MatchError((Object)string);
    }

    public static final /* synthetic */ boolean $anonfun$main$1(int mp$1, Scholix s) {
        return s.getSource().getIdentifier().size() <= mp$1 && s.getTarget().getIdentifier().size() <= mp$1;
    }

    private SparkConvertObjectToJson$() {
        MODULE$ = this;
    }
}

