/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.graph;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Software;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class SparkConvertRDDtoDataset$ {
    public static SparkConvertRDDtoDataset$ MODULE$;

    static {
        new SparkConvertRDDtoDataset$();
    }

    public void main(String[] args) {
        Logger log = LoggerFactory.getLogger(this.getClass());
        SparkConf conf = new SparkConf();
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/convert_dataset_json_params.json")));
        parser.parseArgument(args);
        SparkSession spark = SparkSession$.MODULE$.builder().config(conf).appName(this.getClass().getSimpleName()).getOrCreate();
        String sourcePath = parser.get("sourcePath");
        log.info(new StringBuilder(15).append("sourcePath  -> ").append(sourcePath).toString());
        String t = parser.get("targetPath");
        log.info(new StringBuilder(15).append("targetPath  -> ").append(t).toString());
        String subRelTypeFilter = parser.get("filterRelation");
        log.info(new StringBuilder(19).append("filterRelation  -> ").append(subRelTypeFilter).toString());
        String entityPath = new StringBuilder(9).append(t).append("/entities").toString();
        String relPath = new StringBuilder(9).append(t).append("/relation").toString();
        ObjectMapper mapper = new ObjectMapper();
        Encoder datasetEncoder = Encoders$.MODULE$.kryo(Dataset.class);
        Encoder publicationEncoder = Encoders$.MODULE$.kryo(Publication.class);
        Encoder relationEncoder = Encoders$.MODULE$.kryo(Relation.class);
        Encoder orpEncoder = Encoders$.MODULE$.kryo(OtherResearchProduct.class);
        Encoder softwareEncoder = Encoders$.MODULE$.kryo(Software.class);
        log.info("Converting dataset");
        RDD rddDataset = spark.sparkContext().textFile(new StringBuilder(8).append(sourcePath).append("/dataset").toString(), spark.sparkContext().textFile$default$2()).map((Function1 & Serializable & scala.Serializable)s -> (Dataset)mapper.readValue(s, Dataset.class), ClassTag$.MODULE$.apply(Dataset.class)).filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)SparkConvertRDDtoDataset$.$anonfun$main$2(r)));
        spark.createDataset(rddDataset, datasetEncoder).as(datasetEncoder).write().mode(SaveMode.Overwrite).save(new StringBuilder(8).append(entityPath).append("/dataset").toString());
        log.info("Converting publication");
        RDD rddPublication = spark.sparkContext().textFile(new StringBuilder(12).append(sourcePath).append("/publication").toString(), spark.sparkContext().textFile$default$2()).map((Function1 & Serializable & scala.Serializable)s -> (Publication)mapper.readValue(s, Publication.class), ClassTag$.MODULE$.apply(Publication.class)).filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)SparkConvertRDDtoDataset$.$anonfun$main$4(r)));
        spark.createDataset(rddPublication, publicationEncoder).as(publicationEncoder).write().mode(SaveMode.Overwrite).save(new StringBuilder(12).append(entityPath).append("/publication").toString());
        log.info("Converting software");
        RDD rddSoftware = spark.sparkContext().textFile(new StringBuilder(9).append(sourcePath).append("/software").toString(), spark.sparkContext().textFile$default$2()).map((Function1 & Serializable & scala.Serializable)s -> (Software)mapper.readValue(s, Software.class), ClassTag$.MODULE$.apply(Software.class)).filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)SparkConvertRDDtoDataset$.$anonfun$main$6(r)));
        spark.createDataset(rddSoftware, softwareEncoder).as(softwareEncoder).write().mode(SaveMode.Overwrite).save(new StringBuilder(9).append(entityPath).append("/software").toString());
        log.info("Converting otherresearchproduct");
        RDD rddOtherResearchProduct = spark.sparkContext().textFile(new StringBuilder(21).append(sourcePath).append("/otherresearchproduct").toString(), spark.sparkContext().textFile$default$2()).map((Function1 & Serializable & scala.Serializable)s -> (OtherResearchProduct)mapper.readValue(s, OtherResearchProduct.class), ClassTag$.MODULE$.apply(OtherResearchProduct.class)).filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)SparkConvertRDDtoDataset$.$anonfun$main$8(r)));
        spark.createDataset(rddOtherResearchProduct, orpEncoder).as(orpEncoder).write().mode(SaveMode.Overwrite).save(new StringBuilder(21).append(entityPath).append("/otherresearchproduct").toString());
        log.info("Converting Relation");
        .colon.colon relClassFilter = new .colon.colon((Object)"merges", (List)new .colon.colon((Object)"isMergedIn", (List)new .colon.colon((Object)"HasAmongTopNSimilarDocuments", (List)new .colon.colon((Object)"IsAmongTopNSimilarDocuments", (List)Nil$.MODULE$))));
        RDD rddRelation = spark.sparkContext().textFile(new StringBuilder(9).append(sourcePath).append("/relation").toString(), spark.sparkContext().textFile$default$2()).map((Function1 & Serializable & scala.Serializable)s -> (Relation)mapper.readValue(s, Relation.class), ClassTag$.MODULE$.apply(Relation.class)).filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)SparkConvertRDDtoDataset$.$anonfun$main$10(r))).filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)SparkConvertRDDtoDataset$.$anonfun$main$11(r))).filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)SparkConvertRDDtoDataset$.MODULE$.filterRelations(r)));
        spark.createDataset(rddRelation, relationEncoder).as(relationEncoder).write().mode(SaveMode.Overwrite).save(String.valueOf(relPath));
    }

    private boolean filterRelations(Relation r) {
        .colon.colon relClassFilter = new .colon.colon((Object)"merges", (List)new .colon.colon((Object)"isMergedIn", (List)new .colon.colon((Object)"HasAmongTopNSimilarDocuments", (List)new .colon.colon((Object)"IsAmongTopNSimilarDocuments", (List)Nil$.MODULE$))));
        if (relClassFilter.exists((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)k.equalsIgnoreCase(r.getRelClass())))) {
            return false;
        }
        if (r.getCollectedfrom() == null || r.getCollectedfrom().size() == 0) {
            return false;
        }
        if (r.getCollectedfrom().size() > 1) {
            return true;
        }
        return r.getCollectedfrom().size() != 1 || r.getCollectedfrom().get(0) == null || !"OpenCitations".equalsIgnoreCase(((KeyValue)r.getCollectedfrom().get(0)).getValue());
    }

    public static final /* synthetic */ boolean $anonfun$main$2(Dataset r) {
        return r.getDataInfo() != null && BoxesRunTime.equals((Object)r.getDataInfo().getDeletedbyinference(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public static final /* synthetic */ boolean $anonfun$main$4(Publication r) {
        return r.getDataInfo() != null && BoxesRunTime.equals((Object)r.getDataInfo().getDeletedbyinference(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public static final /* synthetic */ boolean $anonfun$main$6(Software r) {
        return r.getDataInfo() != null && BoxesRunTime.equals((Object)r.getDataInfo().getDeletedbyinference(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public static final /* synthetic */ boolean $anonfun$main$8(OtherResearchProduct r) {
        return r.getDataInfo() != null && BoxesRunTime.equals((Object)r.getDataInfo().getDeletedbyinference(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    public static final /* synthetic */ boolean $anonfun$main$10(Relation r) {
        return r.getDataInfo() != null && !Predef$.MODULE$.Boolean2boolean(r.getDataInfo().getDeletedbyinference());
    }

    public static final /* synthetic */ boolean $anonfun$main$11(Relation r) {
        return r.getSource().startsWith("50") && r.getTarget().startsWith("50");
    }

    private SparkConvertRDDtoDataset$() {
        MODULE$ = this;
    }
}

