/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.hostedbymap;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.collection.DecompressTarGz;
import eu.dnetlib.dhp.oa.graph.hostedbymap.model.DOAJModel;
import eu.dnetlib.dhp.oa.graph.hostedbymap.model.doaj.DOAJEntry;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractAndMapDoajJson {
    private static final Logger log = LoggerFactory.getLogger(ExtractAndMapDoajJson.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)Objects.requireNonNull(ExtractAndMapDoajJson.class.getResourceAsStream("/eu/dnetlib/dhp/oa/graph/hostedbymap/download_json_parameters.json"))));
        parser.parseArgument(args);
        String compressedInput = parser.get("compressedFile");
        log.info("compressedInput {}", (Object)compressedInput);
        String hdfsNameNode = parser.get("hdfsNameNode");
        log.info("hdfsNameNode {}", (Object)hdfsNameNode);
        String outputPath = parser.get("outputPath");
        log.info("outputPath {}", (Object)outputPath);
        String workingPath = parser.get("workingPath");
        log.info("workingPath {}", (Object)workingPath);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", hdfsNameNode);
        FileSystem fs = FileSystem.get((Configuration)conf);
        DecompressTarGz.doExtract((String)hdfsNameNode, (String)workingPath, (String)compressedInput);
        CompressionCodecFactory factory = new CompressionCodecFactory(conf);
        CompressionCodec codec = factory.getCodecByClassName("org.apache.hadoop.io.compress.GzipCodec");
        ExtractAndMapDoajJson.doMap(hdfsNameNode, workingPath, outputPath, codec);
    }

    private static void doMap(String nameNode, String workingPath, String outputPath, CompressionCodec codec) throws IOException {
        Configuration conf = DHPUtils.getHadoopConfiguration((String)nameNode);
        Path wrkdir = new Path(workingPath);
        FileSystem wrkdirfs = wrkdir.getFileSystem(conf);
        RemoteIterator fileStatusListIterator = wrkdirfs.listFiles(wrkdir, true);
        Path hdfsWritePath = new Path(outputPath);
        FileSystem writefs = hdfsWritePath.getFileSystem(conf);
        if (writefs.exists(hdfsWritePath)) {
            writefs.delete(hdfsWritePath, true);
        }
        try (FSDataOutputStream out = writefs.create(hdfsWritePath);
             PrintWriter writer = new PrintWriter(new BufferedOutputStream((OutputStream)out));){
            while (fileStatusListIterator.hasNext()) {
                Path path = ((LocatedFileStatus)fileStatusListIterator.next()).getPath();
                if (wrkdirfs.isDirectory(path)) continue;
                FSDataInputStream is = wrkdirfs.open(path);
                CompressionInputStream compressionInputStream = codec.createInputStream((InputStream)is);
                DOAJEntry[] doajEntries = (DOAJEntry[])new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).readValue((InputStream)compressionInputStream, DOAJEntry[].class);
                Arrays.stream(doajEntries).forEach(doaj -> {
                    try {
                        writer.println(new ObjectMapper().writeValueAsString((Object)ExtractAndMapDoajJson.getDoajModel(doaj)));
                    }
                    catch (JsonProcessingException e) {
                        e.printStackTrace();
                    }
                });
            }
        }
    }

    @NotNull
    public static DOAJModel getDoajModel(DOAJEntry doaj) {
        DOAJModel doajModel = new DOAJModel();
        doajModel.setOaStart(doaj.getBibjson().getOa_start());
        doajModel.setEissn(doaj.getBibjson().getEissn());
        doajModel.setIssn(doaj.getBibjson().getPissn());
        doajModel.setJournalTitle(doaj.getBibjson().getTitle());
        doajModel.setReviewProcess(doaj.getBibjson().getEditorial().getReview_process());
        return doajModel;
    }
}

