/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.hive;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphHiveTableImporterJob {
    private static final Logger log = LoggerFactory.getLogger(GraphHiveTableImporterJob.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)GraphHiveTableImporterJob.class.getResourceAsStream("/eu/dnetlib/dhp/oa/graph/hive_table_importer_parameters.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        int numPartitions = Optional.ofNullable(parser.get("numPartitions")).map(Integer::valueOf).orElse(-1);
        log.info("numPartitions: {}", (Object)numPartitions);
        String inputPath = parser.get("inputPath");
        log.info("inputPath: {}", (Object)inputPath);
        String hiveDbName = parser.get("hiveDbName");
        log.info("hiveDbName: {}", (Object)hiveDbName);
        String className = parser.get("className");
        log.info("className: {}", (Object)className);
        Class<?> clazz = Class.forName(className);
        String hiveMetastoreUris = parser.get("hiveMetastoreUris");
        log.info("hiveMetastoreUris: {}", (Object)hiveMetastoreUris);
        SparkConf conf = new SparkConf();
        conf.set("hive.metastore.uris", hiveMetastoreUris);
        SparkSessionSupport.runWithSparkHiveSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> GraphHiveTableImporterJob.loadGraphTable(spark, inputPath, hiveDbName, clazz, numPartitions));
    }

    private static <T extends Oaf> void loadGraphTable(SparkSession spark, String inputPath, String hiveDbName, Class<T> clazz, int numPartitions) {
        Encoder clazzEncoder = Encoders.bean(clazz);
        Dataset dataset = spark.read().schema(clazzEncoder.schema()).json(inputPath);
        if (numPartitions > 0) {
            log.info("repartitioning {} to {} partitions", (Object)clazz.getSimpleName(), (Object)numPartitions);
            dataset = dataset.repartition(numPartitions);
        }
        dataset.write().mode(SaveMode.Overwrite).saveAsTable(ModelSupport.tableIdentifier((String)hiveDbName, clazz));
    }
}

