/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.graph;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.sx.scholix.Scholix;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixCollectedFrom;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixEntityId;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixIdentifier;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixRelationship;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixResource;
import eu.dnetlib.dhp.sx.graph.RelationInfo;
import eu.dnetlib.dhp.sx.graph.ScholexplorerUtils;
import java.io.Serializable;
import org.json4s.AsJsonInput$;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.JValue;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;

public final class ScholexplorerUtils$ {
    public static final ScholexplorerUtils$ MODULE$ = new ScholexplorerUtils$();
    private static final String OPENAIRE_IDENTIFIER_SCHEMA = "OpenAIRE Identifier";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Map<String, ScholexplorerUtils.RelationVocabulary> relations;

    static {
        LazyRef formats$lzy = new LazyRef();
        LazyRef json$lzy = new LazyRef();
        String input = Source$.MODULE$.fromInputStream(MODULE$.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/relation/relations.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        relations = (Map)ExtractableJsonAstNode$.MODULE$.extract$extension(package$.MODULE$.jvalue2extractable(ScholexplorerUtils$.json$1(json$lzy, input)), (Formats)ScholexplorerUtils$.formats$1(formats$lzy), ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(ScholexplorerUtils.RelationVocabulary.class)})));
    }

    public String OPENAIRE_IDENTIFIER_SCHEMA() {
        return OPENAIRE_IDENTIFIER_SCHEMA;
    }

    public ObjectMapper mapper() {
        return mapper;
    }

    public Map<String, ScholexplorerUtils.RelationVocabulary> relations() {
        return relations;
    }

    public String invRel(String rel) {
        ScholexplorerUtils.RelationVocabulary semanticRelation = (ScholexplorerUtils.RelationVocabulary)this.relations().getOrElse((Object)rel.toLowerCase(), (Function0 & Serializable)() -> null);
        if (semanticRelation != null) {
            return semanticRelation.inverse();
        }
        return null;
    }

    public String generateDatasourceOpenAIREURLS(String id) {
        if (id != null && id.length() > 12) {
            return "https://explore.openaire.eu/search/dataprovider?datasourceId=" + id.substring(3);
        }
        return null;
    }

    public List<Tuple2<StructuredProperty, String>> findURLForPID(List<StructuredProperty> pidValue, List<String> urls) {
        return pidValue.map((Function1 & Serializable)p -> {
            String pv = p.getValue();
            Option r = urls.find((Function1 & Serializable)u -> BoxesRunTime.boxToBoolean((boolean)ScholexplorerUtils$.$anonfun$findURLForPID$2(pv, u)));
            return new Tuple2(p, r.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        });
    }

    public List<ScholixIdentifier> extractTypedIdentifierFromInstance(Result r) {
        if (r.getInstance() == null || r.getInstance().isEmpty()) {
            return Nil$.MODULE$;
        }
        return ((IterableOnceOps)((SeqOps)((IterableOps)((IterableOps)((IterableOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(r.getInstance()).asScala()).filter((Function1 & Serializable)i -> BoxesRunTime.boxToBoolean((boolean)ScholexplorerUtils$.$anonfun$extractTypedIdentifierFromInstance$1(i)))).filter((Function1 & Serializable)i -> BoxesRunTime.boxToBoolean((boolean)ScholexplorerUtils$.$anonfun$extractTypedIdentifierFromInstance$2(i)))).flatMap((Function1 & Serializable)i -> MODULE$.findURLForPID((List<StructuredProperty>)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(i.getPid()).asScala()).toList(), (List<String>)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(i.getUrl()).asScala()).toList()))).map((Function1 & Serializable)i -> new ScholixIdentifier(((StructuredProperty)i._1()).getValue(), ((StructuredProperty)i._1()).getQualifier().getClassid(), (String)i._2()))).distinct()).toList();
    }

    public ScholixResource generateScholixResourceFromResult(Result result) {
        List dt;
        List authors;
        if (result.getInstance() == null || result.getInstance().size() == 0) {
            return null;
        }
        if (result.getPid() == null || result.getPid().isEmpty()) {
            return null;
        }
        ScholixResource r = new ScholixResource();
        r.setDnetIdentifier(result.getId());
        List<ScholixIdentifier> persistentIdentifiers = this.extractTypedIdentifierFromInstance(result);
        if (persistentIdentifiers.isEmpty()) {
            return null;
        }
        r.setIdentifier((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(persistentIdentifiers).asJava());
        r.setObjectType(result.getResulttype().getClassid());
        r.setObjectSubType((String)((IterableOps)((SeqOps)((IterableOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(result.getInstance()).asScala()).filter((Function1 & Serializable)i -> BoxesRunTime.boxToBoolean((boolean)ScholexplorerUtils$.$anonfun$generateScholixResourceFromResult$1(i)))).map((Function1 & Serializable)i -> i.getInstancetype().getClassname())).distinct()).head());
        if (result.getTitle() != null && ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(result.getTitle()).asScala()).nonEmpty()) {
            List titles = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(result.getTitle()).asScala()).map((Function1 & Serializable)t -> t.getValue())).toList();
            if (titles.nonEmpty()) {
                r.setTitle((String)titles.head());
            } else {
                return null;
            }
        }
        if (result.getAuthor() != null && !result.getAuthor().isEmpty() && (authors = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(result.getAuthor()).asScala()).map((Function1 & Serializable)a -> {
            ScholixEntityId entity;
            block0: {
                entity = new ScholixEntityId();
                entity.setName(a.getFullname());
                if (a.getPid() == null || a.getPid().size() <= 0) break block0;
                entity.setIdentifiers((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((IterableOnceOps)((IterableOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(a.getPid()).asScala()).map((Function1 & Serializable)sp2 -> {
                    ScholixIdentifier id = new ScholixIdentifier();
                    id.setIdentifier(sp2.getValue());
                    id.setSchema(sp2.getQualifier().getClassid());
                    return id;
                })).take(3)).toList()).asJava());
            }
            return entity;
        })).toList()).nonEmpty()) {
            r.setCreator((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)authors).asJava());
        }
        if ((dt = ((IterableOnceOps)((IterableOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(result.getInstance()).asScala()).filter((Function1 & Serializable)i -> BoxesRunTime.boxToBoolean((boolean)ScholexplorerUtils$.$anonfun$generateScholixResourceFromResult$6(i)))).map((Function1 & Serializable)i -> (String)i.getDateofacceptance().getValue())).toList()).nonEmpty()) {
            r.setPublicationDate((String)((IterableOps)dt.distinct()).head());
        }
        r.setPublisher((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((SeqOps)((IterableOps)((IterableOps)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(result.getInstance()).asScala()).map((Function1 & Serializable)i -> i.getHostedby())).filter((Function1 & Serializable)h -> BoxesRunTime.boxToBoolean((boolean)ScholexplorerUtils$.$anonfun$generateScholixResourceFromResult$9(h)))).map((Function1 & Serializable)h -> {
            ScholixEntityId eid = new ScholixEntityId();
            eid.setName(h.getValue());
            ScholixIdentifier id = new ScholixIdentifier();
            id.setIdentifier(h.getKey());
            id.setSchema(MODULE$.OPENAIRE_IDENTIFIER_SCHEMA());
            id.setUrl(MODULE$.generateDatasourceOpenAIREURLS(h.getKey()));
            eid.setIdentifiers((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)id, (List)Nil$.MODULE$)).asJava());
            return eid;
        })).distinct()).asJava());
        r.setCollectedFrom((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(result.getCollectedfrom()).asScala()).map((Function1 & Serializable)cf -> {
            ScholixCollectedFrom scf = new ScholixCollectedFrom();
            scf.setProvisionMode("collected");
            scf.setCompletionStatus("complete");
            ScholixEntityId eid = new ScholixEntityId();
            eid.setName(cf.getValue());
            ScholixIdentifier id = new ScholixIdentifier();
            id.setIdentifier(cf.getKey());
            id.setSchema(MODULE$.OPENAIRE_IDENTIFIER_SCHEMA());
            id.setUrl(MODULE$.generateDatasourceOpenAIREURLS(cf.getKey()));
            eid.setIdentifiers((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)id, (List)Nil$.MODULE$)).asJava());
            scf.setProvider(eid);
            return scf;
        })).asJava());
        return r;
    }

    public Scholix generateScholix(RelationInfo relation, ScholixResource source) {
        Scholix s = new Scholix();
        s.setSource(source);
        if (relation.collectedfrom() != null && relation.collectedfrom().nonEmpty()) {
            s.setLinkprovider((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((IterableOnceOps)relation.collectedfrom().map((Function1 & Serializable)cf -> {
                ScholixEntityId eid = new ScholixEntityId();
                eid.setName(cf.value());
                ScholixIdentifier id = new ScholixIdentifier();
                id.setIdentifier(cf.key());
                id.setSchema(MODULE$.OPENAIRE_IDENTIFIER_SCHEMA());
                id.setUrl(MODULE$.generateDatasourceOpenAIREURLS(cf.key()));
                eid.setIdentifiers((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)id, (List)Nil$.MODULE$)).asJava());
                return eid;
            })).toList()).asJava());
        } else {
            ScholixEntityId eid = new ScholixEntityId();
            eid.setName("OpenAIRE");
            ScholixIdentifier id = new ScholixIdentifier();
            id.setIdentifier("10|infrastruct_::f66f1bd369679b5b077dcdf006089556");
            id.setSchema(this.OPENAIRE_IDENTIFIER_SCHEMA());
            id.setUrl(this.generateDatasourceOpenAIREURLS(id.getIdentifier()));
            eid.setIdentifiers((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)id, (List)Nil$.MODULE$)).asJava());
            s.setLinkprovider((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)eid, (List)Nil$.MODULE$)).asJava());
        }
        s.setIdentifier(relation.id());
        ScholexplorerUtils.RelationVocabulary semanticRelation = (ScholexplorerUtils.RelationVocabulary)this.relations().getOrElse((Object)relation.relclass().toLowerCase(), (Function0 & Serializable)() -> null);
        if (semanticRelation == null) {
            return null;
        }
        s.setRelationship(new ScholixRelationship(semanticRelation.original(), "datacite", semanticRelation.inverse()));
        s.setPublicationDate(source.getPublicationDate());
        s.setPublisher(source.getPublisher());
        ScholixResource mockTarget = new ScholixResource();
        mockTarget.setDnetIdentifier(relation.target());
        s.setTarget(mockTarget);
        return s;
    }

    public String updateTarget(Scholix s, ScholixResource t) {
        s.setTarget(t);
        Nil$ spublishers = s.getPublisher() != null && !s.getPublisher().isEmpty() ? ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(s.getPublisher()).asScala()).toList() : Nil$.MODULE$;
        Nil$ tpublishers = t.getPublisher() != null && !t.getPublisher().isEmpty() ? ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(t.getPublisher()).asScala()).toList() : Nil$.MODULE$;
        List mergedPublishers = ((IterableOnceOps)((IterableOps)((SeqOps)spublishers.union((Seq)tpublishers)).distinct()).take(10)).toList();
        s.setPublisher((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)mergedPublishers).asJava());
        return this.mapper().writeValueAsString((Object)s);
    }

    private static final /* synthetic */ DefaultFormats$ formats$lzycompute$1(LazyRef formats$lzy$1) {
        DefaultFormats$ defaultFormats$;
        LazyRef lazyRef = formats$lzy$1;
        synchronized (lazyRef) {
            defaultFormats$ = formats$lzy$1.initialized() ? (DefaultFormats$)formats$lzy$1.value() : (DefaultFormats$)formats$lzy$1.initialize((Object)DefaultFormats$.MODULE$);
        }
        return defaultFormats$;
    }

    private static final DefaultFormats$ formats$1(LazyRef formats$lzy$1) {
        if (formats$lzy$1.initialized()) {
            return (DefaultFormats$)formats$lzy$1.value();
        }
        return ScholexplorerUtils$.formats$lzycompute$1(formats$lzy$1);
    }

    private static final /* synthetic */ JValue json$lzycompute$1(LazyRef json$lzy$1, String input$1) {
        JValue jValue;
        LazyRef lazyRef = json$lzy$1;
        synchronized (lazyRef) {
            jValue = json$lzy$1.initialized() ? (JValue)json$lzy$1.value() : (JValue)json$lzy$1.initialize((Object)JsonMethods$.MODULE$.parse((Object)input$1, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput()));
        }
        return jValue;
    }

    private static final JValue json$1(LazyRef json$lzy$1, String input$1) {
        if (json$lzy$1.initialized()) {
            return (JValue)json$lzy$1.value();
        }
        return ScholexplorerUtils$.json$lzycompute$1(json$lzy$1, input$1);
    }

    public static final /* synthetic */ boolean $anonfun$findURLForPID$2(String pv$1, String u) {
        return u.toLowerCase().contains(pv$1.toLowerCase());
    }

    public static final /* synthetic */ boolean $anonfun$extractTypedIdentifierFromInstance$1(Instance i) {
        return i.getUrl() != null && !i.getUrl().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$extractTypedIdentifierFromInstance$2(Instance i) {
        return i.getPid() != null && i.getUrl() != null;
    }

    public static final /* synthetic */ boolean $anonfun$generateScholixResourceFromResult$1(Instance i) {
        return i != null && i.getInstancetype() != null;
    }

    public static final /* synthetic */ boolean $anonfun$generateScholixResourceFromResult$6(Instance i) {
        return i.getDateofacceptance() != null;
    }

    public static final /* synthetic */ boolean $anonfun$generateScholixResourceFromResult$9(KeyValue h) {
        return !"unknown".equalsIgnoreCase(h.getValue());
    }

    private ScholexplorerUtils$() {
    }
}

