/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.graph.group;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.HdfsSupport;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.oa.merge.GroupEntitiesSparkJob;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.oaf.InstanceTypeMapping;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.utils.DHPUtils;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
public class GroupEntitiesSparkJobTest {
    @Mock
    private ISLookUpService isLookUpService;
    private VocabularyGroup vocabularies;
    private static SparkSession spark;
    private static ObjectMapper mapper;
    private static Path workingDir;
    private Path dataInputPath;
    private Path checkpointPath;
    private Path outputPath;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(GroupEntitiesSparkJobTest.class.getSimpleName(), new FileAttribute[0]);
        SparkConf conf = new SparkConf();
        conf.setAppName(GroupEntitiesSparkJobTest.class.getSimpleName());
        conf.setMaster("local");
        conf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        conf.registerKryoClasses(ModelSupport.getOafModelClasses());
        spark = SparkSession.builder().config(conf).getOrCreate();
    }

    @BeforeEach
    public void beforeEach() throws IOException, URISyntaxException, ISLookUpException {
        this.dataInputPath = Paths.get(ClassLoader.getSystemResource("eu/dnetlib/dhp/oa/graph/group").toURI());
        this.checkpointPath = workingDir.resolve("grouped_entity");
        this.outputPath = workingDir.resolve("dispatched_entity");
        Mockito.lenient().when((Object)this.isLookUpService.quickSearchProfile("for $x in collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType') \nlet $vocid := $x//VOCABULARY_NAME/@code\nlet $vocname := $x//VOCABULARY_NAME/text()\nfor $term in ($x//TERM)\nreturn concat($vocid,' @=@ ',$vocname,' @=@ ',$term/@code,' @=@ ',$term/@english_name)")).thenReturn(this.vocs());
        Mockito.lenient().when((Object)this.isLookUpService.quickSearchProfile("for $x in collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType')\nlet $vocid := $x//VOCABULARY_NAME/@code\nlet $vocname := $x//VOCABULARY_NAME/text()\nfor $term in ($x//TERM)\nfor $syn in ($term//SYNONYM/@term)\nreturn concat($vocid,' @=@ ',$term/@code,' @=@ ', $syn)\n")).thenReturn(this.synonyms());
        this.vocabularies = VocabularyGroup.loadVocsFromIS((ISLookUpService)this.isLookUpService);
    }

    @AfterAll
    public static void afterAll() throws IOException {
        spark.stop();
        FileUtils.deleteDirectory((File)workingDir.toFile());
    }

    @Test
    @Order(value=1)
    void testGroupEntities() throws Exception {
        new GroupEntitiesSparkJob(this.args("/eu/dnetlib/dhp/oa/merge/group_graph_entities_parameters.json", new String[]{"--isSparkSessionManaged", Boolean.FALSE.toString(), "--graphInputPath", this.dataInputPath.toString(), "--checkpointPath", this.checkpointPath.toString(), "--outputPath", this.outputPath.toString(), "--filterInvisible", Boolean.FALSE.toString(), "--isLookupUrl", "lookupurl"})).run(Boolean.valueOf(false), this.isLookUpService);
        Dataset checkpointTable = spark.read().load(this.checkpointPath.toString()).selectExpr(new String[]{"COALESCE(*)"}).as(Encoders.kryo(OafEntity.class));
        Assertions.assertEquals((long)1L, (long)checkpointTable.filter((FilterFunction & Serializable)r -> "50|doi_________::09821844208a5cd6300b2bfb13bca1b9".equals(r.getId()) && r.getCollectedfrom().stream().anyMatch(kv -> kv.getValue().equalsIgnoreCase("zenodo"))).count());
        List output = spark.read().textFile(DHPUtils.toSeq((List)HdfsSupport.listFiles((String)this.outputPath.toString(), (Configuration)spark.sparkContext().hadoopConfiguration())).toSeq()).map((MapFunction & Serializable)s -> (Result)mapper.readValue(s, Result.class), Encoders.bean(Result.class)).collectAsList();
        Assertions.assertEquals((int)3, (int)output.size());
        Set resultTypes = output.stream().map(value -> value.getResulttype().getClassid()).collect(Collectors.toSet());
        Assertions.assertEquals((int)1, (int)resultTypes.size());
        Assertions.assertEquals((long)3L, (long)output.stream().map(r -> r.getResulttype().getClassid()).filter(s -> s.equals("publication")).count());
        Assertions.assertEquals((long)0L, (long)output.stream().map(r -> r.getResulttype().getClassid()).filter(s -> s.equals("dataset")).count());
        Result result = output.stream().filter(r -> "50|doi_________::09821844208a5cd6300b2bfb13bca1b9".equals(r.getId())).findFirst().get();
        result.getInstance().forEach(instance -> {
            Optional<InstanceTypeMapping> coarType = instance.getInstanceTypeMapping().stream().filter(itm -> "openaire::coar_resource_types_3_1".equals(itm.getVocabularyName())).filter(itm -> "journal-article".equals(itm.getOriginalType())).findFirst();
            Assertions.assertTrue((boolean)coarType.isPresent());
            Assertions.assertEquals((Object)"http://purl.org/coar/resource_type/c_2df8fbb1", (Object)coarType.get().getTypeCode());
            Assertions.assertEquals((Object)"research article", (Object)coarType.get().getTypeLabel());
        });
        List filtered = output.stream().filter(r -> "50|DansKnawCris::203a27996ddc0fd1948258e5b7dec61c".equals(r.getId())).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)filtered.size());
        result = (Result)filtered.get(0);
        result.getInstance().stream().flatMap(instance -> instance.getInstanceTypeMapping().stream()).filter(itm -> "openaire::coar_resource_types_3_1".equals(itm.getVocabularyName())).filter(itm -> "Patent".equals(itm.getOriginalType())).forEach(itm -> {
            Assertions.assertEquals((Object)"http://purl.org/coar/resource_type/c_15cd", (Object)itm.getTypeCode());
            Assertions.assertEquals((Object)"patent", (Object)itm.getTypeLabel());
        });
    }

    private List<String> vocs() throws IOException {
        return IOUtils.readLines((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/oa/graph/clean/terms.txt")), (Charset)Charset.defaultCharset());
    }

    private List<String> synonyms() throws IOException {
        return IOUtils.readLines((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/oa/graph/clean/synonyms.txt")), (Charset)Charset.defaultCharset());
    }

    private ArgumentApplicationParser args(String paramSpecs, String[] args) throws IOException, ParseException {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(GroupEntitiesSparkJobTest.classPathResourceAsString(paramSpecs));
        parser.parseArgument(args);
        return parser;
    }

    private static String classPathResourceAsString(String path) throws IOException {
        return IOUtils.toString((InputStream)Objects.requireNonNull(GroupEntitiesSparkJobTest.class.getResourceAsStream(path)), (Charset)Charset.defaultCharset());
    }

    static {
        mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

