/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision.utils;

import eu.dnetlib.dhp.oa.provision.utils.GraphMappingUtils;
import eu.dnetlib.dhp.oa.provision.utils.TemplateResources;
import eu.dnetlib.dhp.oa.provision.utils.XmlSerializationUtils;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.stringtemplate.v4.ST;

public class TemplateFactory {
    private final TemplateResources resources;
    private static final char DELIMITER = '$';

    public TemplateFactory() {
        try {
            this.resources = new TemplateResources();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String buildBody(String type, List<String> metadata, List<String> rels, List<String> children, List<String> extraInfo) {
        ST body = this.getTemplate(this.resources.getEntity());
        body.add("name", (Object)type);
        body.add("metadata", metadata);
        body.add("rels", rels);
        body.add("children", children);
        body.add("extrainfo", extraInfo);
        return body.render();
    }

    public String getChild(String name, String id, List<String> metadata) {
        return this.getTemplate(this.resources.getChild()).add("name", (Object)name).add("hasId", (Object)(id != null ? 1 : 0)).add("id", (Object)(id != null ? XmlSerializationUtils.escapeXml(GraphMappingUtils.removePrefix(id)) : "")).add("metadata", metadata).render();
    }

    public String buildRecord(OafEntity entity, String schemaLocation, String body) {
        return this.getTemplate(this.resources.getRecord()).add("id", (Object)XmlSerializationUtils.escapeXml(GraphMappingUtils.removePrefix(entity.getId()))).add("dateofcollection", (Object)entity.getDateofcollection()).add("dateoftransformation", (Object)entity.getDateoftransformation()).add("schemaLocation", (Object)schemaLocation).add("it", (Object)body).render();
    }

    public String getRel(String type, String objIdentifier, Collection<String> fields, String semanticclass, String semantischeme, DataInfo info) {
        return this.getTemplate(this.resources.getRel()).add("type", (Object)type).add("objIdentifier", (Object)XmlSerializationUtils.escapeXml(GraphMappingUtils.removePrefix(objIdentifier))).add("class", (Object)semanticclass).add("scheme", (Object)semantischeme).add("metadata", fields).add("inferred", (Object)info.getInferred()).add("trust", (Object)info.getTrust()).add("inferenceprovenance", (Object)info.getInferenceprovenance()).add("provenanceaction", (Object)(info.getProvenanceaction() != null ? info.getProvenanceaction().getClassid() : "")).render();
    }

    public String getInstance(String resultId, List<String> instancemetadata, List<String> webresources) {
        return this.getTemplate(this.resources.getInstance()).add("instanceId", (Object)XmlSerializationUtils.escapeXml(GraphMappingUtils.removePrefix(resultId))).add("metadata", instancemetadata).add("webresources", webresources.stream().filter(StringUtils::isNotBlank).map(w -> this.getWebResource((String)w)).collect(Collectors.toList())).render();
    }

    private String getWebResource(String identifier) {
        return this.getTemplate(this.resources.getWebresource()).add("identifier", (Object)XmlSerializationUtils.escapeXml(identifier)).render();
    }

    private ST getTemplate(String res) {
        return new ST(res, '$', '$');
    }
}

