/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision.utils;

import com.google.common.collect.Lists;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.solr.common.SolrInputDocument;

public class StreamingInputDocumentFactory {
    private static final String INDEX_FIELD_PREFIX = "__";
    private static final String DS_VERSION = "__dsversion";
    private static final String DS_ID = "__dsid";
    private static final String RESULT = "result";
    private static final String INDEX_RESULT = "__result";
    private static final String INDEX_RECORD_ID = "__indexrecordidentifier";
    private static final String outFormat = "yyyy-MM-dd'T'hh:mm:ss'Z'";
    private static final List<String> dateFormats = Arrays.asList("yyyy-MM-dd'T'hh:mm:ss", "yyyy-MM-dd", "dd-MM-yyyy", "dd/MM/yyyy", "yyyy");
    private static final String DEFAULTDNETRESULT = "dnetResult";
    private static final String TARGETFIELDS = "targetFields";
    private static final String INDEX_RECORD_ID_ELEMENT = "indexRecordIdentifier";
    private static final String ROOT_ELEMENT = "indexRecord";
    private static final int MAX_FIELD_LENGTH = 25000;
    private final ThreadLocal<XMLInputFactory> inputFactory = ThreadLocal.withInitial(() -> XMLInputFactory.newInstance());
    private final ThreadLocal<XMLOutputFactory> outputFactory = ThreadLocal.withInitial(() -> XMLOutputFactory.newInstance());
    private final ThreadLocal<XMLEventFactory> eventFactory = ThreadLocal.withInitial(() -> XMLEventFactory.newInstance());
    private final String version;
    private final String dsId;
    private String resultName = "dnetResult";

    public StreamingInputDocumentFactory(String version, String dsId) {
        this(version, dsId, DEFAULTDNETRESULT);
    }

    public StreamingInputDocumentFactory(String version, String dsId, String resultName) {
        this.version = version;
        this.dsId = dsId;
        this.resultName = resultName;
    }

    public SolrInputDocument parseDocument(String inputDocument) {
        StringWriter results = new StringWriter();
        LinkedList nsList = Lists.newLinkedList();
        try {
            XMLEventReader parser = this.inputFactory.get().createXMLEventReader(new StringReader(inputDocument));
            SolrInputDocument indexDocument = new SolrInputDocument(new HashMap());
            while (parser.hasNext()) {
                XMLEvent event = parser.nextEvent();
                if (event == null || !event.isStartElement()) continue;
                String localName = event.asStartElement().getName().getLocalPart();
                if (ROOT_ELEMENT.equals(localName)) {
                    nsList.addAll(this.getNamespaces(event));
                    continue;
                }
                if (INDEX_RECORD_ID_ELEMENT.equals(localName)) {
                    XMLEvent text = parser.nextEvent();
                    String recordId = this.getText(text);
                    indexDocument.addField(INDEX_RECORD_ID, (Object)recordId);
                    continue;
                }
                if (TARGETFIELDS.equals(localName)) {
                    this.parseTargetFields(indexDocument, parser);
                    continue;
                }
                if (!this.resultName.equals(localName)) continue;
                this.copyResult(indexDocument, results, parser, nsList, this.resultName);
            }
            if (this.version != null) {
                indexDocument.addField(DS_VERSION, (Object)this.version);
            }
            if (this.dsId != null) {
                indexDocument.addField(DS_ID, (Object)this.dsId);
            }
            if (!indexDocument.containsKey((Object)INDEX_RECORD_ID)) {
                indexDocument.clear();
                System.err.println("missing indexrecord id:\n" + inputDocument);
            }
            return indexDocument;
        }
        catch (XMLStreamException e) {
            return new SolrInputDocument(new String[0]);
        }
    }

    private List<Namespace> getNamespaces(XMLEvent event) {
        LinkedList res = Lists.newLinkedList();
        Iterator<Namespace> nsIter = event.asStartElement().getNamespaces();
        while (nsIter.hasNext()) {
            Namespace ns = nsIter.next();
            res.add(ns);
        }
        return res;
    }

    protected void parseTargetFields(SolrInputDocument indexDocument, XMLEventReader parser) throws XMLStreamException {
        XMLEvent targetEvent;
        boolean hasFields = false;
        while (!(!parser.hasNext() || (targetEvent = parser.nextEvent()).isEndElement() && targetEvent.asEndElement().getName().getLocalPart().equals(TARGETFIELDS))) {
            if (!targetEvent.isStartElement()) continue;
            String fieldName = targetEvent.asStartElement().getName().getLocalPart();
            XMLEvent text = parser.nextEvent();
            String data = this.getText(text);
            this.addField(indexDocument, fieldName, data);
            hasFields = true;
        }
        if (!hasFields) {
            indexDocument.clear();
        }
    }

    protected void copyResult(SolrInputDocument indexDocument, StringWriter results, XMLEventReader parser, List<Namespace> nsList, String dnetResult) throws XMLStreamException {
        XMLEventWriter writer = this.outputFactory.get().createXMLEventWriter(results);
        for (Namespace ns : nsList) {
            this.eventFactory.get().createNamespace(ns.getPrefix(), ns.getNamespaceURI());
        }
        StartElement newRecord = this.eventFactory.get().createStartElement("", null, RESULT, null, nsList.iterator());
        writer.add(newRecord);
        while (parser.hasNext()) {
            XMLEvent resultEvent = parser.nextEvent();
            if (resultEvent.isEndElement() && resultEvent.asEndElement().getName().getLocalPart().equals(dnetResult)) {
                writer.add(this.eventFactory.get().createEndElement("", null, RESULT));
                break;
            }
            writer.add(resultEvent);
        }
        writer.close();
        indexDocument.addField(INDEX_RESULT, (Object)results.toString());
    }

    private final void addField(SolrInputDocument indexDocument, String field, String value) {
        String cleaned = value.trim();
        if (!cleaned.isEmpty()) {
            indexDocument.addField(field.toLowerCase(), (Object)cleaned);
        }
    }

    protected final String getText(XMLEvent text) {
        if (text.isEndElement()) {
            return "";
        }
        String data = text.asCharacters().getData();
        if (data != null && data.length() > 25000) {
            return data.substring(0, 25000);
        }
        return data;
    }
}

