/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mycila.xmltool.XMLDoc;
import com.mycila.xmltool.XMLTag;
import eu.dnetlib.dhp.oa.provision.model.JoinedEntity;
import eu.dnetlib.dhp.oa.provision.model.RelatedEntity;
import eu.dnetlib.dhp.oa.provision.model.Tuple2;
import eu.dnetlib.dhp.oa.provision.model.TypedRow;
import eu.dnetlib.dhp.oa.provision.utils.ContextDef;
import eu.dnetlib.dhp.oa.provision.utils.ContextMapper;
import eu.dnetlib.dhp.oa.provision.utils.GraphMappingUtils;
import eu.dnetlib.dhp.oa.provision.utils.TemplateFactory;
import eu.dnetlib.dhp.oa.provision.utils.XmlSerializationUtils;
import eu.dnetlib.dhp.schema.common.EntityType;
import eu.dnetlib.dhp.schema.common.MainEntityType;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.ExternalReference;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.Journal;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Project;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.Software;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.util.LongAccumulator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.w3c.dom.Element;

public class XmlRecordFactory
implements Serializable {
    private static final String REL_SUBTYPE_DEDUP = "dedup";
    private final Map<String, LongAccumulator> accumulators;
    private final Set<String> specialDatasourceTypes;
    private final ContextMapper contextMapper;
    private final String schemaLocation;
    private boolean indent = false;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public XmlRecordFactory(ContextMapper contextMapper, boolean indent, String schemaLocation, String otherDatasourceTypesUForUI) {
        this(Maps.newHashMap(), contextMapper, indent, schemaLocation, otherDatasourceTypesUForUI);
    }

    public XmlRecordFactory(Map<String, LongAccumulator> accumulators, ContextMapper contextMapper, boolean indent, String schemaLocation, String otherDatasourceTypesUForUI) {
        this.accumulators = accumulators;
        this.contextMapper = contextMapper;
        this.schemaLocation = schemaLocation;
        this.specialDatasourceTypes = Sets.newHashSet((Iterable)Splitter.on((String)",").trimResults().split((CharSequence)otherDatasourceTypesUForUI));
        this.indent = indent;
    }

    public String build(JoinedEntity je) {
        HashSet contexts = Sets.newHashSet();
        OafEntity entity = XmlRecordFactory.toOafEntity(je.getEntity());
        TemplateFactory templateFactory = new TemplateFactory();
        try {
            EntityType type = EntityType.valueOf((String)je.getEntity().getType());
            List<String> metadata = this.metadata(type, entity, contexts);
            List relations = je.getLinks().stream().filter(link -> !this.isDuplicate((Tuple2)link)).map(link -> this.mapRelation(contexts, templateFactory, type, (Tuple2)link)).collect(Collectors.toCollection(ArrayList::new));
            String mainType = ModelSupport.getMainType((EntityType)type);
            metadata.addAll(this.buildContexts(mainType, contexts));
            metadata.add(XmlSerializationUtils.parseDataInfo(entity.getDataInfo()));
            String body = templateFactory.buildBody(mainType, metadata, relations, this.listChildren(entity, je, templateFactory), this.listExtraInfo(entity));
            return this.printXML(templateFactory.buildRecord(entity, this.schemaLocation, body), this.indent);
        }
        catch (Throwable e) {
            throw new RuntimeException(String.format("error building record '%s'", entity.getId()), e);
        }
    }

    private static OafEntity toOafEntity(TypedRow typedRow) {
        return XmlRecordFactory.parseOaf(typedRow.getOaf(), typedRow.getType());
    }

    private static OafEntity parseOaf(String json, String type) {
        try {
            switch (EntityType.valueOf((String)type)) {
                case publication: {
                    return (OafEntity)OBJECT_MAPPER.readValue(json, Publication.class);
                }
                case dataset: {
                    return (OafEntity)OBJECT_MAPPER.readValue(json, Dataset.class);
                }
                case otherresearchproduct: {
                    return (OafEntity)OBJECT_MAPPER.readValue(json, OtherResearchProduct.class);
                }
                case software: {
                    return (OafEntity)OBJECT_MAPPER.readValue(json, Software.class);
                }
                case datasource: {
                    return (OafEntity)OBJECT_MAPPER.readValue(json, Datasource.class);
                }
                case organization: {
                    return (OafEntity)OBJECT_MAPPER.readValue(json, Organization.class);
                }
                case project: {
                    return (OafEntity)OBJECT_MAPPER.readValue(json, Project.class);
                }
            }
            throw new IllegalArgumentException("invalid type: " + type);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String printXML(String xml, boolean indent) {
        try {
            Document doc = new SAXReader().read((Reader)new StringReader(xml));
            OutputFormat format = indent ? OutputFormat.createPrettyPrint() : OutputFormat.createCompactFormat();
            format.setExpandEmptyElements(false);
            format.setSuppressDeclaration(true);
            StringWriter sw = new StringWriter();
            XMLWriter writer = new XMLWriter((Writer)sw, format);
            writer.write(doc);
            return sw.toString();
        }
        catch (IOException | DocumentException e) {
            throw new IllegalArgumentException("Unable to indent XML. Invalid record:\n" + xml, e);
        }
    }

    private List<String> metadata(EntityType type, OafEntity entity, Set<String> contexts) {
        ArrayList metadata = Lists.newArrayList();
        if (entity.getCollectedfrom() != null) {
            metadata.addAll(entity.getCollectedfrom().stream().filter(XmlRecordFactory::kvNotBlank).map(kv -> XmlSerializationUtils.mapKeyValue("collectedfrom", kv)).collect(Collectors.toList()));
        }
        if (entity.getOriginalId() != null) {
            metadata.addAll(entity.getOriginalId().stream().filter(Objects::nonNull).map(s -> XmlSerializationUtils.asXmlElement("originalId", s)).collect(Collectors.toList()));
        }
        if (entity.getPid() != null) {
            metadata.addAll(entity.getPid().stream().filter(Objects::nonNull).map(p -> XmlSerializationUtils.mapStructuredProperty("pid", p)).collect(Collectors.toList()));
        }
        if (ModelSupport.isResult((EntityType)type)) {
            Result r = (Result)entity;
            if (r.getContext() != null) {
                contexts.addAll(r.getContext().stream().map(c -> c.getId()).collect(Collectors.toList()));
                if (contexts.contains("dh-ch::subcommunity::2")) {
                    contexts.add("clarin");
                }
            }
            if (r.getTitle() != null) {
                metadata.addAll(r.getTitle().stream().filter(Objects::nonNull).map(t -> XmlSerializationUtils.mapStructuredProperty("title", t)).collect(Collectors.toList()));
            }
            if (r.getBestaccessright() != null) {
                metadata.add(XmlSerializationUtils.mapQualifier("bestaccessright", r.getBestaccessright()));
            }
            if (r.getAuthor() != null) {
                metadata.addAll(r.getAuthor().stream().filter(Objects::nonNull).map(a -> {
                    StringBuilder sb = new StringBuilder("<creator rank=\"" + a.getRank() + "\"");
                    if (StringUtils.isNotBlank((CharSequence)a.getName())) {
                        sb.append(" name=\"" + XmlSerializationUtils.escapeXml(a.getName()) + "\"");
                    }
                    if (StringUtils.isNotBlank((CharSequence)a.getSurname())) {
                        sb.append(" surname=\"" + XmlSerializationUtils.escapeXml(a.getSurname()) + "\"");
                    }
                    if (a.getPid() != null) {
                        a.getPid().stream().filter(Objects::nonNull).filter(sp -> StringUtils.isNotBlank((CharSequence)sp.getQualifier().getClassid()) && StringUtils.isNotBlank((CharSequence)sp.getValue())).collect(Collectors.toMap(p -> this.getAuthorPidType(p.getQualifier().getClassid()), p -> p, (p1, p2) -> p1)).values().forEach(sp -> {
                            String pidType = this.getAuthorPidType(sp.getQualifier().getClassid());
                            String pidValue = XmlSerializationUtils.escapeXml(sp.getValue());
                            if (GraphMappingUtils.authorPidTypes.contains(pidValue.toLowerCase().trim())) {
                                sb.append(String.format(" %s=\"%s\"", pidValue, pidType));
                            } else if (StringUtils.isNotBlank((CharSequence)pidType)) {
                                sb.append(String.format(" %s=\"%s\"", pidType, pidValue.toLowerCase().replaceAll("orcid", "")));
                            }
                        });
                    }
                    sb.append(">" + XmlSerializationUtils.escapeXml(a.getFullname()) + "</creator>");
                    return sb.toString();
                }).collect(Collectors.toList()));
            }
            if (r.getContributor() != null) {
                metadata.addAll(r.getContributor().stream().filter(Objects::nonNull).map(c -> XmlSerializationUtils.asXmlElement("contributor", (String)c.getValue())).collect(Collectors.toList()));
            }
            if (r.getCountry() != null) {
                metadata.addAll(r.getCountry().stream().filter(Objects::nonNull).map(c -> XmlSerializationUtils.mapQualifier("country", (Qualifier)c)).collect(Collectors.toList()));
            }
            if (r.getCoverage() != null) {
                metadata.addAll(r.getCoverage().stream().filter(Objects::nonNull).map(c -> XmlSerializationUtils.asXmlElement("coverage", (String)c.getValue())).collect(Collectors.toList()));
            }
            if (r.getDateofacceptance() != null) {
                metadata.add(XmlSerializationUtils.asXmlElement("dateofacceptance", (String)r.getDateofacceptance().getValue()));
            }
            if (r.getDescription() != null) {
                metadata.addAll(r.getDescription().stream().filter(Objects::nonNull).map(c -> XmlSerializationUtils.asXmlElement("description", (String)c.getValue())).collect(Collectors.toList()));
            }
            if (r.getEmbargoenddate() != null) {
                metadata.add(XmlSerializationUtils.asXmlElement("embargoenddate", (String)r.getEmbargoenddate().getValue()));
            }
            if (r.getSubject() != null) {
                metadata.addAll(r.getSubject().stream().filter(Objects::nonNull).map(s -> XmlSerializationUtils.mapStructuredProperty("subject", s)).collect(Collectors.toList()));
            }
            if (r.getLanguage() != null) {
                metadata.add(XmlSerializationUtils.mapQualifier("language", r.getLanguage()));
            }
            if (r.getRelevantdate() != null) {
                metadata.addAll(r.getRelevantdate().stream().filter(Objects::nonNull).map(s -> XmlSerializationUtils.mapStructuredProperty("relevantdate", s)).collect(Collectors.toList()));
            }
            if (r.getPublisher() != null) {
                metadata.add(XmlSerializationUtils.asXmlElement("publisher", (String)r.getPublisher().getValue()));
            }
            if (r.getSource() != null) {
                metadata.addAll(r.getSource().stream().filter(Objects::nonNull).map(c -> XmlSerializationUtils.asXmlElement("source", (String)c.getValue())).collect(Collectors.toList()));
            }
            if (r.getFormat() != null) {
                metadata.addAll(r.getFormat().stream().filter(Objects::nonNull).map(c -> XmlSerializationUtils.asXmlElement("format", (String)c.getValue())).collect(Collectors.toList()));
            }
            if (r.getResulttype() != null) {
                metadata.add(XmlSerializationUtils.mapQualifier("resulttype", r.getResulttype()));
            }
            if (r.getResourcetype() != null) {
                metadata.add(XmlSerializationUtils.mapQualifier("resourcetype", r.getResourcetype()));
            }
        }
        switch (type) {
            case publication: {
                Publication pub = (Publication)entity;
                if (pub.getJournal() == null) break;
                Journal j = pub.getJournal();
                metadata.add(XmlSerializationUtils.mapJournal(j));
                break;
            }
            case dataset: {
                Dataset d = (Dataset)entity;
                if (d.getDevice() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("device", (String)d.getDevice().getValue()));
                }
                if (d.getLastmetadataupdate() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("lastmetadataupdate", (String)d.getLastmetadataupdate().getValue()));
                }
                if (d.getMetadataversionnumber() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("metadataversionnumber", (String)d.getMetadataversionnumber().getValue()));
                }
                if (d.getSize() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("size", (String)d.getSize().getValue()));
                }
                if (d.getStoragedate() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("storagedate", (String)d.getStoragedate().getValue()));
                }
                if (d.getVersion() == null) break;
                metadata.add(XmlSerializationUtils.asXmlElement("version", (String)d.getVersion().getValue()));
                break;
            }
            case otherresearchproduct: {
                OtherResearchProduct orp = (OtherResearchProduct)entity;
                if (orp.getContactperson() != null) {
                    metadata.addAll(orp.getContactperson().stream().filter(Objects::nonNull).map(c -> XmlSerializationUtils.asXmlElement("contactperson", (String)c.getValue())).collect(Collectors.toList()));
                }
                if (orp.getContactgroup() != null) {
                    metadata.addAll(orp.getContactgroup().stream().filter(Objects::nonNull).map(c -> XmlSerializationUtils.asXmlElement("contactgroup", (String)c.getValue())).collect(Collectors.toList()));
                }
                if (orp.getTool() == null) break;
                metadata.addAll(orp.getTool().stream().filter(Objects::nonNull).map(c -> XmlSerializationUtils.asXmlElement("tool", (String)c.getValue())).collect(Collectors.toList()));
                break;
            }
            case software: {
                Software s2 = (Software)entity;
                if (s2.getDocumentationUrl() != null) {
                    metadata.addAll(s2.getDocumentationUrl().stream().filter(Objects::nonNull).map(c -> XmlSerializationUtils.asXmlElement("documentationUrl", (String)c.getValue())).collect(Collectors.toList()));
                }
                if (s2.getLicense() != null) {
                    metadata.addAll(s2.getLicense().stream().filter(Objects::nonNull).map(l -> XmlSerializationUtils.mapStructuredProperty("license", l)).collect(Collectors.toList()));
                }
                if (s2.getCodeRepositoryUrl() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("codeRepositoryUrl", (String)s2.getCodeRepositoryUrl().getValue()));
                }
                if (s2.getProgrammingLanguage() == null) break;
                metadata.add(XmlSerializationUtils.mapQualifier("programmingLanguage", s2.getProgrammingLanguage()));
                break;
            }
            case datasource: {
                Datasource ds = (Datasource)entity;
                if (ds.getDatasourcetype() != null) {
                    this.mapDatasourceType(metadata, ds.getDatasourcetype());
                }
                if (ds.getOpenairecompatibility() != null) {
                    metadata.add(XmlSerializationUtils.mapQualifier("openairecompatibility", ds.getOpenairecompatibility()));
                }
                if (ds.getOfficialname() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("officialname", (String)ds.getOfficialname().getValue()));
                }
                if (ds.getEnglishname() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("englishname", (String)ds.getEnglishname().getValue()));
                }
                if (ds.getWebsiteurl() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("websiteurl", (String)ds.getWebsiteurl().getValue()));
                }
                if (ds.getLogourl() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("logourl", (String)ds.getLogourl().getValue()));
                }
                if (ds.getContactemail() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("contactemail", (String)ds.getContactemail().getValue()));
                }
                if (ds.getNamespaceprefix() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("namespaceprefix", (String)ds.getNamespaceprefix().getValue()));
                }
                if (ds.getLatitude() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("latitude", (String)ds.getLatitude().getValue()));
                }
                if (ds.getLongitude() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("longitude", (String)ds.getLongitude().getValue()));
                }
                if (ds.getDateofvalidation() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("dateofvalidation", (String)ds.getDateofvalidation().getValue()));
                }
                if (ds.getDescription() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("description", (String)ds.getDescription().getValue()));
                }
                if (ds.getOdnumberofitems() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("odnumberofitems", (String)ds.getOdnumberofitems().getValue()));
                }
                if (ds.getOdnumberofitemsdate() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("odnumberofitemsdate", (String)ds.getOdnumberofitemsdate().getValue()));
                }
                if (ds.getOdpolicies() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("odpolicies", (String)ds.getOdpolicies().getValue()));
                }
                if (ds.getOdlanguages() != null) {
                    metadata.addAll(ds.getOdlanguages().stream().filter(Objects::nonNull).map(c -> XmlSerializationUtils.asXmlElement("odlanguages", (String)c.getValue())).collect(Collectors.toList()));
                }
                if (ds.getOdcontenttypes() != null) {
                    metadata.addAll(ds.getOdcontenttypes().stream().filter(Objects::nonNull).map(c -> XmlSerializationUtils.asXmlElement("odcontenttypes", (String)c.getValue())).collect(Collectors.toList()));
                }
                if (ds.getAccessinfopackage() != null) {
                    metadata.addAll(ds.getAccessinfopackage().stream().map(c -> XmlSerializationUtils.asXmlElement("accessinfopackage", (String)c.getValue())).collect(Collectors.toList()));
                }
                if (ds.getReleaseenddate() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("releasestartdate", (String)ds.getReleaseenddate().getValue()));
                }
                if (ds.getReleaseenddate() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("releaseenddate", (String)ds.getReleaseenddate().getValue()));
                }
                if (ds.getMissionstatementurl() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("missionstatementurl", (String)ds.getMissionstatementurl().getValue()));
                }
                if (ds.getDataprovider() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("dataprovider", ((Boolean)ds.getDataprovider().getValue()).toString()));
                }
                if (ds.getServiceprovider() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("serviceprovider", ((Boolean)ds.getServiceprovider().getValue()).toString()));
                }
                if (ds.getDatabaseaccesstype() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("databaseaccesstype", (String)ds.getDatabaseaccesstype().getValue()));
                }
                if (ds.getDatauploadtype() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("datauploadtype", (String)ds.getDatauploadtype().getValue()));
                }
                if (ds.getDatabaseaccessrestriction() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("databaseaccessrestriction", (String)ds.getDatabaseaccessrestriction().getValue()));
                }
                if (ds.getDatauploadrestriction() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("datauploadrestriction", (String)ds.getDatauploadrestriction().getValue()));
                }
                if (ds.getVersioning() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("versioning", ((Boolean)ds.getVersioning().getValue()).toString()));
                }
                if (ds.getCitationguidelineurl() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("citationguidelineurl", (String)ds.getCitationguidelineurl().getValue()));
                }
                if (ds.getQualitymanagementkind() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("qualitymanagementkind", (String)ds.getQualitymanagementkind().getValue()));
                }
                if (ds.getPidsystems() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("pidsystems", (String)ds.getPidsystems().getValue()));
                }
                if (ds.getCertificates() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("certificates", (String)ds.getCertificates().getValue()));
                }
                if (ds.getPolicies() != null) {
                    metadata.addAll(ds.getPolicies().stream().filter(XmlRecordFactory::kvNotBlank).map(kv -> XmlSerializationUtils.mapKeyValue("policies", kv)).collect(Collectors.toList()));
                }
                if (ds.getJournal() != null) {
                    metadata.add(XmlSerializationUtils.mapJournal(ds.getJournal()));
                }
                if (ds.getSubjects() == null) break;
                metadata.addAll(ds.getSubjects().stream().filter(Objects::nonNull).map(sp -> XmlSerializationUtils.mapStructuredProperty("subjects", sp)).collect(Collectors.toList()));
                break;
            }
            case organization: {
                Organization o = (Organization)entity;
                if (o.getLegalshortname() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("legalshortname", (String)o.getLegalshortname().getValue()));
                }
                if (o.getLegalname() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("legalname", (String)o.getLegalname().getValue()));
                }
                if (o.getAlternativeNames() != null) {
                    metadata.addAll(o.getAlternativeNames().stream().filter(Objects::nonNull).map(c -> XmlSerializationUtils.asXmlElement("alternativeNames", (String)c.getValue())).collect(Collectors.toList()));
                }
                if (o.getWebsiteurl() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("websiteurl", (String)o.getWebsiteurl().getValue()));
                }
                if (o.getLogourl() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("websiteurl", (String)o.getLogourl().getValue()));
                }
                if (o.getEclegalbody() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("eclegalbody", (String)o.getEclegalbody().getValue()));
                }
                if (o.getEclegalperson() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("eclegalperson", (String)o.getEclegalperson().getValue()));
                }
                if (o.getEcnonprofit() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("ecnonprofit", (String)o.getEcnonprofit().getValue()));
                }
                if (o.getEcresearchorganization() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("ecresearchorganization", (String)o.getEcresearchorganization().getValue()));
                }
                if (o.getEchighereducation() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("echighereducation", (String)o.getEchighereducation().getValue()));
                }
                if (o.getEcinternationalorganization() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("ecinternationalorganizationeurinterests", (String)o.getEcinternationalorganization().getValue()));
                }
                if (o.getEcinternationalorganization() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("ecinternationalorganization", (String)o.getEcinternationalorganization().getValue()));
                }
                if (o.getEcenterprise() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("ecenterprise", (String)o.getEcenterprise().getValue()));
                }
                if (o.getEcsmevalidated() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("ecsmevalidated", (String)o.getEcsmevalidated().getValue()));
                }
                if (o.getEcnutscode() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("ecnutscode", (String)o.getEcnutscode().getValue()));
                }
                if (o.getCountry() == null) break;
                metadata.add(XmlSerializationUtils.mapQualifier("country", o.getCountry()));
                break;
            }
            case project: {
                Project p2 = (Project)entity;
                if (p2.getWebsiteurl() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("websiteurl", (String)p2.getWebsiteurl().getValue()));
                }
                if (p2.getCode() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("code", (String)p2.getCode().getValue()));
                }
                if (p2.getAcronym() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("acronym", (String)p2.getAcronym().getValue()));
                }
                if (p2.getTitle() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("title", (String)p2.getTitle().getValue()));
                }
                if (p2.getStartdate() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("startdate", (String)p2.getStartdate().getValue()));
                }
                if (p2.getEnddate() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("enddate", (String)p2.getEnddate().getValue()));
                }
                if (p2.getCallidentifier() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("callidentifier", (String)p2.getCallidentifier().getValue()));
                }
                if (p2.getKeywords() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("keywords", (String)p2.getKeywords().getValue()));
                }
                if (p2.getDuration() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("duration", (String)p2.getDuration().getValue()));
                }
                if (p2.getEcarticle29_3() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("ecarticle29_3", (String)p2.getEcarticle29_3().getValue()));
                }
                if (p2.getSubjects() != null) {
                    metadata.addAll(p2.getSubjects().stream().filter(Objects::nonNull).map(sp -> XmlSerializationUtils.mapStructuredProperty("subject", sp)).collect(Collectors.toList()));
                }
                if (p2.getContracttype() != null) {
                    metadata.add(XmlSerializationUtils.mapQualifier("contracttype", p2.getContracttype()));
                }
                if (p2.getEcsc39() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("ecsc39", (String)p2.getEcsc39().getValue()));
                }
                if (p2.getContactfullname() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("contactfullname", (String)p2.getContactfullname().getValue()));
                }
                if (p2.getContactfax() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("contactfax", (String)p2.getContactfax().getValue()));
                }
                if (p2.getContactphone() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("contactphone", (String)p2.getContactphone().getValue()));
                }
                if (p2.getContactemail() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("contactemail", (String)p2.getContactemail().getValue()));
                }
                if (p2.getSummary() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("summary", (String)p2.getSummary().getValue()));
                }
                if (p2.getCurrency() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("currency", (String)p2.getCurrency().getValue()));
                }
                if (p2.getTotalcost() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("totalcost", p2.getTotalcost().toString()));
                }
                if (p2.getFundedamount() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("fundedamount", p2.getFundedamount().toString()));
                }
                if (p2.getFundingtree() == null) break;
                metadata.addAll(p2.getFundingtree().stream().filter(Objects::nonNull).map(ft -> (String)ft.getValue()).collect(Collectors.toList()));
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid entity type: " + type);
            }
        }
        return metadata;
    }

    private String getAuthorPidType(String s) {
        return XmlSerializationUtils.escapeXml(s).replaceAll("\\W", "").replaceAll("\\d", "");
    }

    private static boolean kvNotBlank(KeyValue kv) {
        return kv != null && StringUtils.isNotBlank((CharSequence)kv.getKey()) && StringUtils.isNotBlank((CharSequence)kv.getValue());
    }

    private void mapDatasourceType(List<String> metadata, Qualifier dsType) {
        metadata.add(XmlSerializationUtils.mapQualifier("datasourcetype", dsType));
        if (this.specialDatasourceTypes.contains(dsType.getClassid())) {
            dsType.setClassid("other");
            dsType.setClassname("other");
        }
        metadata.add(XmlSerializationUtils.mapQualifier("datasourcetypeui", dsType));
    }

    private List<String> mapFields(Tuple2 link, Set<String> contexts) {
        String accumulatorName;
        Relation rel = link.getRelation();
        RelatedEntity re = link.getRelatedEntity();
        String targetType = link.getRelatedEntity().getType();
        ArrayList metadata = Lists.newArrayList();
        switch (EntityType.valueOf((String)targetType)) {
            case publication: 
            case dataset: 
            case otherresearchproduct: 
            case software: {
                if (re.getTitle() != null && StringUtils.isNotBlank((CharSequence)re.getTitle().getValue())) {
                    metadata.add(XmlSerializationUtils.mapStructuredProperty("title", re.getTitle()));
                }
                if (StringUtils.isNotBlank((CharSequence)re.getDateofacceptance())) {
                    metadata.add(XmlSerializationUtils.asXmlElement("dateofacceptance", re.getDateofacceptance()));
                }
                if (StringUtils.isNotBlank((CharSequence)re.getPublisher())) {
                    metadata.add(XmlSerializationUtils.asXmlElement("publisher", re.getPublisher()));
                }
                if (StringUtils.isNotBlank((CharSequence)re.getCodeRepositoryUrl())) {
                    metadata.add(XmlSerializationUtils.asXmlElement("coderepositoryurl", re.getCodeRepositoryUrl()));
                }
                if (re.getResulttype() != null && re.getResulttype().isBlank()) {
                    metadata.add(XmlSerializationUtils.mapQualifier("resulttype", re.getResulttype()));
                }
                if (re.getCollectedfrom() != null) {
                    metadata.addAll(re.getCollectedfrom().stream().filter(XmlRecordFactory::kvNotBlank).map(kv -> XmlSerializationUtils.mapKeyValue("collectedfrom", kv)).collect(Collectors.toList()));
                }
                if (re.getPid() == null) break;
                metadata.addAll(re.getPid().stream().map(p -> XmlSerializationUtils.mapStructuredProperty("pid", p)).collect(Collectors.toList()));
                break;
            }
            case datasource: {
                if (StringUtils.isNotBlank((CharSequence)re.getOfficialname())) {
                    metadata.add(XmlSerializationUtils.asXmlElement("officialname", re.getOfficialname()));
                }
                if (re.getDatasourcetype() != null && !re.getDatasourcetype().isBlank()) {
                    this.mapDatasourceType(metadata, re.getDatasourcetype());
                }
                if (re.getOpenairecompatibility() == null || re.getOpenairecompatibility().isBlank()) break;
                metadata.add(XmlSerializationUtils.mapQualifier("openairecompatibility", re.getOpenairecompatibility()));
                break;
            }
            case organization: {
                if (StringUtils.isNotBlank((CharSequence)re.getLegalname())) {
                    metadata.add(XmlSerializationUtils.asXmlElement("legalname", re.getLegalname()));
                }
                if (StringUtils.isNotBlank((CharSequence)re.getLegalshortname())) {
                    metadata.add(XmlSerializationUtils.asXmlElement("legalshortname", re.getLegalshortname()));
                }
                if (re.getCountry() == null || re.getCountry().isBlank()) break;
                metadata.add(XmlSerializationUtils.mapQualifier("country", re.getCountry()));
                break;
            }
            case project: {
                if (StringUtils.isNotBlank((CharSequence)re.getProjectTitle())) {
                    metadata.add(XmlSerializationUtils.asXmlElement("title", re.getProjectTitle()));
                }
                if (StringUtils.isNotBlank((CharSequence)re.getCode())) {
                    metadata.add(XmlSerializationUtils.asXmlElement("code", re.getCode()));
                }
                if (StringUtils.isNotBlank((CharSequence)re.getAcronym())) {
                    metadata.add(XmlSerializationUtils.asXmlElement("acronym", re.getAcronym()));
                }
                if (re.getContracttype() != null && !re.getContracttype().isBlank()) {
                    metadata.add(XmlSerializationUtils.mapQualifier("contracttype", re.getContracttype()));
                }
                if (re.getFundingtree() == null || contexts == null) break;
                metadata.addAll(re.getFundingtree().stream().peek(ft -> this.fillContextMap((String)ft, contexts)).map(ft -> XmlRecordFactory.getRelFundingTree(ft)).collect(Collectors.toList()));
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid target type: " + targetType);
            }
        }
        if (this.accumulators.containsKey(accumulatorName = GraphMappingUtils.getRelDescriptor(rel.getRelType(), rel.getSubRelType(), rel.getRelClass()))) {
            this.accumulators.get(accumulatorName).add(1L);
        }
        return metadata;
    }

    private String mapRelation(Set<String> contexts, TemplateFactory templateFactory, EntityType type, Tuple2 link) {
        Relation rel = link.getRelation();
        String targetType = link.getRelatedEntity().getType();
        String scheme = ModelSupport.getScheme((String)type.toString(), (String)targetType);
        if (StringUtils.isBlank((CharSequence)scheme)) {
            throw new IllegalArgumentException(String.format("missing scheme for: <%s - %s>", type.toString(), targetType));
        }
        HashSet fields = Sets.newHashSet(this.mapFields(link, contexts));
        return templateFactory.getRel(targetType, rel.getTarget(), fields, rel.getRelClass(), scheme, rel.getDataInfo());
    }

    private List<String> listChildren(OafEntity entity, JoinedEntity je, TemplateFactory templateFactory) {
        EntityType entityType = EntityType.valueOf((String)je.getEntity().getType());
        List children = je.getLinks().stream().filter(link -> this.isDuplicate((Tuple2)link)).map(link -> {
            String targetType = link.getRelatedEntity().getType();
            String name = ModelSupport.getMainType((EntityType)EntityType.valueOf((String)targetType));
            HashSet fields = Sets.newHashSet(this.mapFields((Tuple2)link, null));
            return templateFactory.getChild(name, link.getRelatedEntity().getId(), Lists.newArrayList((Iterable)fields));
        }).collect(Collectors.toCollection(ArrayList::new));
        if (MainEntityType.result.toString().equals(ModelSupport.getMainType((EntityType)entityType))) {
            List ext;
            List instances = ((Result)entity).getInstance();
            if (instances != null) {
                for (Instance instance : ((Result)entity).getInstance()) {
                    ArrayList fields = Lists.newArrayList();
                    if (instance.getAccessright() != null && !instance.getAccessright().isBlank()) {
                        fields.add(XmlSerializationUtils.mapQualifier("accessright", instance.getAccessright()));
                    }
                    if (instance.getCollectedfrom() != null && XmlRecordFactory.kvNotBlank(instance.getCollectedfrom())) {
                        fields.add(XmlSerializationUtils.mapKeyValue("collectedfrom", instance.getCollectedfrom()));
                    }
                    if (instance.getHostedby() != null && XmlRecordFactory.kvNotBlank(instance.getHostedby())) {
                        fields.add(XmlSerializationUtils.mapKeyValue("hostedby", instance.getHostedby()));
                    }
                    if (instance.getDateofacceptance() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)instance.getDateofacceptance().getValue()))) {
                        fields.add(XmlSerializationUtils.asXmlElement("dateofacceptance", (String)instance.getDateofacceptance().getValue()));
                    }
                    if (instance.getInstancetype() != null && !instance.getInstancetype().isBlank()) {
                        fields.add(XmlSerializationUtils.mapQualifier("instancetype", instance.getInstancetype()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)instance.getDistributionlocation())) {
                        fields.add(XmlSerializationUtils.asXmlElement("distributionlocation", instance.getDistributionlocation()));
                    }
                    if (instance.getRefereed() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)instance.getRefereed().getValue()))) {
                        fields.add(XmlSerializationUtils.asXmlElement("refereed", (String)instance.getRefereed().getValue()));
                    }
                    if (instance.getProcessingchargeamount() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)instance.getProcessingchargeamount().getValue()))) {
                        fields.add(XmlSerializationUtils.asXmlElement("processingchargeamount", (String)instance.getProcessingchargeamount().getValue()));
                    }
                    if (instance.getProcessingchargecurrency() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)instance.getProcessingchargecurrency().getValue()))) {
                        fields.add(XmlSerializationUtils.asXmlElement("processingchargecurrency", (String)instance.getProcessingchargecurrency().getValue()));
                    }
                    children.add(templateFactory.getInstance(instance.getHostedby().getKey(), fields, instance.getUrl()));
                }
            }
            if ((ext = ((Result)entity).getExternalReference()) != null) {
                for (ExternalReference er : ((Result)entity).getExternalReference()) {
                    ArrayList fields = Lists.newArrayList();
                    if (StringUtils.isNotBlank((CharSequence)er.getSitename())) {
                        fields.add(XmlSerializationUtils.asXmlElement("sitename", er.getSitename()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)er.getLabel())) {
                        fields.add(XmlSerializationUtils.asXmlElement("label", er.getLabel()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)er.getUrl())) {
                        fields.add(XmlSerializationUtils.asXmlElement("url", er.getUrl()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)er.getDescription())) {
                        fields.add(XmlSerializationUtils.asXmlElement("description", er.getDescription()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)er.getUrl())) {
                        fields.add(XmlSerializationUtils.mapQualifier("qualifier", er.getQualifier()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)er.getRefidentifier())) {
                        fields.add(XmlSerializationUtils.asXmlElement("refidentifier", er.getRefidentifier()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)er.getQuery())) {
                        fields.add(XmlSerializationUtils.asXmlElement("query", er.getQuery()));
                    }
                    children.add(templateFactory.getChild("externalreference", null, fields));
                }
            }
        }
        return children;
    }

    private boolean isDuplicate(Tuple2 link) {
        return REL_SUBTYPE_DEDUP.equalsIgnoreCase(link.getRelation().getSubRelType());
    }

    private List<String> listExtraInfo(OafEntity entity) {
        List extraInfo = entity.getExtraInfo();
        return extraInfo != null ? extraInfo.stream().map(e -> XmlSerializationUtils.mapExtraInfo(e)).collect(Collectors.toList()) : Lists.newArrayList();
    }

    private List<String> buildContexts(String type, Set<String> contexts) {
        ArrayList res = Lists.newArrayList();
        if (this.contextMapper != null && !this.contextMapper.isEmpty() && MainEntityType.result.toString().equals(type)) {
            XMLTag document = XMLDoc.newDocument((boolean)true).addRoot("contextRoot");
            for (String context : contexts) {
                String id = "";
                for (String token : Splitter.on((String)"::").split((CharSequence)context)) {
                    ContextDef def = (ContextDef)this.contextMapper.get(id = id + token);
                    if (def == null) continue;
                    if (def.getName().equals("context")) {
                        String xpath = "//context/@id='" + def.getId() + "'";
                        if (!document.gotoRoot().rawXpathBoolean(xpath, new Object[]{new Object()}).booleanValue()) {
                            document = this.addContextDef(document.gotoRoot(), def);
                        }
                    }
                    if (def.getName().equals("category")) {
                        String rootId = StringUtils.substringBefore((String)def.getId(), (String)"::");
                        document = this.addContextDef(document.gotoRoot().gotoTag("//context[./@id='" + rootId + "']", new Object[]{new Object()}), def);
                    }
                    if (def.getName().equals("concept")) {
                        document = this.addContextDef(document, def).gotoParent();
                    }
                    id = id + "::";
                }
            }
            Transformer transformer = this.getTransformer();
            for (Element x : document.gotoRoot().getChildElement()) {
                try {
                    res.add(this.asStringElement(x, transformer));
                }
                catch (TransformerException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return res;
    }

    private Transformer getTransformer() {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException("unable to create javax.xml.transform.Transformer", e);
        }
    }

    private XMLTag addContextDef(XMLTag tag, ContextDef def) {
        tag.addTag(def.getName()).addAttribute("id", def.getId()).addAttribute("label", def.getLabel());
        if (def.getType() != null && !def.getType().isEmpty()) {
            tag.addAttribute("type", def.getType());
        }
        return tag;
    }

    private String asStringElement(Element element, Transformer transformer) throws TransformerException {
        StringWriter buffer = new StringWriter();
        transformer.transform(new DOMSource(element), new StreamResult(buffer));
        return buffer.toString();
    }

    private void fillContextMap(String xmlTree, Set<String> contexts) {
        Document fundingPath;
        try {
            fundingPath = new SAXReader().read((Reader)new StringReader(xmlTree));
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
        try {
            Node funder = fundingPath.selectSingleNode("//funder");
            if (funder != null) {
                String funderShortName = funder.valueOf("./shortname");
                contexts.add(funderShortName);
                this.contextMapper.put(funderShortName, new ContextDef(funderShortName, funder.valueOf("./name"), "context", "funding"));
                Node level0 = fundingPath.selectSingleNode("//funding_level_0");
                if (level0 != null) {
                    String level0Id = Joiner.on((String)"::").join((Object)funderShortName, (Object)level0.valueOf("./name"), new Object[0]);
                    this.contextMapper.put(level0Id, new ContextDef(level0Id, level0.valueOf("./description"), "category", ""));
                    Node level1 = fundingPath.selectSingleNode("//funding_level_1");
                    if (level1 == null) {
                        contexts.add(level0Id);
                    } else {
                        String level1Id = Joiner.on((String)"::").join((Object)level0Id, (Object)level1.valueOf("./name"), new Object[0]);
                        this.contextMapper.put(level1Id, new ContextDef(level1Id, level1.valueOf("./description"), "concept", ""));
                        Node level2 = fundingPath.selectSingleNode("//funding_level_2");
                        if (level2 == null) {
                            contexts.add(level1Id);
                        } else {
                            String level2Id = Joiner.on((String)"::").join((Object)level1Id, (Object)level2.valueOf("./name"), new Object[0]);
                            this.contextMapper.put(level2Id, new ContextDef(level2Id, level2.valueOf("./description"), "concept", ""));
                            contexts.add(level2Id);
                        }
                    }
                }
            }
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("malformed funding path: " + xmlTree, e);
        }
    }

    protected static String getRelFundingTree(String xmlTree) {
        String funding = "<funding>";
        try {
            Document ftree = new SAXReader().read((Reader)new StringReader(xmlTree));
            funding = "<funding>";
            funding = funding + XmlRecordFactory.getFunderElement(ftree);
            for (Object o : Lists.reverse((List)ftree.selectNodes("//fundingtree//*[starts-with(local-name(),'funding_level_')]"))) {
                org.dom4j.Element e = (org.dom4j.Element)o;
                String _id = e.valueOf("./id");
                funding = funding + "<" + e.getName() + " name=\"" + XmlSerializationUtils.escapeXml(e.valueOf("./name")) + "\">" + XmlSerializationUtils.escapeXml(_id) + "</" + e.getName() + ">";
            }
        }
        catch (DocumentException e) {
            throw new IllegalArgumentException("unable to parse funding tree: " + xmlTree + "\n" + e.getMessage());
        }
        finally {
            funding = funding + "</funding>";
        }
        return funding;
    }

    private static String getFunderElement(Document ftree) {
        String funderId = ftree.valueOf("//fundingtree/funder/id");
        String funderShortName = ftree.valueOf("//fundingtree/funder/shortname");
        String funderName = ftree.valueOf("//fundingtree/funder/name");
        String funderJurisdiction = ftree.valueOf("//fundingtree/funder/jurisdiction");
        return "<funder id=\"" + XmlSerializationUtils.escapeXml(funderId) + "\" shortname=\"" + XmlSerializationUtils.escapeXml(funderShortName) + "\" name=\"" + XmlSerializationUtils.escapeXml(funderName) + "\" jurisdiction=\"" + XmlSerializationUtils.escapeXml(funderJurisdiction) + "\" />";
    }
}

