/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision;

import com.lucidworks.spark.util.SolrSupport;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.oa.provision.utils.StreamingInputDocumentFactory;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.dhp.utils.saxon.SaxonTransformerFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpDocumentNotFoundException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.io.Text;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlIndexingJob {
    private static final Logger log = LoggerFactory.getLogger(XmlIndexingJob.class);
    private static final Integer DEFAULT_BATCH_SIZE = 1000;
    private static final String LAYOUT = "index";
    private static final String INTERPRETATION = "openaire";
    private static final String SEPARATOR = "-";
    public static final String DATE_FORMAT = "yyyy-MM-dd'T'hh:mm:ss'Z'";

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)XmlIndexingJob.class.getResourceAsStream("/eu/dnetlib/dhp/oa/provision/input_params_update_index.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("inputPath");
        log.info("inputPath: {}", (Object)inputPath);
        String isLookupUrl = parser.get("isLookupUrl");
        log.info("isLookupUrl: {}", (Object)isLookupUrl);
        String format = parser.get("format");
        log.info("format: {}", (Object)format);
        Integer batchSize = parser.getObjectMap().containsKey("batchSize") ? Integer.valueOf(parser.get("batchSize")) : DEFAULT_BATCH_SIZE;
        log.info("batchSize: {}", (Object)batchSize);
        ISLookUpService isLookup = ISLookupClientFactory.getLookUpService((String)isLookupUrl);
        String fields = XmlIndexingJob.getLayoutSource(isLookup, format);
        log.info("fields: {}", (Object)fields);
        String xslt = XmlIndexingJob.getLayoutTransformer(isLookup);
        String dsId = XmlIndexingJob.getDsId(format, isLookup);
        log.info("dsId: {}", (Object)dsId);
        String zkHost = XmlIndexingJob.getZkHost(isLookup);
        log.info("zkHost: {}", (Object)zkHost);
        String version = XmlIndexingJob.getRecordDatestamp();
        String indexRecordXslt = XmlIndexingJob.getLayoutTransformer(format, fields, xslt);
        log.info("indexRecordTransformer {}", (Object)indexRecordXslt);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
            RDD docs = sc.sequenceFile(inputPath, Text.class, Text.class).map((Function & Serializable)t -> ((Text)t._2()).toString()).map((Function & Serializable)s -> XmlIndexingJob.toIndexRecord(SaxonTransformerFactory.newInstance((String)indexRecordXslt), s)).map((Function & Serializable)s -> new StreamingInputDocumentFactory(version, dsId).parseDocument((String)s)).rdd();
            String collection = format + SEPARATOR + LAYOUT + SEPARATOR + INTERPRETATION;
            SolrSupport.indexDocs((String)zkHost, (String)collection, (int)batchSize, (RDD)docs);
        });
    }

    protected static String toIndexRecord(Transformer tr, String record) {
        StreamResult res = new StreamResult(new StringWriter());
        try {
            tr.transform(new StreamSource(new StringReader(record)), res);
            return res.getWriter().toString();
        }
        catch (Throwable e) {
            log.error("XPathException on record: \n {}", (Object)record, (Object)e);
            throw new IllegalArgumentException(e);
        }
    }

    protected static String getLayoutTransformer(String format, String fields, String xslt) throws TransformerException {
        Transformer layoutTransformer = SaxonTransformerFactory.newInstance((String)xslt);
        StreamResult layoutToXsltXslt = new StreamResult(new StringWriter());
        layoutTransformer.setParameter("format", format);
        layoutTransformer.transform(new StreamSource(new StringReader(fields)), layoutToXsltXslt);
        return layoutToXsltXslt.getWriter().toString();
    }

    public static String getRecordDatestamp() {
        return new SimpleDateFormat(DATE_FORMAT).format(new Date());
    }

    private static String getLayoutSource(ISLookUpService isLookup, String format) throws ISLookUpDocumentNotFoundException, ISLookUpException {
        return XmlIndexingJob.doLookup(isLookup, String.format("collection('')//RESOURCE_PROFILE[.//RESOURCE_TYPE/@value = 'MDFormatDSResourceType' and .//NAME='%s']//LAYOUT[@name='%s']", format, LAYOUT));
    }

    private static String getLayoutTransformer(ISLookUpService isLookup) throws ISLookUpException {
        return XmlIndexingJob.doLookup(isLookup, "collection('/db/DRIVER/TransformationRuleDSResources/TransformationRuleDSResourceType')//RESOURCE_PROFILE[./BODY/CONFIGURATION/SCRIPT/TITLE/text() = 'openaireLayoutToRecordStylesheet']//CODE/node()");
    }

    private static String getDsId(String format, ISLookUpService isLookup) throws ISLookUpException {
        return XmlIndexingJob.doLookup(isLookup, String.format("collection('/db/DRIVER/IndexDSResources/IndexDSResourceType')//RESOURCE_PROFILE[./BODY/CONFIGURATION/METADATA_FORMAT/text() = '%s']//RESOURCE_IDENTIFIER/@value/string()", format));
    }

    private static String getZkHost(ISLookUpService isLookup) throws ISLookUpException {
        return XmlIndexingJob.doLookup(isLookup, "for $x in /RESOURCE_PROFILE[.//RESOURCE_TYPE/@value='IndexServiceResourceType'] return $x//PROTOCOL[./@name='solr']/@address/string()");
    }

    private static String doLookup(ISLookUpService isLookup, String xquery) throws ISLookUpException {
        log.info(String.format("running xquery: %s", xquery));
        String res = isLookup.getResourceProfileByQuery(xquery);
        log.info(String.format("got response (100 chars): %s", StringUtils.left((String)res, (int)100) + " ..."));
        return res;
    }
}

