/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.HdfsSupport;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.oa.provision.model.ProvisionModelSupport;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class AdjacencyListBuilderJob {
    private static final Logger log = LoggerFactory.getLogger(AdjacencyListBuilderJob.class);
    public static final int MAX_LINKS = 100;

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)AdjacencyListBuilderJob.class.getResourceAsStream("/eu/dnetlib/dhp/oa/provision/input_params_build_adjacency_lists.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("inputPath");
        log.info("inputPath: {}", (Object)inputPath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath: {}", (Object)outputPath);
        SparkConf conf = new SparkConf();
        conf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        conf.registerKryoClasses(ProvisionModelSupport.getModelClasses());
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            AdjacencyListBuilderJob.removeOutputDir(spark, outputPath);
            AdjacencyListBuilderJob.createAdjacencyListsKryo(spark, inputPath, outputPath);
        });
    }

    private static void createAdjacencyListsKryo(SparkSession spark, String inputPath, String outputPath) {
        log.info("Reading joined entities from: {}", (Object)inputPath);
        List paths = HdfsSupport.listFiles((String)inputPath, (Configuration)spark.sparkContext().hadoopConfiguration());
        log.info("Found paths: {}", (Object)String.join((CharSequence)",", paths));
    }

    private static Seq<String> toSeq(List<String> list) {
        return ((Iterator)JavaConverters.asScalaIteratorConverter(list.iterator()).asScala()).toSeq();
    }

    private static void removeOutputDir(SparkSession spark, String path) {
        HdfsSupport.remove((String)path, (Configuration)spark.sparkContext().hadoopConfiguration());
    }
}

