/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.HdfsSupport;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.oa.provision.PrepareRelationsJob;
import eu.dnetlib.dhp.oa.provision.model.ProvisionModelSupport;
import eu.dnetlib.dhp.oa.provision.model.RelatedEntity;
import eu.dnetlib.dhp.oa.provision.model.RelatedEntityWrapper;
import eu.dnetlib.dhp.oa.provision.model.SortableRelation;
import eu.dnetlib.dhp.schema.common.EntityType;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.Project;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class CreateRelatedEntitiesJob_phase1 {
    private static final Logger log = LoggerFactory.getLogger(CreateRelatedEntitiesJob_phase1.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)PrepareRelationsJob.class.getResourceAsStream("/eu/dnetlib/dhp/oa/provision/input_params_related_entities_pahase1.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputRelationsPath = parser.get("inputRelationsPath");
        log.info("inputRelationsPath: {}", (Object)inputRelationsPath);
        String inputEntityPath = parser.get("inputEntityPath");
        log.info("inputEntityPath: {}", (Object)inputEntityPath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath: {}", (Object)outputPath);
        String graphTableClassName = parser.get("graphTableClassName");
        log.info("graphTableClassName: {}", (Object)graphTableClassName);
        Class<?> entityClazz = Class.forName(graphTableClassName);
        SparkConf conf = new SparkConf();
        conf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        conf.registerKryoClasses(ProvisionModelSupport.getModelClasses());
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            CreateRelatedEntitiesJob_phase1.removeOutputDir(spark, outputPath);
            CreateRelatedEntitiesJob_phase1.joinRelationEntity(spark, inputRelationsPath, inputEntityPath, entityClazz, outputPath);
        });
    }

    private static <E extends OafEntity> void joinRelationEntity(SparkSession spark, String inputRelationsPath, String inputEntityPath, Class<E> clazz, String outputPath) {
        Dataset relsByTarget = CreateRelatedEntitiesJob_phase1.readPathRelation(spark, inputRelationsPath).filter("dataInfo.deletedbyinference == false").map((MapFunction & Serializable)r -> new Tuple2((Object)r.getTarget(), r), Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.kryo(SortableRelation.class))).cache();
        Dataset entities = CreateRelatedEntitiesJob_phase1.readPathEntity(spark, inputEntityPath, clazz).filter("dataInfo.invisible == false").map((MapFunction & Serializable)value -> CreateRelatedEntitiesJob_phase1.asRelatedEntity(value, clazz), Encoders.kryo(RelatedEntity.class)).map((MapFunction & Serializable)e -> new Tuple2((Object)e.getId(), e), Encoders.tuple((Encoder)Encoders.STRING(), (Encoder)Encoders.kryo(RelatedEntity.class))).cache();
        relsByTarget.joinWith(entities, entities.col("_1").equalTo((Object)relsByTarget.col("_1")), "inner").map((MapFunction & Serializable)t -> new RelatedEntityWrapper((SortableRelation)((Tuple2)t._1())._2(), (RelatedEntity)((Tuple2)t._2())._2()), Encoders.kryo(RelatedEntityWrapper.class)).write().mode(SaveMode.Overwrite).parquet(outputPath);
    }

    private static <E extends OafEntity> Dataset<E> readPathEntity(SparkSession spark, String inputEntityPath, Class<E> entityClazz) {
        log.info("Reading Graph table from: {}", (Object)inputEntityPath);
        return spark.read().textFile(inputEntityPath).map((MapFunction & Serializable)value -> (OafEntity)OBJECT_MAPPER.readValue(value, entityClazz), Encoders.bean(entityClazz));
    }

    public static <E extends OafEntity> RelatedEntity asRelatedEntity(E entity, Class<E> clazz) {
        RelatedEntity re = new RelatedEntity();
        re.setId(entity.getId());
        re.setType(EntityType.fromClass(clazz).name());
        re.setPid(entity.getPid());
        re.setCollectedfrom(entity.getCollectedfrom());
        switch (EntityType.fromClass(clazz)) {
            case publication: 
            case dataset: 
            case otherresearchproduct: 
            case software: {
                Result result = (Result)entity;
                if (result.getTitle() != null && !result.getTitle().isEmpty()) {
                    re.setTitle((StructuredProperty)result.getTitle().stream().findFirst().get());
                }
                re.setDateofacceptance(CreateRelatedEntitiesJob_phase1.getValue((Field<String>)result.getDateofacceptance()));
                re.setPublisher(CreateRelatedEntitiesJob_phase1.getValue((Field<String>)result.getPublisher()));
                re.setResulttype(result.getResulttype());
                re.setInstances(result.getInstance());
                break;
            }
            case datasource: {
                Datasource d = (Datasource)entity;
                re.setOfficialname(CreateRelatedEntitiesJob_phase1.getValue((Field<String>)d.getOfficialname()));
                re.setWebsiteurl(CreateRelatedEntitiesJob_phase1.getValue((Field<String>)d.getWebsiteurl()));
                re.setDatasourcetype(d.getDatasourcetype());
                re.setOpenairecompatibility(d.getOpenairecompatibility());
                break;
            }
            case organization: {
                Organization o = (Organization)entity;
                re.setLegalname(CreateRelatedEntitiesJob_phase1.getValue((Field<String>)o.getLegalname()));
                re.setLegalshortname(CreateRelatedEntitiesJob_phase1.getValue((Field<String>)o.getLegalshortname()));
                re.setCountry(o.getCountry());
                re.setWebsiteurl(CreateRelatedEntitiesJob_phase1.getValue((Field<String>)o.getWebsiteurl()));
                break;
            }
            case project: {
                Project p = (Project)entity;
                re.setProjectTitle(CreateRelatedEntitiesJob_phase1.getValue((Field<String>)p.getTitle()));
                re.setCode(CreateRelatedEntitiesJob_phase1.getValue((Field<String>)p.getCode()));
                re.setAcronym(CreateRelatedEntitiesJob_phase1.getValue((Field<String>)p.getAcronym()));
                re.setContracttype(p.getContracttype());
                List f = p.getFundingtree();
                if (f.isEmpty()) break;
                re.setFundingtree(f.stream().map(s -> (String)s.getValue()).collect(Collectors.toList()));
            }
        }
        return re;
    }

    private static String getValue(Field<String> field) {
        return CreateRelatedEntitiesJob_phase1.getFieldValueWithDefault(field, "");
    }

    private static <T> T getFieldValueWithDefault(Field<T> f, T defaultValue) {
        return (T)Optional.ofNullable(f).filter(Objects::nonNull).map(x -> x.getValue()).orElse(defaultValue);
    }

    private static Dataset<SortableRelation> readPathRelation(SparkSession spark, String relationPath) {
        log.info("Reading relations from: {}", (Object)relationPath);
        return spark.read().load(relationPath).as(Encoders.bean(SortableRelation.class));
    }

    private static void removeOutputDir(SparkSession spark, String path) {
        HdfsSupport.remove((String)path, (Configuration)spark.sparkContext().hadoopConfiguration());
    }
}

