/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.oa.provision.ProvisionConstants;
import eu.dnetlib.dhp.oa.provision.utils.ISLookupClient;
import eu.dnetlib.dhp.oa.provision.utils.ZkServers;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrAdminApplication
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(SolrAdminApplication.class);
    private final CloudSolrClient solrClient;

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SolrAdminApplication.class.getResourceAsStream("/eu/dnetlib/dhp/oa/provision/input_solradmin_parameters.json")));
        parser.parseArgument(args);
        String isLookupUrl = parser.get("isLookupUrl");
        log.info("isLookupUrl: {}", (Object)isLookupUrl);
        String format = parser.get("format");
        log.info("format: {}", (Object)format);
        Action action = Action.valueOf(parser.get("action"));
        log.info("action: {}", (Object)action);
        String query = parser.get("query");
        log.info("query: {}", (Object)query);
        boolean commit = Optional.ofNullable(parser.get("commit")).map(Boolean::valueOf).orElse(false);
        log.info("commit: {}", (Object)commit);
        ISLookupClient isLookup = new ISLookupClient(ISLookupClientFactory.getLookUpService((String)isLookupUrl));
        String zkHost = isLookup.getZkHost();
        log.info("zkHost: {}", (Object)zkHost);
        String collection = ProvisionConstants.getCollectionName(format);
        log.info("collection: {}", (Object)collection);
        try (SolrAdminApplication app = new SolrAdminApplication(zkHost);){
            app.execute(action, collection, query, commit);
        }
    }

    public SolrAdminApplication(String zkHost) {
        ZkServers zk = ZkServers.newInstance(zkHost);
        this.solrClient = new CloudSolrClient.Builder(zk.getHosts(), zk.getChroot()).build();
    }

    public SolrResponse commit(String collection) throws IOException, SolrServerException {
        return this.execute(Action.COMMIT, collection, null, true);
    }

    public SolrResponse execute(Action action, String collection, String query, boolean commit) throws IOException, SolrServerException {
        switch (action) {
            case DELETE_BY_QUERY: {
                UpdateResponse rsp = this.solrClient.deleteByQuery(collection, query);
                if (commit) {
                    this.solrClient.commit(collection);
                }
                return rsp;
            }
            case COMMIT: {
                return this.solrClient.commit(collection);
            }
        }
        throw new IllegalArgumentException("action not managed: " + (Object)((Object)action));
    }

    @Override
    public void close() throws IOException {
        this.solrClient.close();
    }

    static enum Action {
        DELETE_BY_QUERY,
        COMMIT;

    }
}

