/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision;

import eu.dnetlib.dhp.oa.provision.SolrAdminApplication;
import eu.dnetlib.dhp.oa.provision.SolrTest;
import eu.dnetlib.dhp.oa.provision.XmlIndexingJob;
import eu.dnetlib.dhp.oa.provision.model.SerializableSolrInputDocument;
import eu.dnetlib.dhp.oa.provision.model.TupleWrapper;
import eu.dnetlib.dhp.oa.provision.utils.ISLookupClient;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class XmlIndexingJobTest
extends SolrTest {
    protected static SparkSession spark;
    private static final Integer batchSize;
    @Mock
    private ISLookUpService isLookUpService;
    @Mock
    private ISLookupClient isLookupClient;

    @BeforeEach
    public void prepareMocks() throws ISLookUpException, IOException {
        this.isLookupClient.setIsLookup(this.isLookUpService);
        int solrPort = URI.create("http://" + miniCluster.getZkClient().getZkServerAddress()).getPort();
        Mockito.when((Object)this.isLookupClient.getZkHost()).thenReturn((Object)String.format("127.0.0.1:%s/solr", solrPort));
        Mockito.when((Object)this.isLookupClient.getLayoutSource(Mockito.anyString())).thenReturn((Object)IOUtils.toString((InputStream)this.getClass().getResourceAsStream("fields.xml")));
        Mockito.when((Object)this.isLookupClient.getLayoutTransformer()).thenReturn((Object)IOUtils.toString((InputStream)this.getClass().getResourceAsStream("layoutToRecordTransformer.xsl")));
    }

    @BeforeAll
    public static void before() {
        SparkConf conf = new SparkConf();
        conf.setAppName(XmlIndexingJobTest.class.getSimpleName());
        conf.registerKryoClasses(new Class[]{SerializableSolrInputDocument.class});
        conf.setMaster("local[1]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.resolve("spark").toString());
        spark = SparkSession.builder().appName(XmlIndexingJobTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void tearDown() {
        spark.stop();
    }

    @Test
    void testXmlIndexingJob_onSolr() throws Exception {
        String inputPath = "src/test/resources/eu/dnetlib/dhp/oa/provision/xml";
        Dataset records = spark.read().schema(Encoders.bean(TupleWrapper.class).schema()).json(inputPath).as(Encoders.bean(TupleWrapper.class));
        long nRecord = records.count();
        new XmlIndexingJob(spark, inputPath, "c1", "shadow", batchSize, Boolean.valueOf(false)).run(this.isLookupClient);
        Assertions.assertEquals((int)0, (int)miniCluster.getSolrClient().commit("c1-index-openaire").getStatus());
        QueryResponse rsp = miniCluster.getSolrClient().query("shadow", (SolrParams)new SolrQuery().add("q", new String[]{"*:*"}));
        Assertions.assertEquals((long)nRecord, (long)rsp.getResults().getNumFound(), (String)"the number of indexed records should be equal to the number of input records");
        rsp = miniCluster.getSolrClient().query("shadow", (SolrParams)new SolrQuery().add("q", new String[]{"isgreen:true"}));
        Assertions.assertEquals((long)4L, (long)rsp.getResults().getNumFound(), (String)"the number of indexed records having isgreen = true");
        rsp = miniCluster.getSolrClient().query("shadow", (SolrParams)new SolrQuery().add("q", new String[]{"openaccesscolor:bronze"}));
        Assertions.assertEquals((long)2L, (long)rsp.getResults().getNumFound(), (String)"the number of indexed records having openaccesscolor = bronze");
        rsp = miniCluster.getSolrClient().query("shadow", (SolrParams)new SolrQuery().add("q", new String[]{"isindiamondjournal:true"}));
        Assertions.assertEquals((long)0L, (long)rsp.getResults().getNumFound(), (String)"the number of indexed records having isindiamondjournal = true");
        rsp = miniCluster.getSolrClient().query("shadow", (SolrParams)new SolrQuery().add("q", new String[]{"publiclyfunded:true"}));
        Assertions.assertEquals((long)0L, (long)rsp.getResults().getNumFound(), (String)"the number of indexed records having publiclyfunded = true");
        rsp = miniCluster.getSolrClient().query("shadow", (SolrParams)new SolrQuery().add("q", new String[]{"peerreviewed:true"}));
        Assertions.assertEquals((long)35L, (long)rsp.getResults().getNumFound(), (String)"the number of indexed records having peerreviewed = true");
        rsp = miniCluster.getSolrClient().query("shadow", (SolrParams)new SolrQuery().add("q", new String[]{"objidentifier:\"57a035e5b1ae::236d6d8c1e03368b5ae72acfeeb11bbc\""}).add("fl", new String[]{"__json"}));
        Assertions.assertEquals((long)1L, (long)rsp.getResults().getNumFound(), (String)"the number of indexed records having the given identifier");
        Optional json = rsp.getResults().stream().map(d -> d.getFieldValues("__json")).flatMap(d -> d.stream()).findFirst();
        Assertions.assertTrue((boolean)json.isPresent());
        log.info((String)json.get());
        admin.execute(SolrAdminApplication.Action.UPDATE_ALIASES, null, false, "c1-index-openaire", "c2-index-openaire");
        rsp = miniCluster.getSolrClient().query("public", (SolrParams)new SolrQuery().add("q", new String[]{"objidentifier:\"57a035e5b1ae::236d6d8c1e03368b5ae72acfeeb11bbc\""}).add("fl", new String[]{"__json"}));
        Assertions.assertEquals((long)1L, (long)rsp.getResults().getNumFound(), (String)"the number of indexed records having the given identifier, found in the public collection");
    }

    static {
        batchSize = 100;
    }
}

