/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.oa.provision.ProvisionConstants;
import eu.dnetlib.dhp.oa.provision.utils.ISLookupClient;
import eu.dnetlib.dhp.oa.provision.utils.ZkServers;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrAdminApplication
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(SolrAdminApplication.class);
    private final CloudSolrClient solrClient;

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)SolrAdminApplication.class.getResourceAsStream("/eu/dnetlib/dhp/oa/provision/input_solradmin_parameters.json")));
        parser.parseArgument(args);
        String isLookupUrl = parser.get("isLookupUrl");
        log.info("isLookupUrl: {}", (Object)isLookupUrl);
        Action action = Action.valueOf(parser.get("action"));
        log.info("action: {}", (Object)action);
        String query = parser.get("query");
        log.info("query: {}", (Object)query);
        boolean commit = Optional.ofNullable(parser.get("commit")).map(Boolean::valueOf).orElse(false);
        log.info("commit: {}", (Object)commit);
        ISLookupClient isLookup = new ISLookupClient(ISLookupClientFactory.getLookUpService((String)isLookupUrl));
        String zkHost = isLookup.getZkHost();
        log.info("zkHost: {}", (Object)zkHost);
        String publicFormat = parser.get("publicFormat");
        log.info("publicFormat: {}", (Object)publicFormat);
        String shadowFormat = parser.get("shadowFormat");
        log.info("shadowFormat: {}", (Object)shadowFormat);
        String publicCollection = ProvisionConstants.getCollectionName(publicFormat);
        log.info("publicCollection: {}", (Object)publicCollection);
        String shadowCollection = ProvisionConstants.getCollectionName(shadowFormat);
        log.info("shadowCollection: {}", (Object)shadowCollection);
        try (SolrAdminApplication app = new SolrAdminApplication(zkHost);){
            app.execute(action, query, commit, publicCollection, shadowCollection);
        }
    }

    public SolrAdminApplication(String zkHost) {
        ZkServers zk = ZkServers.newInstance(zkHost);
        this.solrClient = new CloudSolrClient.Builder(zk.getHosts(), zk.getChroot()).build();
    }

    public SolrResponse commit(String shadowCollection) throws IOException, SolrServerException {
        return this.execute(Action.COMMIT, null, true, null, shadowCollection);
    }

    public SolrResponse execute(Action action, String query, boolean commit, String publicCollection, String shadowCollection) throws IOException, SolrServerException {
        switch (action) {
            case DELETE_BY_QUERY: {
                UpdateResponse rsp = this.solrClient.deleteByQuery(shadowCollection, query);
                if (commit) {
                    return this.solrClient.commit(shadowCollection);
                }
                return rsp;
            }
            case COMMIT: {
                return this.solrClient.commit(shadowCollection);
            }
            case UPDATE_ALIASES: {
                this.updateAliases(publicCollection, shadowCollection);
                return null;
            }
        }
        throw new IllegalArgumentException("action not managed: " + (Object)((Object)action));
    }

    @Override
    public void close() throws IOException {
        this.solrClient.close();
    }

    private void updateAliases(String publicCollection, String shadowCollection) throws SolrServerException, IOException {
        this.deleteAlias("public");
        this.deleteAlias("shadow");
        this.createAlias("public", publicCollection);
        this.createAlias("shadow", shadowCollection);
    }

    public SolrResponse deleteAlias(String aliasName) throws SolrServerException, IOException {
        CollectionAdminRequest.DeleteAlias deleteAliasRequest = CollectionAdminRequest.deleteAlias((String)aliasName);
        log.info("deleting alias: {}", (Object)aliasName);
        return deleteAliasRequest.process((SolrClient)this.solrClient);
    }

    public SolrResponse createAlias(String aliasName, String collection) throws IOException, SolrServerException {
        CollectionAdminRequest.CreateAlias createAliasRequest = CollectionAdminRequest.createAlias((String)aliasName, (String)collection);
        log.info("creating alias: {} for collection: {}", (Object)aliasName, (Object)collection);
        return createAliasRequest.process((SolrClient)this.solrClient);
    }

    static enum Action {
        DELETE_BY_QUERY,
        COMMIT,
        UPDATE_ALIASES;

    }
}

