/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision.utils;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZkServers {
    private static final Log log = LogFactory.getLog(ZkServers.class);
    public static final String SEPARATOR = "/";
    private List<String> hosts;
    private Optional<String> chroot;

    public static ZkServers newInstance(String zkUrl) {
        String urls = zkUrl;
        Optional<String> chRoot = Optional.of(SEPARATOR + StringUtils.substringAfterLast((String)zkUrl, (String)SEPARATOR));
        if (StringUtils.isNotBlank((CharSequence)chRoot.get())) {
            log.debug((Object)String.format("found zk chroot %s", chRoot));
            urls = zkUrl.replace(chRoot.get(), "");
        }
        ArrayList urlList = Lists.newArrayList((Iterable)Splitter.on((String)",").omitEmptyStrings().split((CharSequence)urls));
        log.debug((Object)String.format("zk urls %s", zkUrl));
        return new ZkServers(urlList, chRoot);
    }

    public ZkServers(List<String> hosts, Optional<String> chroot) {
        this.hosts = hosts;
        this.chroot = chroot;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }

    public Optional<String> getChroot() {
        return this.chroot;
    }

    public void setChroot(Optional<String> chroot) {
        this.chroot = chroot;
    }
}

