/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mycila.xmltool.XMLDoc;
import com.mycila.xmltool.XMLTag;
import eu.dnetlib.dhp.oa.provision.model.JoinedEntity;
import eu.dnetlib.dhp.oa.provision.model.RelatedEntity;
import eu.dnetlib.dhp.oa.provision.model.RelatedEntityWrapper;
import eu.dnetlib.dhp.oa.provision.model.XmlInstance;
import eu.dnetlib.dhp.oa.provision.utils.AuthorPidTypeComparator;
import eu.dnetlib.dhp.oa.provision.utils.ContextDef;
import eu.dnetlib.dhp.oa.provision.utils.ContextMapper;
import eu.dnetlib.dhp.oa.provision.utils.GraphMappingUtils;
import eu.dnetlib.dhp.oa.provision.utils.TemplateFactory;
import eu.dnetlib.dhp.oa.provision.utils.XmlSerializationUtils;
import eu.dnetlib.dhp.schema.common.AccessRightComparator;
import eu.dnetlib.dhp.schema.common.EntityType;
import eu.dnetlib.dhp.schema.common.MainEntityType;
import eu.dnetlib.dhp.schema.common.ModelConstants;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.common.RefereedComparator;
import eu.dnetlib.dhp.schema.oaf.AccessRight;
import eu.dnetlib.dhp.schema.oaf.Context;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.ExternalReference;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.Journal;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Measure;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Person;
import eu.dnetlib.dhp.schema.oaf.Project;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.Software;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.spark.util.LongAccumulator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.w3c.dom.Element;
import scala.Tuple2;

public class XmlRecordFactory
implements Serializable {
    private static final long serialVersionUID = 2912912999272373172L;
    public static final String DOI_ORG_AUTHORITY = "doi.org";
    public static final String HTTPS = "https";
    private final Map<String, LongAccumulator> accumulators;
    private final ContextMapper contextMapper;
    private final String schemaLocation;
    private boolean indent = false;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public XmlRecordFactory(ContextMapper contextMapper, boolean indent, String schemaLocation) {
        this(Maps.newHashMap(), contextMapper, indent, schemaLocation);
    }

    public XmlRecordFactory(Map<String, LongAccumulator> accumulators, ContextMapper contextMapper, boolean indent, String schemaLocation) {
        this.accumulators = accumulators;
        this.contextMapper = contextMapper;
        this.schemaLocation = schemaLocation;
        this.indent = indent;
    }

    public String build(JoinedEntity je) {
        return this.build(je, false);
    }

    public String build(JoinedEntity je, Boolean validate) {
        HashSet contexts = Sets.newHashSet();
        OafEntity entity = je.getEntity();
        TemplateFactory templateFactory = new TemplateFactory();
        try {
            EntityType type = EntityType.fromClass(entity.getClass());
            List<String> metadata = this.metadata(type, entity, contexts);
            List<RelatedEntityWrapper> links = je.getLinks();
            List relations = links.stream().filter(link -> !this.isDuplicate((RelatedEntityWrapper)link)).map(link -> this.mapRelation(templateFactory, type, (RelatedEntityWrapper)link)).collect(Collectors.toCollection(ArrayList::new));
            String mainType = ModelSupport.getMainType((EntityType)type);
            metadata.addAll(this.buildContexts(mainType, contexts));
            metadata.add(XmlSerializationUtils.parseDataInfo(entity.getDataInfo()));
            String body = templateFactory.buildBody(mainType, metadata, relations, this.listChildren(entity, je, templateFactory), this.listExtraInfo(entity));
            String xmlRecord = templateFactory.buildRecord(entity, this.schemaLocation, body);
            if (Boolean.TRUE.equals(validate)) {
                new SAXReader().read((Reader)new StringReader(xmlRecord));
            }
            return xmlRecord;
        }
        catch (Throwable e) {
            throw new RuntimeException(String.format("error building record '%s'", entity.getId()), e);
        }
    }

    private static OafEntity parseOaf(String json, String type) {
        try {
            switch (EntityType.valueOf((String)type)) {
                case publication: {
                    return (OafEntity)OBJECT_MAPPER.readValue(json, Publication.class);
                }
                case dataset: {
                    return (OafEntity)OBJECT_MAPPER.readValue(json, Dataset.class);
                }
                case otherresearchproduct: {
                    return (OafEntity)OBJECT_MAPPER.readValue(json, OtherResearchProduct.class);
                }
                case software: {
                    return (OafEntity)OBJECT_MAPPER.readValue(json, Software.class);
                }
                case datasource: {
                    return (OafEntity)OBJECT_MAPPER.readValue(json, Datasource.class);
                }
                case organization: {
                    return (OafEntity)OBJECT_MAPPER.readValue(json, Organization.class);
                }
                case project: {
                    return (OafEntity)OBJECT_MAPPER.readValue(json, Project.class);
                }
            }
            throw new IllegalArgumentException("invalid type: " + type);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String printXML(String xml, boolean indent) {
        try {
            Document doc = new SAXReader().read((Reader)new StringReader(xml));
            OutputFormat format = indent ? OutputFormat.createPrettyPrint() : OutputFormat.createCompactFormat();
            format.setExpandEmptyElements(false);
            format.setSuppressDeclaration(true);
            StringWriter sw = new StringWriter();
            XMLWriter writer = new XMLWriter((Writer)sw, format);
            writer.write(doc);
            return sw.toString();
        }
        catch (IOException | DocumentException e) {
            throw new IllegalArgumentException("Unable to indent XML. Invalid record:\n" + xml, e);
        }
    }

    private List<String> metadata(EntityType type, OafEntity entity, Set<String> contexts) {
        ArrayList metadata = Lists.newArrayList();
        if (entity.getCollectedfrom() != null) {
            metadata.addAll(entity.getCollectedfrom().stream().filter(XmlRecordFactory::kvNotBlank).map(kv -> XmlSerializationUtils.mapKeyValue("collectedfrom", kv)).collect(Collectors.toList()));
        }
        if (entity.getOriginalId() != null) {
            metadata.addAll(entity.getOriginalId().stream().filter(Objects::nonNull).filter(id -> !id.matches("^\\d{2}|")).map(s -> XmlSerializationUtils.asXmlElement("originalId", s)).collect(Collectors.toList()));
        }
        if (entity.getPid() != null) {
            metadata.addAll(entity.getPid().stream().filter(Objects::nonNull).map(p -> XmlSerializationUtils.mapStructuredProperty("pid", p)).collect(Collectors.toList()));
        }
        if (entity.getMeasures() != null) {
            metadata.addAll(this.measuresAsXml(entity.getMeasures()));
        }
        if (entity.getContext() != null) {
            contexts.addAll(entity.getContext().stream().map(Context::getId).collect(Collectors.toList()));
            if (contexts.contains("dh-ch::subcommunity::2")) {
                contexts.add("clarin");
            }
        }
        if (ModelSupport.isResult((EntityType)type)) {
            Result r = (Result)entity;
            if (r.getFulltext() != null) {
                metadata.addAll(r.getFulltext().stream().filter(Objects::nonNull).map(c -> XmlSerializationUtils.asXmlElement("fulltext", (String)c.getValue())).collect(Collectors.toList()));
            }
            if (r.getEoscifguidelines() != null) {
                metadata.addAll(r.getEoscifguidelines().stream().filter(Objects::nonNull).map(e -> XmlSerializationUtils.mapEoscIf(e)).collect(Collectors.toList()));
            }
            if (r.getTitle() != null) {
                metadata.addAll(r.getTitle().stream().filter(Objects::nonNull).map(t -> XmlSerializationUtils.mapStructuredProperty("title", t)).collect(Collectors.toList()));
            }
            if (r.getBestaccessright() != null) {
                metadata.add(XmlSerializationUtils.mapQualifier("bestaccessright", r.getBestaccessright()));
            }
            if (r.getAuthor() != null) {
                metadata.addAll(r.getAuthor().stream().filter(Objects::nonNull).map(a -> {
                    StringBuilder sb = new StringBuilder("<creator rank=\"" + a.getRank() + "\"");
                    if (StringUtils.isNotBlank((CharSequence)a.getName())) {
                        sb.append(" name=\"" + XmlSerializationUtils.escapeXml(a.getName()) + "\"");
                    }
                    if (StringUtils.isNotBlank((CharSequence)a.getSurname())) {
                        sb.append(" surname=\"" + XmlSerializationUtils.escapeXml(a.getSurname()) + "\"");
                    }
                    if (a.getPid() != null) {
                        a.getPid().stream().filter(Objects::nonNull).filter(sp -> StringUtils.isNotBlank((CharSequence)sp.getQualifier().getClassid()) && StringUtils.isNotBlank((CharSequence)sp.getValue())).collect(Collectors.toMap(p -> this.getAuthorPidType(p.getQualifier().getClassid()), p -> p, (p1, p2) -> p1)).values().stream().collect(Collectors.groupingBy(p -> p.getValue(), Collectors.mapping(p -> p, Collectors.minBy(new AuthorPidTypeComparator())))).values().stream().map(op -> (StructuredProperty)op.get()).forEach(sp -> {
                            String pidType = this.getAuthorPidType(sp.getQualifier().getClassid());
                            String pidValue = XmlSerializationUtils.escapeXml(sp.getValue());
                            if (GraphMappingUtils.authorPidTypes.contains(pidValue.toLowerCase().trim())) {
                                sb.append(String.format(" %s=\"%s\"", pidValue, pidType));
                            } else if (StringUtils.isNotBlank((CharSequence)pidType)) {
                                sb.append(String.format(" %s=\"%s\"", pidType, pidValue.toLowerCase().replaceAll("^.*orcid\\.org\\/", "")));
                            }
                        });
                    }
                    sb.append(">" + XmlSerializationUtils.escapeXml(a.getFullname()) + "</creator>");
                    return sb.toString();
                }).collect(Collectors.toList()));
            }
            if (r.getContributor() != null) {
                metadata.addAll(r.getContributor().stream().filter(Objects::nonNull).map(c -> XmlSerializationUtils.asXmlElement("contributor", (String)c.getValue())).collect(Collectors.toList()));
            }
            if (r.getCountry() != null) {
                metadata.addAll(r.getCountry().stream().filter(Objects::nonNull).map(c -> XmlSerializationUtils.mapQualifier("country", (Qualifier)c)).collect(Collectors.toList()));
            }
            if (r.getCoverage() != null) {
                metadata.addAll(r.getCoverage().stream().filter(Objects::nonNull).map(c -> XmlSerializationUtils.asXmlElement("coverage", (String)c.getValue())).collect(Collectors.toList()));
            }
            if (r.getDateofacceptance() != null) {
                metadata.add(XmlSerializationUtils.asXmlElement("dateofacceptance", (String)r.getDateofacceptance().getValue()));
            }
            if (r.getDescription() != null) {
                metadata.addAll(r.getDescription().stream().filter(Objects::nonNull).limit(10L).map(c -> XmlSerializationUtils.asXmlElement("description", (String)c.getValue())).collect(Collectors.toCollection(HashSet::new)));
            }
            if (r.getEmbargoenddate() != null) {
                metadata.add(XmlSerializationUtils.asXmlElement("embargoenddate", (String)r.getEmbargoenddate().getValue()));
            }
            if (r.getSubject() != null) {
                metadata.addAll(r.getSubject().stream().filter(Objects::nonNull).map(s -> XmlSerializationUtils.mapStructuredProperty("subject", (StructuredProperty)s)).collect(Collectors.toList()));
            }
            if (r.getLanguage() != null) {
                metadata.add(XmlSerializationUtils.mapQualifier("language", r.getLanguage()));
            }
            if (r.getRelevantdate() != null) {
                metadata.addAll(r.getRelevantdate().stream().filter(Objects::nonNull).map(s -> XmlSerializationUtils.mapStructuredProperty("relevantdate", s)).collect(Collectors.toList()));
            }
            if (r.getPublisher() != null) {
                metadata.add(XmlSerializationUtils.asXmlElement("publisher", (String)r.getPublisher().getValue()));
            }
            if (r.getSource() != null) {
                metadata.addAll(r.getSource().stream().filter(Objects::nonNull).map(c -> XmlSerializationUtils.asXmlElement("source", (String)c.getValue())).collect(Collectors.toCollection(HashSet::new)));
            }
            if (r.getFormat() != null) {
                metadata.addAll(r.getFormat().stream().filter(Objects::nonNull).map(c -> XmlSerializationUtils.asXmlElement("format", (String)c.getValue())).collect(Collectors.toList()));
            }
            if (r.getResulttype() != null) {
                metadata.add(XmlSerializationUtils.mapQualifier("resulttype", r.getResulttype()));
            }
            if (r.getResourcetype() != null) {
                metadata.add(XmlSerializationUtils.mapQualifier("resourcetype", r.getResourcetype()));
            }
            if (r.getProcessingchargeamount() != null) {
                metadata.add(XmlSerializationUtils.asXmlElement("processingchargeamount", (String)r.getProcessingchargeamount().getValue()));
                metadata.add(XmlSerializationUtils.asXmlElement("processingchargecurrency", (String)r.getProcessingchargecurrency().getValue()));
            }
            if (r.getIsGreen() != null) {
                metadata.add(XmlSerializationUtils.asXmlElement("isgreen", Boolean.toString(r.getIsGreen())));
            }
            if (r.getOpenAccessColor() != null) {
                metadata.add(XmlSerializationUtils.asXmlElement("openaccesscolor", r.getOpenAccessColor().toString()));
            }
            if (r.getIsInDiamondJournal() != null) {
                metadata.add(XmlSerializationUtils.asXmlElement("isindiamondjournal", Boolean.toString(r.getIsInDiamondJournal())));
            }
            if (r.getPubliclyFunded() != null) {
                metadata.add(XmlSerializationUtils.asXmlElement("publiclyfunded", Boolean.toString(r.getPubliclyFunded())));
            }
        }
        switch (type) {
            case publication: {
                Publication pub = (Publication)entity;
                if (pub.getJournal() == null) break;
                Journal j = pub.getJournal();
                metadata.add(XmlSerializationUtils.mapJournal(j));
                break;
            }
            case dataset: {
                Dataset d = (Dataset)entity;
                if (d.getDevice() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("device", (String)d.getDevice().getValue()));
                }
                if (d.getLastmetadataupdate() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("lastmetadataupdate", (String)d.getLastmetadataupdate().getValue()));
                }
                if (d.getMetadataversionnumber() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("metadataversionnumber", (String)d.getMetadataversionnumber().getValue()));
                }
                if (d.getSize() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("size", (String)d.getSize().getValue()));
                }
                if (d.getStoragedate() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("storagedate", (String)d.getStoragedate().getValue()));
                }
                if (d.getVersion() == null) break;
                metadata.add(XmlSerializationUtils.asXmlElement("version", (String)d.getVersion().getValue()));
                break;
            }
            case otherresearchproduct: {
                OtherResearchProduct orp = (OtherResearchProduct)entity;
                if (orp.getContactperson() != null) {
                    metadata.addAll(orp.getContactperson().stream().filter(Objects::nonNull).map(c -> XmlSerializationUtils.asXmlElement("contactperson", (String)c.getValue())).collect(Collectors.toList()));
                }
                if (orp.getContactgroup() != null) {
                    metadata.addAll(orp.getContactgroup().stream().filter(Objects::nonNull).map(c -> XmlSerializationUtils.asXmlElement("contactgroup", (String)c.getValue())).collect(Collectors.toList()));
                }
                if (orp.getTool() == null) break;
                metadata.addAll(orp.getTool().stream().filter(Objects::nonNull).map(c -> XmlSerializationUtils.asXmlElement("tool", (String)c.getValue())).collect(Collectors.toList()));
                break;
            }
            case software: {
                Software s2 = (Software)entity;
                if (s2.getDocumentationUrl() != null) {
                    metadata.addAll(s2.getDocumentationUrl().stream().filter(Objects::nonNull).map(c -> XmlSerializationUtils.asXmlElement("documentationUrl", (String)c.getValue())).collect(Collectors.toList()));
                }
                if (s2.getLicense() != null) {
                    metadata.addAll(s2.getLicense().stream().filter(Objects::nonNull).map(l -> XmlSerializationUtils.mapStructuredProperty("license", l)).collect(Collectors.toList()));
                }
                if (s2.getCodeRepositoryUrl() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("codeRepositoryUrl", (String)s2.getCodeRepositoryUrl().getValue()));
                }
                if (s2.getProgrammingLanguage() == null) break;
                metadata.add(XmlSerializationUtils.mapQualifier("programmingLanguage", s2.getProgrammingLanguage()));
                break;
            }
            case datasource: {
                Datasource ds = (Datasource)entity;
                if (ds.getDatasourcetype() != null) {
                    metadata.add(XmlSerializationUtils.mapQualifier("datasourcetype", ds.getDatasourcetype()));
                }
                if (ds.getDatasourcetypeui() != null) {
                    metadata.add(XmlSerializationUtils.mapQualifier("datasourcetypeui", ds.getDatasourcetypeui()));
                }
                if (ds.getEosctype() != null) {
                    metadata.add(XmlSerializationUtils.mapQualifier("eosctype", ds.getEosctype()));
                }
                if (ds.getEoscdatasourcetype() != null) {
                    metadata.add(XmlSerializationUtils.mapQualifier("eoscdatasourcetype", ds.getEoscdatasourcetype()));
                }
                if (ds.getOpenairecompatibility() != null) {
                    metadata.add(XmlSerializationUtils.mapQualifier("openairecompatibility", ds.getOpenairecompatibility()));
                }
                if (ds.getOfficialname() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("officialname", (String)ds.getOfficialname().getValue()));
                }
                if (ds.getEnglishname() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("englishname", (String)ds.getEnglishname().getValue()));
                }
                if (ds.getWebsiteurl() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("websiteurl", (String)ds.getWebsiteurl().getValue()));
                }
                if (ds.getLogourl() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("logourl", (String)ds.getLogourl().getValue()));
                }
                if (ds.getContactemail() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("contactemail", (String)ds.getContactemail().getValue()));
                }
                if (ds.getNamespaceprefix() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("namespaceprefix", (String)ds.getNamespaceprefix().getValue()));
                }
                if (ds.getLatitude() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("latitude", (String)ds.getLatitude().getValue()));
                }
                if (ds.getLongitude() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("longitude", (String)ds.getLongitude().getValue()));
                }
                if (ds.getDateofvalidation() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("dateofvalidation", (String)ds.getDateofvalidation().getValue()));
                }
                if (ds.getDescription() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("description", (String)ds.getDescription().getValue()));
                }
                if (ds.getSubjects() != null) {
                    metadata.addAll(ds.getSubjects().stream().filter(Objects::nonNull).map(sp -> XmlSerializationUtils.mapStructuredProperty("subjects", sp)).collect(Collectors.toList()));
                }
                if (ds.getOdnumberofitems() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("odnumberofitems", (String)ds.getOdnumberofitems().getValue()));
                }
                if (ds.getOdnumberofitemsdate() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("odnumberofitemsdate", (String)ds.getOdnumberofitemsdate().getValue()));
                }
                if (ds.getOdpolicies() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("odpolicies", (String)ds.getOdpolicies().getValue()));
                }
                if (ds.getOdlanguages() != null) {
                    metadata.addAll(ds.getOdlanguages().stream().filter(Objects::nonNull).map(c -> XmlSerializationUtils.asXmlElement("odlanguages", (String)c.getValue())).collect(Collectors.toList()));
                }
                if (ds.getLanguages() != null) {
                    metadata.addAll(ds.getLanguages().stream().filter(Objects::nonNull).map(c -> XmlSerializationUtils.asXmlElement("languages", c)).collect(Collectors.toList()));
                }
                if (ds.getOdcontenttypes() != null) {
                    metadata.addAll(ds.getOdcontenttypes().stream().filter(Objects::nonNull).map(c -> XmlSerializationUtils.asXmlElement("odcontenttypes", (String)c.getValue())).collect(Collectors.toList()));
                }
                if (ds.getAccessinfopackage() != null) {
                    metadata.addAll(ds.getAccessinfopackage().stream().map(c -> XmlSerializationUtils.asXmlElement("accessinfopackage", (String)c.getValue())).collect(Collectors.toList()));
                }
                if (ds.getReleaseenddate() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("releasestartdate", (String)ds.getReleaseenddate().getValue()));
                }
                if (ds.getReleaseenddate() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("releaseenddate", (String)ds.getReleaseenddate().getValue()));
                }
                if (ds.getMissionstatementurl() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("missionstatementurl", (String)ds.getMissionstatementurl().getValue()));
                }
                if (ds.getDataprovider() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("dataprovider", ((Boolean)ds.getDataprovider().getValue()).toString()));
                }
                if (ds.getServiceprovider() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("serviceprovider", ((Boolean)ds.getServiceprovider().getValue()).toString()));
                }
                if (ds.getDatabaseaccesstype() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("databaseaccesstype", (String)ds.getDatabaseaccesstype().getValue()));
                }
                if (ds.getDatauploadtype() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("datauploadtype", (String)ds.getDatauploadtype().getValue()));
                }
                if (ds.getDatabaseaccessrestriction() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("databaseaccessrestriction", (String)ds.getDatabaseaccessrestriction().getValue()));
                }
                if (ds.getDatauploadrestriction() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("datauploadrestriction", (String)ds.getDatauploadrestriction().getValue()));
                }
                if (ds.getVersioning() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("versioning", ((Boolean)ds.getVersioning().getValue()).toString()));
                }
                if (ds.getVersioncontrol() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("versioncontrol", ds.getVersioncontrol().toString()));
                }
                if (ds.getCitationguidelineurl() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("citationguidelineurl", (String)ds.getCitationguidelineurl().getValue()));
                }
                if (ds.getPidsystems() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("pidsystems", (String)ds.getPidsystems().getValue()));
                }
                if (ds.getCertificates() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("certificates", (String)ds.getCertificates().getValue()));
                }
                if (ds.getPolicies() != null) {
                    metadata.addAll(ds.getPolicies().stream().filter(XmlRecordFactory::kvNotBlank).map(kv -> XmlSerializationUtils.mapKeyValue("policies", kv)).collect(Collectors.toList()));
                }
                if (ds.getJournal() != null) {
                    metadata.add(XmlSerializationUtils.mapJournal(ds.getJournal()));
                }
                if (ds.getResearchentitytypes() != null) {
                    metadata.addAll(ds.getResearchentitytypes().stream().map(c -> XmlSerializationUtils.asXmlElement("researchentitytypes", c)).collect(Collectors.toList()));
                }
                if (ds.getProvidedproducttypes() != null) {
                    metadata.addAll(ds.getProvidedproducttypes().stream().map(c -> XmlSerializationUtils.asXmlElement("providedproducttypes", c)).collect(Collectors.toList()));
                }
                if (ds.getJurisdiction() != null) {
                    metadata.add(XmlSerializationUtils.mapQualifier("jurisdiction", ds.getJurisdiction()));
                }
                if (ds.getThematic() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("thematic", ds.getThematic().toString()));
                }
                if (ds.getContentpolicies() != null) {
                    metadata.addAll(ds.getContentpolicies().stream().filter(Objects::nonNull).map(q -> XmlSerializationUtils.mapQualifier("contentpolicy", q)).collect(Collectors.toList()));
                }
                if (ds.getSubmissionpolicyurl() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("submissionpolicyurl", ds.getSubmissionpolicyurl()));
                }
                if (ds.getPreservationpolicyurl() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("preservationpolicyurl", ds.getPreservationpolicyurl()));
                }
                if (ds.getResearchproductaccesspolicies() != null) {
                    metadata.addAll(ds.getResearchproductaccesspolicies().stream().map(c -> XmlSerializationUtils.asXmlElement("researchproductaccesspolicies", c)).collect(Collectors.toList()));
                }
                if (ds.getResearchproductmetadataaccesspolicies() == null) break;
                metadata.addAll(ds.getResearchproductmetadataaccesspolicies().stream().map(c -> XmlSerializationUtils.asXmlElement("researchproductmetadataaccesspolicies", c)).collect(Collectors.toList()));
                break;
            }
            case organization: {
                Organization o = (Organization)entity;
                if (o.getLegalshortname() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("legalshortname", (String)o.getLegalshortname().getValue()));
                }
                if (o.getLegalname() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("legalname", (String)o.getLegalname().getValue()));
                }
                if (o.getAlternativeNames() != null) {
                    metadata.addAll(o.getAlternativeNames().stream().filter(Objects::nonNull).map(c -> XmlSerializationUtils.asXmlElement("alternativeNames", (String)c.getValue())).collect(Collectors.toList()));
                }
                if (o.getWebsiteurl() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("websiteurl", (String)o.getWebsiteurl().getValue()));
                }
                if (o.getLogourl() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("logourl", (String)o.getLogourl().getValue()));
                }
                if (o.getEclegalbody() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("eclegalbody", (String)o.getEclegalbody().getValue()));
                }
                if (o.getEclegalperson() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("eclegalperson", (String)o.getEclegalperson().getValue()));
                }
                if (o.getEcnonprofit() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("ecnonprofit", (String)o.getEcnonprofit().getValue()));
                }
                if (o.getEcresearchorganization() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("ecresearchorganization", (String)o.getEcresearchorganization().getValue()));
                }
                if (o.getEchighereducation() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("echighereducation", (String)o.getEchighereducation().getValue()));
                }
                if (o.getEcinternationalorganizationeurinterests() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("ecinternationalorganizationeurinterests", (String)o.getEcinternationalorganizationeurinterests().getValue()));
                }
                if (o.getEcinternationalorganization() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("ecinternationalorganization", (String)o.getEcinternationalorganization().getValue()));
                }
                if (o.getEcenterprise() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("ecenterprise", (String)o.getEcenterprise().getValue()));
                }
                if (o.getEcsmevalidated() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("ecsmevalidated", (String)o.getEcsmevalidated().getValue()));
                }
                if (o.getEcnutscode() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("ecnutscode", (String)o.getEcnutscode().getValue()));
                }
                if (o.getCountry() == null) break;
                metadata.add(XmlSerializationUtils.mapQualifier("country", o.getCountry()));
                break;
            }
            case project: {
                Project p2 = (Project)entity;
                if (p2.getWebsiteurl() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("websiteurl", (String)p2.getWebsiteurl().getValue()));
                }
                if (p2.getCode() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("code", (String)p2.getCode().getValue()));
                }
                if (p2.getAcronym() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("acronym", (String)p2.getAcronym().getValue()));
                }
                if (p2.getTitle() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("title", (String)p2.getTitle().getValue()));
                }
                if (p2.getStartdate() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("startdate", (String)p2.getStartdate().getValue()));
                }
                if (p2.getEnddate() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("enddate", (String)p2.getEnddate().getValue()));
                }
                if (p2.getCallidentifier() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("callidentifier", (String)p2.getCallidentifier().getValue()));
                }
                if (p2.getKeywords() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("keywords", (String)p2.getKeywords().getValue()));
                }
                if (p2.getDuration() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("duration", (String)p2.getDuration().getValue()));
                }
                if (p2.getEcarticle29_3() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("ecarticle29_3", (String)p2.getEcarticle29_3().getValue()));
                }
                if (p2.getSubjects() != null) {
                    metadata.addAll(p2.getSubjects().stream().filter(Objects::nonNull).map(sp -> XmlSerializationUtils.mapStructuredProperty("subject", sp)).collect(Collectors.toList()));
                }
                if (p2.getContracttype() != null) {
                    metadata.add(XmlSerializationUtils.mapQualifier("contracttype", p2.getContracttype()));
                }
                if (p2.getOamandatepublications() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("oamandatepublications", (String)p2.getOamandatepublications().getValue()));
                }
                if (p2.getEcsc39() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("ecsc39", (String)p2.getEcsc39().getValue()));
                }
                if (p2.getSummary() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("summary", (String)p2.getSummary().getValue()));
                }
                if (p2.getCurrency() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("currency", (String)p2.getCurrency().getValue()));
                }
                if (p2.getTotalcost() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("totalcost", p2.getTotalcost().toString()));
                }
                if (p2.getFundedamount() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("fundedamount", p2.getFundedamount().toString()));
                }
                if (p2.getFundingtree() == null) break;
                metadata.addAll(p2.getFundingtree().stream().filter(Objects::nonNull).map(ft -> (String)ft.getValue()).collect(Collectors.toList()));
                break;
            }
            case person: {
                Person person = (Person)entity;
                if (person.getGivenName() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("givenname", person.getGivenName()));
                }
                if (person.getFamilyName() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("familyname", person.getFamilyName()));
                }
                if (person.getAlternativeNames() != null) {
                    metadata.addAll(person.getAlternativeNames().stream().map(altName -> XmlSerializationUtils.asXmlElement("alternativename", altName)).collect(Collectors.toList()));
                }
                if (person.getBiography() != null) {
                    metadata.add(XmlSerializationUtils.asXmlElement("biography", person.getBiography()));
                }
                if (person.getSubject() != null) {
                    metadata.addAll(person.getSubject().stream().map(pt -> {
                        ArrayList attrs = Lists.newArrayList();
                        attrs.add(new Tuple2((Object)"schema", (Object)pt.getSchema()));
                        attrs.add(new Tuple2((Object)"value", (Object)pt.getValue()));
                        attrs.add(new Tuple2((Object)"fromYear", (Object)String.valueOf(pt.getFromYear())));
                        attrs.add(new Tuple2((Object)"toYear", (Object)String.valueOf(pt.getToYear())));
                        return XmlSerializationUtils.asXmlElement("subject", attrs);
                    }).collect(Collectors.toList()));
                }
                if (person.getConsent() == null) break;
                metadata.add(XmlSerializationUtils.asXmlElement("consent", String.valueOf(person.getConsent())));
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid entity type: " + type);
            }
        }
        return metadata;
    }

    private List<String> measuresAsXml(List<Measure> measures) {
        return Stream.concat(measures.stream().filter(m -> !"downloads".equals(m.getId()) && !"views".equals(m.getId())).map(m -> {
            ArrayList l = Lists.newArrayList((Object[])new Tuple2[]{new Tuple2((Object)"id", (Object)m.getId())});
            m.getUnit().forEach(kv -> l.add(new Tuple2((Object)kv.getKey(), (Object)kv.getValue())));
            return XmlSerializationUtils.asXmlElement("measure", l);
        }), measures.stream().filter(m -> "downloads".equals(m.getId()) || "views".equals(m.getId())).filter(m -> m.getUnit().stream().anyMatch(u -> Integer.parseInt(u.getValue()) > 0)).map(m -> XmlSerializationUtils.usageMeasureAsXmlElement("measure", m))).collect(Collectors.toList());
    }

    private String getAuthorPidType(String s) {
        return XmlSerializationUtils.escapeXml(s).replaceAll("\\W", "").replaceAll("\\d", "");
    }

    private static boolean kvNotBlank(KeyValue kv) {
        return kv != null && StringUtils.isNotBlank((CharSequence)kv.getKey()) && StringUtils.isNotBlank((CharSequence)kv.getValue());
    }

    private List<String> mapFields(TemplateFactory templateFactory, RelatedEntityWrapper link) {
        String accumulatorName;
        Relation rel = link.getRelation();
        RelatedEntity re = link.getTarget();
        String targetType = link.getTarget().getType();
        ArrayList metadata = Lists.newArrayList();
        switch (EntityType.valueOf((String)targetType)) {
            case publication: 
            case dataset: 
            case otherresearchproduct: 
            case software: {
                if (re.getTitle() != null && StringUtils.isNotBlank((CharSequence)re.getTitle().getValue())) {
                    metadata.add(XmlSerializationUtils.mapStructuredProperty("title", re.getTitle()));
                }
                if (StringUtils.isNotBlank((CharSequence)re.getDescription())) {
                    metadata.add(XmlSerializationUtils.asXmlElement("description", re.getDescription()));
                }
                if (re.getAuthor() != null) {
                    metadata.addAll(re.getAuthor().stream().map(author -> XmlSerializationUtils.asXmlElement("creator", author)).collect(Collectors.toList()));
                }
                if (StringUtils.isNotBlank((CharSequence)re.getDateofacceptance())) {
                    metadata.add(XmlSerializationUtils.asXmlElement("dateofacceptance", re.getDateofacceptance()));
                }
                if (StringUtils.isNotBlank((CharSequence)re.getPublisher())) {
                    metadata.add(XmlSerializationUtils.asXmlElement("publisher", re.getPublisher()));
                }
                if (StringUtils.isNotBlank((CharSequence)re.getCodeRepositoryUrl())) {
                    metadata.add(XmlSerializationUtils.asXmlElement("coderepositoryurl", re.getCodeRepositoryUrl()));
                }
                if (re.getResulttype() != null && StringUtils.isNotBlank((CharSequence)re.getResulttype().getClassid())) {
                    metadata.add(XmlSerializationUtils.mapQualifier("resulttype", re.getResulttype()));
                }
                if (re.getCollectedfrom() != null) {
                    metadata.addAll(re.getCollectedfrom().stream().filter(XmlRecordFactory::kvNotBlank).map(kv -> XmlSerializationUtils.mapKeyValue("collectedfrom", kv)).collect(Collectors.toList()));
                }
                if (re.getPid() != null) {
                    metadata.addAll(re.getPid().stream().map(p -> XmlSerializationUtils.mapStructuredProperty("pid", p)).collect(Collectors.toList()));
                }
                if (re.getInstances() == null) break;
                re.getInstances().forEach(i -> {
                    ArrayList instanceFields = Lists.newArrayList();
                    if (i.getAccessright() != null && StringUtils.isNotBlank((CharSequence)i.getAccessright().getClassid())) {
                        instanceFields.add(XmlSerializationUtils.mapQualifier("accessright", (Qualifier)i.getAccessright()));
                    }
                    if (i.getHostedby() != null) {
                        instanceFields.add(XmlSerializationUtils.mapKeyValue("hostedby", i.getHostedby()));
                    }
                    if (i.getDateofacceptance() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)i.getDateofacceptance().getValue()))) {
                        instanceFields.add(XmlSerializationUtils.asXmlElement("dateofacceptance", (String)i.getDateofacceptance().getValue()));
                    }
                    if (i.getInstancetype() != null && StringUtils.isNotBlank((CharSequence)i.getInstancetype().getClassid())) {
                        instanceFields.add(XmlSerializationUtils.mapQualifier("instancetype", i.getInstancetype()));
                    }
                    if (i.getRefereed() != null && StringUtils.isNotBlank((CharSequence)i.getRefereed().getClassid())) {
                        instanceFields.add(XmlSerializationUtils.mapQualifier("refereed", i.getRefereed()));
                    }
                    if (i.getLicense() != null && StringUtils.isNotBlank((CharSequence)((CharSequence)i.getLicense().getValue()))) {
                        instanceFields.add(XmlSerializationUtils.asXmlElement("license", (String)i.getLicense().getValue()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)i.getFulltext())) {
                        instanceFields.add(XmlSerializationUtils.asXmlElement("fulltext", i.getFulltext()));
                    }
                    if (i.getUrl() != null && !i.getUrl().isEmpty()) {
                        instanceFields.addAll(i.getUrl().stream().filter(StringUtils::isNotBlank).map(url -> XmlSerializationUtils.asXmlElement("url", url)).collect(Collectors.toList()));
                    }
                    metadata.add(templateFactory.getInstance((List<String>)instanceFields, i.getUrl()));
                });
                break;
            }
            case datasource: {
                if (StringUtils.isNotBlank((CharSequence)re.getOfficialname())) {
                    metadata.add(XmlSerializationUtils.asXmlElement("officialname", re.getOfficialname()));
                }
                if (re.getDatasourcetype() != null && StringUtils.isNotBlank((CharSequence)re.getDatasourcetype().getClassid())) {
                    metadata.add(XmlSerializationUtils.mapQualifier("datasourcetype", re.getDatasourcetype()));
                }
                if (re.getDatasourcetypeui() != null && StringUtils.isNotBlank((CharSequence)re.getDatasourcetypeui().getClassid())) {
                    metadata.add(XmlSerializationUtils.mapQualifier("datasourcetypeui", re.getDatasourcetypeui()));
                }
                if (re.getOpenairecompatibility() == null || !StringUtils.isNotBlank((CharSequence)re.getOpenairecompatibility().getClassid())) break;
                metadata.add(XmlSerializationUtils.mapQualifier("openairecompatibility", re.getOpenairecompatibility()));
                break;
            }
            case organization: {
                if (StringUtils.isNotBlank((CharSequence)re.getLegalname())) {
                    metadata.add(XmlSerializationUtils.asXmlElement("legalname", re.getLegalname()));
                }
                if (StringUtils.isNotBlank((CharSequence)re.getLegalshortname())) {
                    metadata.add(XmlSerializationUtils.asXmlElement("legalshortname", re.getLegalshortname()));
                }
                if (re.getCountry() != null && StringUtils.isNotBlank((CharSequence)re.getCountry().getClassid())) {
                    metadata.add(XmlSerializationUtils.mapQualifier("country", re.getCountry()));
                }
                if (!StringUtils.isNotBlank((CharSequence)re.getWebsiteurl())) break;
                metadata.add(XmlSerializationUtils.asXmlElement("websiteurl", re.getWebsiteurl()));
                break;
            }
            case project: {
                if (StringUtils.isNotBlank((CharSequence)re.getProjectTitle())) {
                    metadata.add(XmlSerializationUtils.asXmlElement("title", re.getProjectTitle()));
                }
                if (StringUtils.isNotBlank((CharSequence)re.getCode())) {
                    metadata.add(XmlSerializationUtils.asXmlElement("code", re.getCode()));
                }
                if (StringUtils.isNotBlank((CharSequence)re.getAcronym())) {
                    metadata.add(XmlSerializationUtils.asXmlElement("acronym", re.getAcronym()));
                }
                if (re.getContracttype() != null && StringUtils.isNotBlank((CharSequence)re.getContracttype().getClassid())) {
                    metadata.add(XmlSerializationUtils.mapQualifier("contracttype", re.getContracttype()));
                }
                if (re.getFundingtree() == null) break;
                metadata.addAll(re.getFundingtree().stream().map(ft -> XmlRecordFactory.getRelFundingTree(ft)).collect(Collectors.toList()));
                break;
            }
            case person: {
                if (StringUtils.isNotBlank((CharSequence)re.getGivenName())) {
                    metadata.add(XmlSerializationUtils.asXmlElement("givenname", re.getGivenName()));
                }
                if (StringUtils.isNotBlank((CharSequence)re.getFamilyName())) {
                    metadata.add(XmlSerializationUtils.asXmlElement("familyname", re.getFamilyName()));
                }
                if (re.getAlternativeNames() == null || re.getAlternativeNames().isEmpty()) break;
                metadata.addAll(re.getAlternativeNames().stream().map(name -> XmlSerializationUtils.asXmlElement("alternativename", name)).collect(Collectors.toList()));
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid target type: " + targetType);
            }
        }
        if (this.accumulators.containsKey(accumulatorName = GraphMappingUtils.getRelDescriptor(rel.getRelType(), rel.getSubRelType(), rel.getRelClass()))) {
            this.accumulators.get(accumulatorName).add(1L);
        }
        return metadata;
    }

    private String mapRelation(TemplateFactory templateFactory, EntityType type, RelatedEntityWrapper link) {
        Relation rel = link.getRelation();
        String targetType = link.getTarget().getType();
        String scheme = ModelSupport.getScheme((String)type.toString(), (String)targetType);
        if (StringUtils.isBlank((CharSequence)scheme)) {
            throw new IllegalArgumentException(String.format("missing scheme for: <%s - %s>", type, targetType));
        }
        HashSet fields = Sets.newHashSet(this.mapFields(templateFactory, link));
        if (rel.getValidated() == null) {
            rel.setValidated(Boolean.valueOf(false));
        }
        return templateFactory.getRel(targetType, rel.getTarget(), fields, rel.getRelClass(), scheme, rel.getDataInfo(), rel.getValidated(), rel.getValidationDate());
    }

    private List<String> listChildren(OafEntity entity, JoinedEntity je, TemplateFactory templateFactory) {
        EntityType entityType = EntityType.fromClass(je.getEntity().getClass());
        List<RelatedEntityWrapper> links = je.getLinks();
        List children = links.stream().filter(link -> this.isDuplicate((RelatedEntityWrapper)link)).map(link -> {
            String targetType = link.getTarget().getType();
            String name = ModelSupport.getMainType((EntityType)EntityType.valueOf((String)targetType));
            HashSet fields = Sets.newHashSet(this.mapFields(templateFactory, (RelatedEntityWrapper)link));
            return templateFactory.getChild(name, link.getTarget().getId(), Lists.newArrayList((Iterable)fields));
        }).collect(Collectors.toCollection(ArrayList::new));
        if (MainEntityType.result.toString().equals(ModelSupport.getMainType((EntityType)entityType))) {
            List ext;
            List instances = ((Result)entity).getInstance();
            if (instances != null) {
                this.groupInstancesByUrl(((Result)entity).getInstance()).forEach(instance -> {
                    ArrayList fields = Lists.newArrayList();
                    if (instance.getAccessright() != null && StringUtils.isNotBlank((CharSequence)instance.getAccessright().getClassid())) {
                        fields.add(XmlSerializationUtils.mapQualifier("accessright", (Qualifier)instance.getAccessright()));
                    }
                    if (instance.getCollectedfrom() != null) {
                        fields.addAll(instance.getCollectedfrom().stream().filter(XmlRecordFactory::kvNotBlank).map(cf -> XmlSerializationUtils.mapKeyValue("collectedfrom", cf)).collect(Collectors.toList()));
                    }
                    if (instance.getHostedby() != null) {
                        fields.addAll(instance.getHostedby().stream().filter(XmlRecordFactory::kvNotBlank).map(hb -> XmlSerializationUtils.mapKeyValue("hostedby", hb)).collect(Collectors.toList()));
                    }
                    if (instance.getDateofacceptance() != null) {
                        fields.addAll(instance.getDateofacceptance().stream().filter(StringUtils::isNotBlank).map(d -> XmlSerializationUtils.asXmlElement("dateofacceptance", d)).collect(Collectors.toList()));
                    }
                    if (instance.getInstancetype() != null) {
                        fields.addAll(instance.getInstancetype().stream().filter(t -> StringUtils.isNotBlank((CharSequence)t.getClassid())).map(t -> XmlSerializationUtils.mapQualifier("instancetype", t)).collect(Collectors.toList()));
                    }
                    if (instance.getDistributionlocation() != null) {
                        fields.addAll(instance.getDistributionlocation().stream().filter(StringUtils::isNotBlank).map(d -> XmlSerializationUtils.asXmlElement("distributionlocation", d)).collect(Collectors.toList()));
                    }
                    if (instance.getPid() != null) {
                        fields.addAll(instance.getPid().stream().filter(Objects::nonNull).map(p -> XmlSerializationUtils.mapStructuredProperty("pid", p)).collect(Collectors.toList()));
                    }
                    if (instance.getAlternateIdentifier() != null) {
                        fields.addAll(instance.getAlternateIdentifier().stream().filter(Objects::nonNull).map(p -> XmlSerializationUtils.mapStructuredProperty("alternateidentifier", p)).collect(Collectors.toList()));
                    }
                    if (instance.getRefereed() != null) {
                        fields.add(XmlSerializationUtils.mapQualifier("refereed", instance.getRefereed()));
                    }
                    if (instance.getProcessingchargeamount() != null && StringUtils.isNotBlank((CharSequence)instance.getProcessingchargeamount())) {
                        fields.add(XmlSerializationUtils.asXmlElement("processingchargeamount", instance.getProcessingchargeamount()));
                    }
                    if (instance.getProcessingchargecurrency() != null && StringUtils.isNotBlank((CharSequence)instance.getProcessingchargecurrency())) {
                        fields.add(XmlSerializationUtils.asXmlElement("processingchargecurrency", instance.getProcessingchargecurrency()));
                    }
                    if (instance.getLicense() != null) {
                        fields.addAll(instance.getLicense().stream().filter(StringUtils::isNotBlank).map(d -> XmlSerializationUtils.asXmlElement("license", d)).collect(Collectors.toList()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)instance.getFulltext())) {
                        fields.add(XmlSerializationUtils.asXmlElement("fulltext", instance.getFulltext()));
                    }
                    children.add(templateFactory.getInstance((List<String>)fields, instance.getUrl()));
                });
            }
            if ((ext = ((Result)entity).getExternalReference()) != null) {
                for (ExternalReference er : ((Result)entity).getExternalReference()) {
                    ArrayList fields = Lists.newArrayList();
                    if (StringUtils.isNotBlank((CharSequence)er.getSitename())) {
                        fields.add(XmlSerializationUtils.asXmlElement("sitename", er.getSitename()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)er.getLabel())) {
                        fields.add(XmlSerializationUtils.asXmlElement("label", er.getLabel()));
                    }
                    Optional.ofNullable(er.getAlternateLabel()).map(altLabel -> altLabel.stream().filter(StringUtils::isNotBlank).collect(Collectors.toList())).orElse(Lists.newArrayList()).forEach(alt -> fields.add(XmlSerializationUtils.asXmlElement("alternatelabel", alt)));
                    if (StringUtils.isNotBlank((CharSequence)er.getUrl())) {
                        fields.add(XmlSerializationUtils.asXmlElement("url", er.getUrl()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)er.getUrl())) {
                        fields.add(XmlSerializationUtils.mapQualifier("qualifier", er.getQualifier()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)er.getRefidentifier())) {
                        fields.add(XmlSerializationUtils.asXmlElement("refidentifier", er.getRefidentifier()));
                    }
                    if (StringUtils.isNotBlank((CharSequence)er.getQuery())) {
                        fields.add(XmlSerializationUtils.asXmlElement("query", er.getQuery()));
                    }
                    children.add(templateFactory.getChild("externalreference", null, fields));
                }
            }
        }
        return children;
    }

    private Stream<XmlInstance> groupInstancesByUrl(List<Instance> instance) {
        return instance.stream().filter(i -> Objects.nonNull(i.getUrl())).map(i -> {
            i.setUrl(i.getUrl().stream().filter(this::isValidUrl).map(XmlRecordFactory::normalizeDoiUrl).collect(Collectors.toList()));
            return i;
        }).filter(i -> Optional.ofNullable(i.getUrl()).map(u -> !u.isEmpty()).orElse(false)).map(this::pickByUrl).collect(Collectors.groupingBy(ImmutablePair::getLeft)).values().stream().filter(Objects::nonNull).map(this::mergeInstances);
    }

    public static String normalizeDoiUrl(String url) {
        if (url.contains(DOI_ORG_AUTHORITY)) {
            try {
                URL u = new URL(url);
                return new URL(HTTPS, DOI_ORG_AUTHORITY, u.getFile()).toString();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return url;
    }

    private boolean isValidUrl(String url) {
        try {
            new URL(url).toURI();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private ImmutablePair<String, Instance> pickByUrl(Instance i) {
        return new ImmutablePair(i.getUrl().get(0), (Object)i);
    }

    private XmlInstance mergeInstances(List<ImmutablePair<String, Instance>> instances) {
        XmlInstance instance = new XmlInstance();
        instance.setUrl((String)instances.get(0).getLeft());
        instance.setAccessright(instances.stream().map(Pair::getValue).map(Instance::getAccessright).filter(Objects::nonNull).min((Comparator<AccessRight>)new AccessRightComparator()).orElse(XmlInstance.UNKNOWN_ACCESS_RIGHT));
        instance.setRefereed(instances.stream().map(Pair::getValue).map(i -> Optional.ofNullable(i.getRefereed()).orElse(XmlInstance.UNKNOWN_REVIEW_LEVEL)).min((Comparator<Qualifier>)new RefereedComparator()).orElse(XmlInstance.UNKNOWN_REVIEW_LEVEL));
        HashMap instanceTypes = Maps.newHashMap();
        instances.forEach(p -> {
            Instance i = (Instance)p.getRight();
            instance.getCollectedfrom().add(i.getCollectedfrom());
            instance.getHostedby().add(i.getHostedby());
            if (Optional.ofNullable(i.getInstancetype()).map(Qualifier::getClassid).isPresent()) {
                instanceTypes.putIfAbsent(i.getInstancetype().getClassid(), i.getInstancetype());
            }
            instance.setProcessingchargeamount(Optional.ofNullable(i.getProcessingchargeamount()).map(apc -> (String)apc.getValue()).orElse(null));
            instance.setProcessingchargecurrency(Optional.ofNullable(i.getProcessingchargecurrency()).map(c -> (String)c.getValue()).orElse(null));
            Optional.ofNullable(i.getPid()).ifPresent(pid -> instance.getPid().addAll((Collection<StructuredProperty>)pid));
            Optional.ofNullable(i.getAlternateIdentifier()).ifPresent(altId -> instance.getAlternateIdentifier().addAll((Collection<StructuredProperty>)altId));
            Optional.ofNullable(i.getDateofacceptance()).ifPresent(d -> instance.getDateofacceptance().add((String)d.getValue()));
            Optional.ofNullable(i.getLicense()).ifPresent(license -> instance.getLicense().add((String)license.getValue()));
            Optional.ofNullable(i.getDistributionlocation()).ifPresent(dl -> instance.getDistributionlocation().add((String)dl));
            Optional.ofNullable(i.getFulltext()).ifPresent(instance::setFulltext);
        });
        instance.getInstancetype().addAll(instanceTypes.values());
        if (instance.getHostedby().size() > 1 && instance.getHostedby().stream().anyMatch(hb -> ModelConstants.UNKNOWN_REPOSITORY.equals(hb))) {
            instance.getHostedby().remove(ModelConstants.UNKNOWN_REPOSITORY);
        }
        return instance;
    }

    private boolean isDuplicate(RelatedEntityWrapper link) {
        return "dedup".equalsIgnoreCase(link.getRelation().getSubRelType());
    }

    private List<String> listExtraInfo(OafEntity entity) {
        List extraInfo = entity.getExtraInfo();
        return extraInfo != null ? extraInfo.stream().map(e -> XmlSerializationUtils.mapExtraInfo(e)).collect(Collectors.toList()) : Lists.newArrayList();
    }

    private List<String> buildContexts(String type, Set<String> contexts) {
        ArrayList res = Lists.newArrayList();
        if (this.contextMapper != null && !this.contextMapper.isEmpty()) {
            XMLTag document = XMLDoc.newDocument((boolean)true).addRoot("contextRoot");
            for (String context : contexts) {
                String id = "";
                for (String token : Splitter.on((String)"::").split((CharSequence)context)) {
                    ContextDef def = (ContextDef)this.contextMapper.get(id = id + token);
                    if (def == null) continue;
                    if (def.getName().equals("context")) {
                        String xpath = "//context/@id='" + def.getId() + "'";
                        if (!document.gotoRoot().rawXpathBoolean(xpath, new Object[]{new Object()}).booleanValue()) {
                            document = this.addContextDef(document.gotoRoot(), def);
                        }
                    }
                    if (def.getName().equals("category")) {
                        String rootId = StringUtils.substringBefore((String)def.getId(), (String)"::");
                        document = this.addContextDef(document.gotoRoot().gotoTag("//context[./@id='" + rootId + "']", new Object[]{new Object()}), def);
                    }
                    if (def.getName().equals("concept")) {
                        document = this.addContextDef(document, def).gotoParent();
                    }
                    id = id + "::";
                }
            }
            Transformer transformer = this.getTransformer();
            for (Element x : document.gotoRoot().getChildElement()) {
                try {
                    res.add(this.asStringElement(x, transformer));
                }
                catch (TransformerException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return res;
    }

    private Transformer getTransformer() {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException("unable to create javax.xml.transform.Transformer", e);
        }
    }

    private XMLTag addContextDef(XMLTag tag, ContextDef def) {
        tag.addTag(def.getName()).addAttribute("id", def.getId()).addAttribute("label", def.getLabel());
        if (def.getType() != null && !def.getType().isEmpty()) {
            tag.addAttribute("type", def.getType());
        }
        return tag;
    }

    private String asStringElement(Element element, Transformer transformer) throws TransformerException {
        StringWriter buffer = new StringWriter();
        transformer.transform(new DOMSource(element), new StreamResult(buffer));
        return buffer.toString();
    }

    protected static String getRelFundingTree(String xmlTree) {
        String funding = "<funding>";
        try {
            Document ftree = new SAXReader().read((Reader)new StringReader(xmlTree));
            funding = "<funding>";
            funding = funding + XmlRecordFactory.getFunderElement(ftree);
            for (Object o : Lists.reverse((List)ftree.selectNodes("//fundingtree//*[starts-with(local-name(),'funding_level_')]"))) {
                org.dom4j.Element e = (org.dom4j.Element)o;
                String _id = e.valueOf("./id");
                funding = funding + "<" + e.getName() + " name=\"" + XmlSerializationUtils.escapeXml(e.valueOf("./name")) + "\">" + XmlSerializationUtils.escapeXml(_id) + "</" + e.getName() + ">";
            }
        }
        catch (DocumentException e) {
            throw new IllegalArgumentException("unable to parse funding tree: " + xmlTree + "\n" + e.getMessage());
        }
        finally {
            funding = funding + "</funding>";
        }
        return funding;
    }

    private static String getFunderElement(Document ftree) {
        String funderId = ftree.valueOf("//fundingtree/funder/id");
        String funderShortName = ftree.valueOf("//fundingtree/funder/shortname");
        String funderName = ftree.valueOf("//fundingtree/funder/name");
        String funderJurisdiction = ftree.valueOf("//fundingtree/funder/jurisdiction");
        return "<funder id=\"" + XmlSerializationUtils.escapeXml(funderId) + "\" shortname=\"" + XmlSerializationUtils.escapeXml(funderShortName) + "\" name=\"" + XmlSerializationUtils.escapeXml(funderName) + "\" jurisdiction=\"" + XmlSerializationUtils.escapeXml(funderJurisdiction) + "\" />";
    }
}

