/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.oaipmh;

import eu.dnetlib.dhp.oa.oaipmh.IrishOaiExporterJob;
import eu.dnetlib.dhp.oa.oaipmh.OaiRecordWrapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class IrishOaiExporterJobTest {
    @Test
    void testAsIrishOaiResult() throws Exception {
        String xml = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("record_IE.xml"));
        OaiRecordWrapper res = IrishOaiExporterJob.asIrishOaiResult((String)xml, (String)LocalDateTime.now().toString());
        Assertions.assertNotNull((Object)res.getId());
        Assertions.assertNotNull((Object)res.getBody());
        Assertions.assertNotNull((Object)res.getSets());
        Assertions.assertNotNull((Object)res.getDate());
        Assertions.assertEquals((Object)"dedup_wf_002::532be02f990b479a1da46d71f1a4c3f0", (Object)res.getId());
        Assertions.assertTrue((res.getBody().length > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)res.getSets().isEmpty());
    }

    @Test
    void testIsValid_IE() throws DocumentException {
        Document doc = new SAXReader().read(this.getClass().getResourceAsStream("record_IE.xml"));
        Assertions.assertTrue((boolean)IrishOaiExporterJob.isValid((Document)doc));
    }

    @Test
    void testIsValid_invalid_country() throws DocumentException {
        Document doc = new SAXReader().read(this.getClass().getResourceAsStream("record_IT.xml"));
        Assertions.assertFalse((boolean)IrishOaiExporterJob.isValid((Document)doc));
    }

    @Test
    void testIsValid_deleted() throws DocumentException {
        Document doc = new SAXReader().read(this.getClass().getResourceAsStream("record_IE_deleted.xml"));
        Assertions.assertFalse((boolean)IrishOaiExporterJob.isValid((Document)doc));
    }

    @Test
    void testGzip_simple() {
        String message = "<test />";
        byte[] bytes = IrishOaiExporterJob.gzip((String)"<test />");
        Assertions.assertNotNull((Object)bytes);
        Assertions.assertTrue((bytes.length > 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"<test />", (Object)IrishOaiExporterJobTest.gunzip(bytes));
    }

    @Test
    void testGzip_empty() {
        Assertions.assertNull((Object)IrishOaiExporterJob.gzip((String)""));
        Assertions.assertNull((Object)IrishOaiExporterJob.gzip(null));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String gunzip(byte[] compressed) {
        if (compressed == null) return null;
        if (compressed.length == 0) {
            return null;
        }
        if (!IrishOaiExporterJobTest.isCompressed(compressed)) {
            return new String(compressed);
        }
        try (GZIPInputStream gis = new GZIPInputStream(new ByteArrayInputStream(compressed));){
            String string = IOUtils.toString((InputStream)gis, (Charset)Charset.defaultCharset());
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("error in gunzip", e);
        }
    }

    private static boolean isCompressed(byte[] compressed) {
        return compressed[0] == 31 && compressed[1] == -117;
    }
}

