/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.provision;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.index.es.ConvertJSONWithId;
import eu.dnetlib.dhp.index.es.ESFeeder;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkIndexCollectionES8 {
    private static final Logger log = LoggerFactory.getLogger(SparkIndexCollectionES8.class);
    private final FileSystem fileSystem;

    public SparkIndexCollectionES8(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser argumentParser = new ArgumentApplicationParser(IOUtils.toString((InputStream)Objects.requireNonNull(SparkIndexCollectionES8.class.getResourceAsStream("/eu/dnetlib/dhp/sx/provision/scholexplorer_parameter.json"))));
        argumentParser.parseArgument(args);
        String hdfsuri = argumentParser.get("namenode");
        log.info("hdfsURI is {}", (Object)hdfsuri);
        String sourcePath = argumentParser.get("sourcePath");
        log.info("sourcePath is {}", (Object)sourcePath);
        String index = argumentParser.get("index");
        log.info("index is {}", (Object)index);
        String indexHost = argumentParser.get("indexHost");
        log.info("indexHost is {}", (Object)indexHost);
        FileSystem fileSystem = FileSystem.get((Configuration)DHPUtils.getHadoopConfiguration((String)hdfsuri));
        new SparkIndexCollectionES8(fileSystem).run(sourcePath, index, indexHost);
    }

    public void run(String sourcePath, String index, String indexHost) throws IOException, InterruptedException {
        RemoteIterator ls = this.fileSystem.listFiles(new Path(sourcePath), false);
        ArrayList<Path> files = new ArrayList<Path>();
        while (ls.hasNext()) {
            LocatedFileStatus current = (LocatedFileStatus)ls.next();
            if (!current.getPath().getName().endsWith(".gz")) continue;
            files.add(current.getPath());
        }
        try (ESFeeder feeder = new ESFeeder(indexHost);){
            long start = System.currentTimeMillis();
            feeder.parallelBulkIndex(files, 20, this.fileSystem, (Function)new ConvertJSONWithId("\"identifier\":\"((\\d|\\w)*)\"", "scholix"));
            long end = System.currentTimeMillis();
            System.out.println("Time Indexing Scholix: " + (end - start) / 1000L + "s");
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

