/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import eu.dnetlib.dhp.oa.provision.CreateRelatedEntitiesJob_phase1;
import eu.dnetlib.dhp.oa.provision.model.JoinedEntity;
import eu.dnetlib.dhp.oa.provision.model.ProvisionModelSupport;
import eu.dnetlib.dhp.oa.provision.model.RelatedEntity;
import eu.dnetlib.dhp.oa.provision.model.RelatedEntityWrapper;
import eu.dnetlib.dhp.oa.provision.utils.ContextDef;
import eu.dnetlib.dhp.oa.provision.utils.ContextMapper;
import eu.dnetlib.dhp.oa.provision.utils.XmlRecordFactory;
import eu.dnetlib.dhp.schema.oaf.Context;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Project;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.solr.SolrRecord;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XmlRecordFactoryTest {
    public static ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    @Test
    void testXMLRecordFactory() throws IOException, DocumentException {
        ContextMapper contextMapper = new ContextMapper();
        XmlRecordFactory xmlRecordFactory = new XmlRecordFactory(contextMapper, false, "https://www.openaire.eu/schema/1.0/oaf-1.0.xsd");
        Publication p = (Publication)OBJECT_MAPPER.readValue(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("publication.json")), Publication.class);
        String xml = xmlRecordFactory.build(new JoinedEntity((OafEntity)p));
        Assertions.assertNotNull((Object)xml);
        Document doc = new SAXReader().read((Reader)new StringReader(xml));
        doc.normalize();
        Assertions.assertNotNull((Object)doc);
        System.out.println(doc.asXML());
        Assertions.assertEquals((Object)"0000-0001-9613-6638", (Object)doc.valueOf("//creator[@rank = '1']/@orcid"));
        Assertions.assertEquals((Object)"0000-0001-9613-6639", (Object)doc.valueOf("//creator[@rank = '1']/@orcid_pending"));
        Assertions.assertEquals((Object)"0000-0001-9613-9956", (Object)doc.valueOf("//creator[@rank = '2']/@orcid"));
        Assertions.assertEquals((Object)"", (Object)doc.valueOf("//creator[@rank = '2']/@orcid_pending"));
        Assertions.assertEquals((Object)"doi", (Object)doc.valueOf("//instance/pid/@classid"));
        Assertions.assertEquals((Object)"10.1109/TED.2018.2853550", (Object)doc.valueOf("//instance/pid/text()"));
        Assertions.assertEquals((Object)"doi", (Object)doc.valueOf("//instance/alternateidentifier/@classid"));
        Assertions.assertEquals((Object)"10.5689/LIB.2018.2853550", (Object)doc.valueOf("//instance/alternateidentifier/text()"));
        Assertions.assertEquals((int)2, (int)doc.selectNodes("//instance").size());
        Assertions.assertEquals((Object)"1721.47", (Object)doc.valueOf("//processingchargeamount/text()"));
        Assertions.assertEquals((Object)"EUR", (Object)doc.valueOf("//processingchargecurrency/text()"));
        Assertions.assertEquals((Object)"5.06690394631e-09", (Object)doc.valueOf("//*[local-name() = 'result']/measure[./@id = 'influence']/@score"));
        Assertions.assertEquals((Object)"C", (Object)doc.valueOf("//*[local-name() = 'result']/measure[./@id = 'influence']/@class"));
        Assertions.assertEquals((Object)"0.0", (Object)doc.valueOf("//*[local-name() = 'result']/measure[./@id = 'popularity_alt']/@score"));
        Assertions.assertEquals((Object)"C", (Object)doc.valueOf("//*[local-name() = 'result']/measure[./@id = 'popularity_alt']/@class"));
        Assertions.assertEquals((Object)"3.11855618382e-09", (Object)doc.valueOf("//*[local-name() = 'result']/measure[./@id = 'popularity']/@score"));
        Assertions.assertEquals((Object)"C", (Object)doc.valueOf("//*[local-name() = 'result']/measure[./@id = 'popularity']/@class"));
        Assertions.assertEquals((Object)"EOSC::Jupyter Notebook", (Object)doc.valueOf("//*[local-name() = 'result']/eoscifguidelines/@code"));
        Assertions.assertEquals((int)2, (int)Integer.parseInt(doc.valueOf("count(//*[local-name() = 'result']/fulltext)")));
        Assertions.assertEquals((Object)"https://osf.io/preprints/socarxiv/7vgtu/download", (Object)doc.valueOf("//*[local-name() = 'result']/fulltext[1]"));
        Assertions.assertEquals((Object)"true", (Object)doc.valueOf("//*[local-name() = 'result']/isgreen/text()"));
        Assertions.assertEquals((Object)"bronze", (Object)doc.valueOf("//*[local-name() = 'result']/openaccesscolor/text()"));
        Assertions.assertEquals((Object)"true", (Object)doc.valueOf("//*[local-name() = 'result']/isindiamondjournal/text()"));
        Assertions.assertEquals((Object)"true", (Object)doc.valueOf("//*[local-name() = 'result']/publiclyfunded/text()"));
        Assertions.assertEquals((int)15, (int)doc.selectNodes("//*[local-name() = 'result']/*[local-name() = 'subject']").size());
    }

    @Test
    public void testXMLRecordFactoryWithValidatedProject() throws IOException, DocumentException {
        ContextMapper contextMapper = new ContextMapper();
        XmlRecordFactory xmlRecordFactory = new XmlRecordFactory(contextMapper, false, "https://www.openaire.eu/schema/1.0/oaf-1.0.xsd");
        Publication p = (Publication)OBJECT_MAPPER.readValue(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("publication.json")), Publication.class);
        Project pj = (Project)OBJECT_MAPPER.readValue(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("project.json")), Project.class);
        Relation rel = (Relation)OBJECT_MAPPER.readValue(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("relToValidatedProject.json")), Relation.class);
        RelatedEntity relatedProject = CreateRelatedEntitiesJob_phase1.asRelatedEntity((OafEntity)pj, Project.class);
        ArrayList links = Lists.newArrayList();
        RelatedEntityWrapper rew = new RelatedEntityWrapper(rel, relatedProject);
        links.add(rew);
        JoinedEntity je = new JoinedEntity((OafEntity)p);
        je.setLinks((List)links);
        String xml = xmlRecordFactory.build(je);
        Assertions.assertNotNull((Object)xml);
        Document doc = new SAXReader().read((Reader)new StringReader(xml));
        Assertions.assertNotNull((Object)doc);
        System.out.println(doc.asXML());
        Assertions.assertEquals((Object)"2021-01-01", (Object)doc.valueOf("//validated/@date"));
    }

    @Test
    public void testXMLRecordFactoryWithNonValidatedProject() throws IOException, DocumentException {
        ContextMapper contextMapper = new ContextMapper();
        XmlRecordFactory xmlRecordFactory = new XmlRecordFactory(contextMapper, false, "https://www.openaire.eu/schema/1.0/oaf-1.0.xsd");
        Publication p = (Publication)OBJECT_MAPPER.readValue(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("publication.json")), Publication.class);
        Project pj = (Project)OBJECT_MAPPER.readValue(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("project.json")), Project.class);
        Relation rel = (Relation)OBJECT_MAPPER.readValue(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("relToProject.json")), Relation.class);
        RelatedEntity relatedProject = CreateRelatedEntitiesJob_phase1.asRelatedEntity((OafEntity)pj, Project.class);
        ArrayList links = Lists.newArrayList();
        RelatedEntityWrapper rew = new RelatedEntityWrapper(rel, relatedProject);
        links.add(rew);
        JoinedEntity je = new JoinedEntity((OafEntity)p);
        je.setLinks((List)links);
        String xml = xmlRecordFactory.build(je);
        Assertions.assertNotNull((Object)xml);
        Document doc = new SAXReader().read((Reader)new StringReader(xml));
        Assertions.assertNotNull((Object)doc);
        System.out.println(doc.asXML());
        Assertions.assertEquals((Object)"", (Object)doc.valueOf("//rel/validated"));
    }

    @Test
    public void testService() throws IOException, DocumentException {
        ContextMapper contextMapper = new ContextMapper();
        XmlRecordFactory xmlRecordFactory = new XmlRecordFactory(contextMapper, false, "https://www.openaire.eu/schema/1.0/oaf-1.0.xsd");
        Datasource d = (Datasource)OBJECT_MAPPER.readValue(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("datasource.json")), Datasource.class);
        String xml = xmlRecordFactory.build(new JoinedEntity((OafEntity)d));
        Assertions.assertNotNull((Object)xml);
        Document doc = new SAXReader().read((Reader)new StringReader(xml));
        Assertions.assertNotNull((Object)doc);
        System.out.println(doc.asXML());
        Assertions.assertEquals((Object)"National", (Object)doc.valueOf("//jurisdiction/@classname"));
        Assertions.assertEquals((Object)"true", (Object)doc.valueOf("//thematic"));
        Assertions.assertEquals((Object)"Journal article", (Object)doc.valueOf("//contentpolicy/@classname"));
        Assertions.assertEquals((Object)"Journal archive", (Object)doc.valueOf("//datasourcetypeui/@classname"));
        Assertions.assertEquals((Object)"Data Source", (Object)doc.valueOf("//eosctype/@classname"));
        List pids = doc.selectNodes("//pid");
        Assertions.assertEquals((int)1, (int)pids.size());
        Assertions.assertEquals((Object)"re3data", (Object)((Element)pids.get(0)).attribute("classid").getValue());
        Assertions.assertEquals((Object)"Registry of research data repositories", (Object)((Element)pids.get(0)).attribute("classname").getValue());
        Assertions.assertEquals((Object)"dnet:pid_types", (Object)((Element)pids.get(0)).attribute("schemeid").getValue());
        Assertions.assertEquals((Object)"dnet:pid_types", (Object)((Element)pids.get(0)).attribute("schemename").getValue());
    }

    @Test
    public void testD4ScienceTraining() throws DocumentException, IOException {
        ContextMapper contextMapper = new ContextMapper();
        XmlRecordFactory xmlRecordFactory = new XmlRecordFactory(contextMapper, false, "https://www.openaire.eu/schema/1.0/oaf-1.0.xsd");
        OtherResearchProduct p = (OtherResearchProduct)OBJECT_MAPPER.readValue(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("d4science-1-training.json")), OtherResearchProduct.class);
        String xml = xmlRecordFactory.build(new JoinedEntity((OafEntity)p));
        Assertions.assertNotNull((Object)xml);
        Document doc = new SAXReader().read((Reader)new StringReader(xml));
        Assertions.assertNotNull((Object)doc);
        System.out.println(doc.asXML());
    }

    @Test
    void testRaid() throws DocumentException, IOException {
        ContextMapper contextMapper = new ContextMapper();
        XmlRecordFactory xmlRecordFactory = new XmlRecordFactory(contextMapper, false, "https://www.openaire.eu/schema/1.0/oaf-1.0.xsd");
        OtherResearchProduct p = (OtherResearchProduct)OBJECT_MAPPER.readValue(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("raid.json")), OtherResearchProduct.class);
        JoinedEntity je = new JoinedEntity((OafEntity)p);
        String xml = xmlRecordFactory.build(je);
        Assertions.assertNotNull((Object)xml);
        Document doc = new SAXReader().read((Reader)new StringReader(xml));
        Assertions.assertNotNull((Object)doc);
        System.out.println(doc.asXML());
        SolrRecord sr = ProvisionModelSupport.transform((JoinedEntity)je, (ContextMapper)contextMapper, null);
        System.out.println(OBJECT_MAPPER.writeValueAsString((Object)sr));
    }

    @Test
    public void testD4ScienceDataset() throws DocumentException, IOException {
        ContextMapper contextMapper = new ContextMapper();
        XmlRecordFactory xmlRecordFactory = new XmlRecordFactory(contextMapper, false, "https://www.openaire.eu/schema/1.0/oaf-1.0.xsd");
        OtherResearchProduct p = (OtherResearchProduct)OBJECT_MAPPER.readValue(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("d4science-2-dataset.json")), OtherResearchProduct.class);
        String xml = xmlRecordFactory.build(new JoinedEntity((OafEntity)p));
        Assertions.assertNotNull((Object)xml);
        Document doc = new SAXReader().read((Reader)new StringReader(xml));
        Assertions.assertNotNull((Object)doc);
        System.out.println(doc.asXML());
    }

    @Test
    public void testIrisGuidelines4() throws DocumentException, IOException {
        ContextMapper contextMapper = new ContextMapper();
        XmlRecordFactory xmlRecordFactory = new XmlRecordFactory(contextMapper, false, "https://www.openaire.eu/schema/1.0/oaf-1.0.xsd");
        Publication p = (Publication)OBJECT_MAPPER.readValue(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("iris-odf-4.json")), Publication.class);
        String xml = xmlRecordFactory.build(new JoinedEntity((OafEntity)p));
        Assertions.assertNotNull((Object)xml);
        Document doc = new SAXReader().read((Reader)new StringReader(xml));
        Assertions.assertNotNull((Object)doc);
        System.out.println(doc.asXML());
    }

    @Test
    public void test_AKA_project() throws DocumentException, IOException {
        ContextMapper contextMapper = new ContextMapper();
        contextMapper.put((Object)"dh-ch", (Object)new ContextDef("dh-ch", "Digital Humanities and Cultural Heritage", "context", "community"));
        contextMapper.put((Object)"dh-ch::projects", (Object)new ContextDef("dh-ch::projects", "DH-CH Projects", "category", ""));
        contextMapper.put((Object)"dh-ch::projects::2", (Object)new ContextDef("dh-ch::projects::2", "ARIADNE", "concept", "community"));
        XmlRecordFactory xmlRecordFactory = new XmlRecordFactory(contextMapper, false, "https://www.openaire.eu/schema/1.0/oaf-1.0.xsd");
        Project p = (Project)OBJECT_MAPPER.readValue(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("project_aka.json")), Project.class);
        Assertions.assertNotNull((Object)p.getContext());
        Assertions.assertEquals((int)1, (int)p.getContext().size());
        Assertions.assertEquals((Object)"dh-ch::projects::2", (Object)((Context)p.getContext().get(0)).getId());
        String xml = xmlRecordFactory.build(new JoinedEntity((OafEntity)p));
        Assertions.assertNotNull((Object)xml);
        Document doc = new SAXReader().read((Reader)new StringReader(xml));
        Assertions.assertNotNull((Object)doc);
        Assertions.assertEquals((Object)"dh-ch", (Object)doc.valueOf("//context/@id"));
        Assertions.assertEquals((Object)"dh-ch::projects", (Object)doc.valueOf("//context/category/@id"));
        Assertions.assertEquals((Object)"dh-ch::projects::2", (Object)doc.valueOf("//context/category/concept/@id"));
    }
}

