/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision.utils;

import com.google.common.collect.Lists;
import eu.dnetlib.dhp.oa.provision.utils.GraphMappingUtils;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.EoscIfGuidelines;
import eu.dnetlib.dhp.schema.oaf.ExtraInfo;
import eu.dnetlib.dhp.schema.oaf.Journal;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Measure;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import scala.Tuple2;

public class XmlSerializationUtils {
    private static final String XML_10_PATTERN = "[^\t\r\n -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]";

    private XmlSerializationUtils() {
    }

    public static String mapJournal(Journal j) {
        String attrs = (XmlSerializationUtils.attr("issn", j.getIssnPrinted()) + XmlSerializationUtils.attr("eissn", j.getIssnOnline()) + XmlSerializationUtils.attr("lissn", j.getIssnLinking()) + XmlSerializationUtils.attr("ep", j.getEp()) + XmlSerializationUtils.attr("iss", j.getIss()) + XmlSerializationUtils.attr("sp", j.getSp()) + XmlSerializationUtils.attr("vol", j.getVol())).trim();
        return "<journal" + (String)(StringUtils.isNotBlank((CharSequence)attrs) ? " " + attrs : "") + ">" + XmlSerializationUtils.escapeXml(j.getName()) + "</journal>";
    }

    private static String attr(String name, String value) {
        return StringUtils.isNotBlank((CharSequence)value) ? name + "=\"" + XmlSerializationUtils.escapeXml(value) + "\" " : "";
    }

    public static String mapStructuredProperty(String name, StructuredProperty t) {
        return XmlSerializationUtils.asXmlElement(name, t.getValue(), t.getQualifier(), t.getDataInfo());
    }

    public static String mapQualifier(String name, Qualifier q) {
        return XmlSerializationUtils.asXmlElement(name, "", q, null);
    }

    public static String escapeXml(String value) {
        return value.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&apos;").replaceAll(XML_10_PATTERN, "");
    }

    public static String parseDataInfo(DataInfo dataInfo) {
        return "<datainfo>" + XmlSerializationUtils.asXmlElement("inferred", "" + dataInfo.getInferred()) + XmlSerializationUtils.asXmlElement("deletedbyinference", "" + dataInfo.getDeletedbyinference()) + XmlSerializationUtils.asXmlElement("trust", dataInfo.getTrust()) + XmlSerializationUtils.asXmlElement("inferenceprovenance", dataInfo.getInferenceprovenance()) + XmlSerializationUtils.asXmlElement("provenanceaction", null, dataInfo.getProvenanceaction(), null) + "</datainfo>";
    }

    public static String mapKeyValue(String name, KeyValue kv) {
        return "<" + name + " name=\"" + XmlSerializationUtils.escapeXml(kv.getValue()) + "\" id=\"" + XmlSerializationUtils.escapeXml(GraphMappingUtils.removePrefix(kv.getKey())) + "\"/>";
    }

    public static String mapExtraInfo(ExtraInfo e) {
        return "<extraInfo " + ("name=\"" + e.getName() + "\" ") + ("typology=\"" + e.getTypology() + "\" ") + ("provenance=\"" + e.getProvenance() + "\" ") + ("trust=\"" + e.getTrust() + "\"") + ">" + e.getValue() + "</extraInfo>";
    }

    public static String asXmlElement(String name, String value) {
        return XmlSerializationUtils.asXmlElement(name, value, null, null);
    }

    public static String asXmlElement(String name, String value, Qualifier q, DataInfo info) {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(name);
        if (q != null) {
            sb.append(XmlSerializationUtils.getAttributes(q));
        }
        if (info != null) {
            sb.append(" ").append(XmlSerializationUtils.attr("inferred", info.getInferred() != null ? info.getInferred().toString() : "")).append(XmlSerializationUtils.attr("inferenceprovenance", info.getInferenceprovenance())).append(XmlSerializationUtils.attr("provenanceaction", info.getProvenanceaction() != null ? info.getProvenanceaction().getClassid() : "")).append(XmlSerializationUtils.attr("trust", info.getTrust()));
        }
        if (StringUtils.isBlank((CharSequence)value)) {
            sb.append("/>");
            return sb.toString();
        }
        sb.append(">");
        sb.append(XmlSerializationUtils.escapeXml(value));
        sb.append("</");
        sb.append(name);
        sb.append(">");
        return sb.toString();
    }

    public static String getAttributes(Qualifier q) {
        if (q == null || StringUtils.isBlank((CharSequence)q.getClassid())) {
            return "";
        }
        return " " + XmlSerializationUtils.attr("classid", q.getClassid()) + XmlSerializationUtils.attr("classname", q.getClassname()) + XmlSerializationUtils.attr("schemeid", q.getSchemeid()) + XmlSerializationUtils.attr("schemename", q.getSchemename());
    }

    public static String asXmlElement(String name, List<Tuple2<String, String>> attributes) {
        StringBuilder sb = new StringBuilder();
        sb.append("<");
        sb.append(name);
        for (Tuple2<String, String> attr : attributes) {
            sb.append(" ").append(XmlSerializationUtils.attr((String)attr._1(), (String)attr._2()));
        }
        sb.append("/>");
        return sb.toString();
    }

    public static String usageMeasureAsXmlElement(String name, Measure measure) {
        StringBuilder sb = new StringBuilder();
        for (KeyValue kv : measure.getUnit()) {
            sb.append("<").append(name).append(" ").append(XmlSerializationUtils.attr("id", measure.getId())).append(XmlSerializationUtils.attr("count", kv.getValue())).append(XmlSerializationUtils.attr("datasource", kv.getKey())).append(" />");
        }
        return sb.toString();
    }

    public static String mapEoscIf(EoscIfGuidelines e) {
        return XmlSerializationUtils.asXmlElement("eoscifguidelines", Lists.newArrayList((Object[])new Tuple2[]{new Tuple2((Object)"code", (Object)e.getCode()), new Tuple2((Object)"label", (Object)e.getLabel()), new Tuple2((Object)"url", (Object)e.getUrl()), new Tuple2((Object)"semanticrelation", (Object)e.getSemanticRelation())}));
    }
}

