/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision.utils;

import eu.dnetlib.dhp.common.api.context.CategorySummary;
import eu.dnetlib.dhp.common.api.context.CategorySummaryList;
import eu.dnetlib.dhp.common.api.context.ConceptSummary;
import eu.dnetlib.dhp.common.api.context.ConceptSummaryList;
import eu.dnetlib.dhp.common.api.context.ContextSummary;
import eu.dnetlib.dhp.common.api.context.ContextSummaryList;
import eu.dnetlib.dhp.common.rest.DNetRestClient;
import eu.dnetlib.dhp.oa.provision.utils.ContextDef;
import java.io.Serializable;
import java.util.HashMap;

public class ContextMapper
extends HashMap<String, ContextDef>
implements Serializable {
    private static final long serialVersionUID = 2159682308502487305L;

    public static ContextMapper fromAPI(String baseURL) throws Exception {
        ContextMapper contextMapper = new ContextMapper();
        for (ContextSummary ctx : (ContextSummaryList)DNetRestClient.doGET((String)String.format("%s/contexts", baseURL), ContextSummaryList.class)) {
            contextMapper.put(ctx.getId(), new ContextDef(ctx.getId(), ctx.getLabel(), "context", ctx.getType()));
            for (CategorySummary cat : (CategorySummaryList)DNetRestClient.doGET((String)String.format("%s/context/%s?all=true", baseURL, ctx.getId()), CategorySummaryList.class)) {
                contextMapper.put(cat.getId(), new ContextDef(cat.getId(), cat.getLabel(), "category", ""));
                if (!cat.isHasConcept()) continue;
                for (ConceptSummary c : (ConceptSummaryList)DNetRestClient.doGET((String)String.format("%s/context/category/%s?all=true", baseURL, cat.getId()), ConceptSummaryList.class)) {
                    contextMapper.put(c.getId(), new ContextDef(c.getId(), c.getLabel(), "concept", ""));
                    if (!c.isHasSubConcept()) continue;
                    for (ConceptSummary cs : c.getConcepts()) {
                        contextMapper.put(cs.getId(), new ContextDef(cs.getId(), cs.getLabel(), "concept", ""));
                        if (!cs.isHasSubConcept()) continue;
                        for (ConceptSummary css : cs.getConcepts()) {
                            contextMapper.put(css.getId(), new ContextDef(css.getId(), css.getLabel(), "concept", ""));
                        }
                    }
                }
            }
        }
        return contextMapper;
    }
}

