/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.oa.provision;

import eu.dnetlib.dhp.oa.provision.PrepareRelationsJob;
import eu.dnetlib.dhp.oa.provision.model.ProvisionModelSupport;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareRelationsJobTest {
    private static final Logger log = LoggerFactory.getLogger(PrepareRelationsJobTest.class);
    public static final String SUBRELTYPE = "subRelType";
    public static final String OUTCOME = "outcome";
    public static final String PARTICIPATION = "participation";
    public static final String AFFILIATION = "affiliation";
    private static SparkSession spark;
    private static Path workingDir;

    @BeforeAll
    public static void setUp() throws IOException {
        workingDir = Files.createTempDirectory(PrepareRelationsJobTest.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        conf.registerKryoClasses(ProvisionModelSupport.getModelClasses());
        spark = SparkSession.builder().appName(PrepareRelationsJobTest.class.getSimpleName()).master("local[*]").config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void testRunPrepareRelationsJob(@TempDir Path testPath) throws Exception {
        int maxRelations = 5;
        PrepareRelationsJob.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-inputRelationsPath", this.getClass().getResource("relations.gz").getPath(), "-outputPath", testPath.toString(), "-relPartitions", "10", "-relationFilter", "asd", "-sourceMaxRelations", String.valueOf(5), "-targetMaxRelations", String.valueOf(500)});
        Dataset out = spark.read().parquet(testPath.toString()).as(Encoders.bean(Relation.class)).cache();
        Assertions.assertEquals((long)44L, (long)out.count());
        Dataset freq = out.toDF().cube(SUBRELTYPE, new String[0]).count().filter((FilterFunction & Serializable)value -> !value.isNullAt(0));
        System.out.println(freq.collectAsList().toString());
        long outcome = (Long)this.getRows((Dataset<Row>)freq, OUTCOME).get(0).getAs("count");
        long participation = (Long)this.getRows((Dataset<Row>)freq, PARTICIPATION).get(0).getAs("count");
        long affiliation = (Long)this.getRows((Dataset<Row>)freq, AFFILIATION).get(0).getAs("count");
        Assertions.assertEquals((long)outcome, (long)participation);
        Assertions.assertEquals((long)outcome, (long)affiliation);
        Assertions.assertEquals((long)participation, (long)affiliation);
        Assertions.assertEquals((long)4L, (long)outcome);
        Assertions.assertEquals((long)4L, (long)participation);
        Assertions.assertEquals((long)4L, (long)affiliation);
    }

    protected List<Row> getRows(Dataset<Row> freq, String col) {
        return freq.filter(freq.col(SUBRELTYPE).equalTo((Object)col)).collectAsList();
    }
}

