/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.incremental;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.collection.Seq;

public final class SparkResolveRelationById$ {
    public static SparkResolveRelationById$ MODULE$;

    static {
        new SparkResolveRelationById$();
    }

    public void main(String[] args) {
        Logger log = LoggerFactory.getLogger(this.getClass());
        SparkConf conf = new SparkConf();
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/oa/graph/incremental/resolution/resolve_relationsbyid_params.json")));
        parser.parseArgument(args);
        conf.set("hive.metastore.uris", parser.get("hiveMetastoreUris"));
        String graphBasePath = parser.get("graphBasePath");
        log.info(new StringBuilder(18).append("graphBasePath  -> ").append(graphBasePath).toString());
        String relationPath = parser.get("relationPath");
        log.info(new StringBuilder(17).append("relationPath  -> ").append(relationPath).toString());
        String targetPath = parser.get("targetGraph");
        log.info(new StringBuilder(16).append("targetGraph  -> ").append(targetPath).toString());
        String hiveDbName = parser.get("hiveDbName");
        log.info(new StringBuilder(15).append("hiveDbName  -> ").append(hiveDbName).toString());
        SparkSession spark = SparkSession$.MODULE$.builder().config(conf).enableHiveSupport().appName(this.getClass().getSimpleName()).getOrCreate();
        Encoder relEncoder = Encoders$.MODULE$.bean(Relation.class);
        Dataset mergedrels = spark.table(new StringBuilder(9).append(hiveDbName).append(".relation").toString()).where("relclass = 'merges'").selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"source as dedupId", "target as mergedId"}));
        spark.read().schema(Encoders$.MODULE$.bean(Relation.class).schema()).json(new StringBuilder(9).append(graphBasePath).append("/relation").toString()).as(relEncoder).join(mergedrels, functions$.MODULE$.col("source").$eq$eq$eq((Object)mergedrels.col("mergedId")), "left").withColumn("source", functions$.MODULE$.expr("coalesce(dedupId, source)")).drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mergedId", "dedupID"})).join(mergedrels, functions$.MODULE$.col("target").$eq$eq$eq((Object)mergedrels.col("mergedId")), "left").withColumn("target", functions$.MODULE$.expr("coalesce(dedupId, target)")).drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mergedId", "dedupID"})).write().option("compression", "gzip").mode(SaveMode.Overwrite).json(new StringBuilder(9).append(targetPath).append("/relation").toString());
    }

    private SparkResolveRelationById$() {
        MODULE$ = this;
    }
}

