package eu.dnetlib.data.mdstore.manager;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.scheduling.annotation.EnableScheduling;

import eu.dnetlib.common.app.AbstractDnetApp;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@SpringBootApplication
@EnableSwagger2
@EnableCaching
@EnableScheduling
@EntityScan("eu.dnetlib.dhp.schema.mdstore")
public class MainApplication extends AbstractDnetApp {

	@Value("${dhp.swagger.api.host}")
	private String swaggetHost;

	@Value("${dhp.swagger.api.basePath}")
	private String swaggerPath;

	public static void main(final String[] args) {
		SpringApplication.run(MainApplication.class, args);
	}

	@Override
	protected void configSwagger(final Docket docket) {
		docket
			.host(swaggetHost)
			.pathMapping(swaggerPath)
			.select()
			.apis(RequestHandlerSelectors.any())
			.paths(p -> p.startsWith("/mdstores"))
			.build()
			.apiInfo(new ApiInfoBuilder()
				.title("MDStore Manager APIs")
				.description("APIs documentation")
				.version("1.1")
				.contact(ApiInfo.DEFAULT_CONTACT)
				.license("Apache 2.0")
				.licenseUrl("http://www.apache.org/licenses/LICENSE-2.0")
				.build());
	}

}
