/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.manager.controller;

import eu.dnetlib.data.mdstore.manager.exceptions.MDStoreManagerException;
import eu.dnetlib.data.mdstore.manager.utils.ControllerUtils;
import eu.dnetlib.data.mdstore.manager.utils.DatabaseUtils;
import eu.dnetlib.data.mdstore.manager.utils.ZeppelinClient;
import eu.dnetlib.dhp.schema.mdstore.MDStoreWithInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class ZeppelinController {
    @Autowired
    private ZeppelinClient zeppelinClient;
    @Autowired
    private DatabaseUtils databaseUtils;

    @RequestMapping(value={"/zeppelin/{mdId}/{note}"})
    public String goToZeppelin(@PathVariable String mdId, @PathVariable String note) throws MDStoreManagerException {
        MDStoreWithInfo mdstore = this.databaseUtils.findMdStore(mdId);
        String currentVersion = mdstore.getCurrentVersion();
        String path = this.databaseUtils.findVersion(currentVersion).getHdfsPath() + "/store";
        return "redirect:" + this.zeppelinClient.zeppelinNote(note, mdstore, path);
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ModelAndView handleException(Exception e) {
        return ControllerUtils.errorPage((String)"Metadata Store Manager - Zeppelin Client", (Throwable)e);
    }
}

