/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.manager.controller;

import eu.dnetlib.data.mdstore.manager.exceptions.MDStoreManagerException;
import eu.dnetlib.data.mdstore.manager.utils.ControllerUtils;
import eu.dnetlib.data.mdstore.manager.utils.DatabaseUtils;
import eu.dnetlib.dhp.schema.mdstore.MDStoreVersion;
import eu.dnetlib.dhp.schema.mdstore.MDStoreWithInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class MDInspectorController {
    @Autowired
    private DatabaseUtils databaseUtils;
    private static final Logger log = LoggerFactory.getLogger(MDInspectorController.class);
    @Value(value="${dhp.mdstore-manager.inspector.records.max}")
    private Long MAX_MD_RECORDS;

    @RequestMapping(value={"/mdrecords/{id}/{limit}"})
    public String mdstoreInspector(ModelMap map, @PathVariable String id, @PathVariable long limit) throws MDStoreManagerException {
        MDStoreVersion ver;
        MDStoreWithInfo md;
        if (this.isMdstoreId(id)) {
            log.debug("MDSTORE: " + id);
            md = this.databaseUtils.findMdStore(id);
            ver = this.databaseUtils.findVersion(md.getCurrentVersion());
        } else {
            log.debug("VERSION: " + id);
            ver = this.databaseUtils.findVersion(id);
            md = this.databaseUtils.findMdStore(ver.getMdstore());
        }
        map.addAttribute("mdId", (Object)md.getId());
        map.addAttribute("versionId", (Object)ver.getId());
        map.addAttribute("dsId", (Object)md.getDatasourceId());
        map.addAttribute("dsName", (Object)md.getDatasourceName());
        map.addAttribute("apiId", (Object)md.getApiId());
        map.addAttribute("format", (Object)md.getFormat());
        map.addAttribute("layout", (Object)md.getLayout());
        map.addAttribute("interpretation", (Object)md.getInterpretation());
        map.addAttribute("path", (Object)ver.getHdfsPath());
        map.addAttribute("lastUpdate", (Object)ver.getLastUpdate());
        map.addAttribute("size", (Object)ver.getSize());
        map.addAttribute("limit", (Object)Math.min(limit, this.MAX_MD_RECORDS));
        if (md.getCurrentVersion().equals(ver.getId())) {
            map.addAttribute("status", (Object)"current");
        } else if (ver.isWriting()) {
            map.addAttribute("status", (Object)"writing");
        } else {
            map.addAttribute("status", (Object)"expired");
        }
        return "inspector";
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ModelAndView handleException(Exception e) {
        return ControllerUtils.errorPage((String)"Metadata Inspector - ERROR", (Throwable)e);
    }

    private boolean isMdstoreId(String id) {
        return id.length() < 40;
    }
}

