package eu.dnetlib.data.mdstore.manager.controller;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.DOMWriter;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import eu.dnetlib.common.controller.AbstractDnetController;
import eu.dnetlib.data.mdstore.manager.utils.OpenaireGuidelines;
import eu.dnetlib.validator2.result_models.StandardValidationResult;
import io.swagger.v3.oas.annotations.Operation;

@RestController
@RequestMapping("/validate")
public class ValidationController extends AbstractDnetController {

	@Operation(summary = "validate a record")
	@PostMapping("/{guidelines}")
	public StandardValidationResult validate(@PathVariable final OpenaireGuidelines guidelines, @RequestBody final String xmlRecord) throws Exception {

		final Document doc = DocumentHelper.parseText(xmlRecord);

		final String id = doc.valueOf("//*[local-name()='header']/*[local-name()='identifier']");

		final org.w3c.dom.Document w3cDoc = new DOMWriter().write(doc);

		return guidelines.getProfileClazz()
				.getConstructor()
				.newInstance()
				.validate(id, w3cDoc);

	}
}
