package eu.dnetlib.data.mdstore.manager.utils;

import java.util.List;
import java.util.Map;
import java.util.Set;

import eu.dnetlib.data.mdstore.manager.exceptions.MDStoreManagerException;

public interface HdfsClient {

	String getHadoopUser();

	String getHadoopCluster();

	String getHdfsBasePath();

	void deletePath(String hdfsPath) throws MDStoreManagerException;

	Set<String> listHadoopDirs();

	Set<String> listContent(String hdfsPath);

	List<Map<String, String>> readParquetFiles(String hdfsPath, long limit) throws MDStoreManagerException;

}
