/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.sx.api.model.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import eu.dnetlib.dhp.schema.sx.api.model.v1.ScholixCreator;
import eu.dnetlib.dhp.schema.sx.api.model.v1.ScholixIdentifier;
import eu.dnetlib.dhp.schema.sx.api.model.v1.ScholixProvider;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixResource;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ScholixItem {
    @JsonProperty(value="identifiers")
    private List<ScholixIdentifier> identifiers;
    @JsonProperty(value="objectType")
    private String objectType;
    @JsonProperty(value="objectSubType")
    private String objectSubType;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="creator")
    private List<ScholixCreator> creator;
    @JsonProperty(value="publicationDate")
    private String publicationDate;
    @JsonProperty(value="publisher")
    private List<ScholixProvider> publisher;

    @Schema(description="The list of identifiers")
    public List<ScholixIdentifier> getIdentifiers() {
        return this.identifiers;
    }

    public ScholixItem setIdentifiers(List<ScholixIdentifier> identifiers) {
        this.identifiers = identifiers;
        return this;
    }

    public ScholixItem objectType(String objectType) {
        this.objectType = objectType;
        return this;
    }

    @Schema(description="Describes the nature of the object (its intended usage)")
    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public ScholixItem objectSubType(String objectSubType) {
        this.objectSubType = objectSubType;
        return this;
    }

    @Schema(description="The sub-type of  Object")
    public String getObjectSubType() {
        return this.objectSubType;
    }

    public void setObjectSubType(String objectSubType) {
        this.objectSubType = objectSubType;
    }

    public ScholixItem title(String title) {
        this.title = title;
        return this;
    }

    @Schema(description="The name of the object")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public ScholixItem creator(List<ScholixCreator> creator) {
        this.creator = creator;
        return this;
    }

    public ScholixItem addCreatorInstance(ScholixCreator creatorInstance) {
        if (this.creator == null) {
            this.creator = new ArrayList<ScholixCreator>();
        }
        this.creator.add(creatorInstance);
        return this;
    }

    @Schema(description="Party responsible for the creation of the object")
    public List<ScholixCreator> getCreator() {
        return this.creator;
    }

    public void setCreator(List<ScholixCreator> creator) {
        this.creator = creator;
    }

    @Schema(description="The date the object was formally issued, published or distributed")
    public String getPublicationDate() {
        return this.publicationDate;
    }

    public void setPublicationDate(String publicationDate) {
        this.publicationDate = publicationDate;
    }

    @Schema(description="The list name of the publisher of the object")
    public List<ScholixProvider> getPublisher() {
        return this.publisher;
    }

    public ScholixItem setPublisher(List<ScholixProvider> publisher) {
        this.publisher = publisher;
        return this;
    }

    public static ScholixItem fromScholixResource(ScholixResource input) {
        if (input == null) {
            return null;
        }
        ScholixItem result = new ScholixItem();
        if (input.getIdentifier() != null) {
            result.setIdentifiers(input.getIdentifier().stream().map(ScholixIdentifier::fromScholixIdentifier).collect(Collectors.toList()));
        }
        result.setTitle(input.getTitle());
        result.setObjectType(input.getObjectType());
        result.setObjectSubType(input.getObjectSubType());
        result.setPublicationDate(input.getPublicationDate());
        if (input.getPublisher() != null) {
            result.setPublisher(input.getPublisher().stream().map(ScholixProvider::fromScholixEntityId).collect(Collectors.toList()));
        }
        if (input.getCreator() != null) {
            result.setCreator(input.getCreator().stream().map(ScholixCreator::fromScholixEntityId).collect(Collectors.toList()));
        }
        return result;
    }
}

