
package eu.dnetlib.dhp.schema.mdstore;

import java.io.Serializable;
import java.util.Map;

import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.validator2.result_models.StandardValidationResult;

/**
 * This class models a record in a Metadata store collection on HDFS
 */
public class MetadataRecord implements Serializable {

	/** The D-Net Identifier associated to the record */
	private String id;

	/** The original Identifier of the record */
	private String originalId;

	/** The encoding of the record, should be JSON or XML */
	private String encoding;

	/**
	 * The information about the provenance of the record see @{@link Provenance} for the model of this information
	 */
	private Provenance provenance;

	/** The content of the metadata */
	private String body;

	/** The validation results of the metadata */
	private Map<ValidationType, StandardValidationResult> validationResults;

	/** the date when the record has been stored */
	private Long dateOfCollection;

	/** the date when the record has been stored */
	private Long dateOfTransformation;

	public MetadataRecord() {

	}

	public MetadataRecord(
			final String originalId,
			final String encoding,
			final Provenance provenance,
			final String body,
			final Long dateOfCollection) {

		this(originalId, encoding, provenance, body, null, dateOfCollection);
	}

	public MetadataRecord(
			final String originalId,
			final String encoding,
			final Provenance provenance,
			final String body,
			final Map<ValidationType, StandardValidationResult> validationResults,
			final Long dateOfCollection) {

		this.originalId = originalId;
		this.encoding = encoding;
		this.provenance = provenance;
		this.body = body;
		this.validationResults = validationResults;
		this.dateOfCollection = dateOfCollection;
		this.id = ModelSupport.generateIdentifier(originalId, this.provenance.getNsPrefix());
	}

	public String getId() {
		return this.id;
	}

	public void setId(final String id) {
		this.id = id;
	}

	public String getOriginalId() {
		return this.originalId;
	}

	public void setOriginalId(final String originalId) {
		this.originalId = originalId;
	}

	public String getEncoding() {
		return this.encoding;
	}

	public void setEncoding(final String encoding) {
		this.encoding = encoding;
	}

	public Provenance getProvenance() {
		return this.provenance;
	}

	public void setProvenance(final Provenance provenance) {
		this.provenance = provenance;
	}

	public String getBody() {
		return this.body;
	}

	public void setBody(final String body) {
		this.body = body;
	}

	public Map<ValidationType, StandardValidationResult> getValidationResults() {
		return this.validationResults;
	}

	public void setValidationResults(final Map<ValidationType, StandardValidationResult> validationResults) {
		this.validationResults = validationResults;
	}

	public Long getDateOfCollection() {
		return this.dateOfCollection;
	}

	public void setDateOfCollection(final Long dateOfCollection) {
		this.dateOfCollection = dateOfCollection;
	}

	public Long getDateOfTransformation() {
		return this.dateOfTransformation;
	}

	public void setDateOfTransformation(final Long dateOfTransformation) {
		this.dateOfTransformation = dateOfTransformation;
	}

	@Override
	public boolean equals(final Object o) {
		if (!(o instanceof MetadataRecord)) { return false; }
		return ((MetadataRecord) o).getId().equalsIgnoreCase(this.id);
	}

	@Override
	public int hashCode() {
		return this.id.hashCode();
	}
}
