/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.oaf.utils;

import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.utils.PidBlacklistProvider;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class CleaningFunctions {
    public static final String DOI_PREFIX_REGEX = "(^10\\.|\\/10\\.)";
    public static final String DOI_PREFIX = "10.";
    public static final Set<String> PID_BLACKLIST = new HashSet<String>();

    public static boolean pidFilter(StructuredProperty s) {
        String pidValue = s.getValue();
        if (Objects.isNull(s.getQualifier()) || StringUtils.isBlank((CharSequence)pidValue) || StringUtils.isBlank((CharSequence)pidValue.replaceAll("(?:\\n|\\r|\\t|\\s)", ""))) {
            return false;
        }
        if (PID_BLACKLIST.contains(pidValue)) {
            return false;
        }
        return !PidBlacklistProvider.getBlacklist(s.getQualifier().getClassid()).contains(pidValue);
    }

    public static StructuredProperty normalizePidValue(StructuredProperty pid) {
        pid.setValue(CleaningFunctions.normalizePidValue(pid.getQualifier().getClassid(), pid.getValue()));
        return pid;
    }

    public static String normalizePidValue(String pidType, String pidValue) {
        String value = Optional.ofNullable(pidValue).map(String::trim).orElseThrow(() -> new IllegalArgumentException("PID value cannot be empty"));
        switch (pidType) {
            case "doi": {
                return value.toLowerCase().replaceFirst(DOI_PREFIX_REGEX, DOI_PREFIX);
            }
        }
        return value;
    }

    static {
        PID_BLACKLIST.add("none");
        PID_BLACKLIST.add("na");
    }
}

