/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.oaf;

import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class Oaf
implements Serializable {
    protected List<KeyValue> collectedfrom;
    private DataInfo dataInfo;
    private Long lastupdatetimestamp;

    public List<KeyValue> getCollectedfrom() {
        return this.collectedfrom;
    }

    public void setCollectedfrom(List<KeyValue> collectedfrom) {
        this.collectedfrom = collectedfrom;
    }

    public DataInfo getDataInfo() {
        return this.dataInfo;
    }

    public void setDataInfo(DataInfo dataInfo) {
        this.dataInfo = dataInfo;
    }

    public Long getLastupdatetimestamp() {
        return this.lastupdatetimestamp;
    }

    public void setLastupdatetimestamp(Long lastupdatetimestamp) {
        this.lastupdatetimestamp = lastupdatetimestamp;
    }

    public void mergeFrom(Oaf o) {
        if (Objects.isNull(o)) {
            return;
        }
        this.setCollectedfrom(Stream.concat(Optional.ofNullable(this.getCollectedfrom()).map(Collection::stream).orElse(Stream.empty()), Optional.ofNullable(o.getCollectedfrom()).map(Collection::stream).orElse(Stream.empty())).distinct().collect(Collectors.toList()));
        this.setLastupdatetimestamp(Math.max(Optional.ofNullable(this.getLastupdatetimestamp()).orElse(0L), Optional.ofNullable(o.getLastupdatetimestamp()).orElse(0L)));
    }

    public void mergeOAFDataInfo(Oaf o) {
        if (o.getDataInfo() != null && (this.compareTrust(this, o) < 0 || this.getDataInfo().getInvisible().booleanValue())) {
            this.dataInfo = o.getDataInfo();
        }
    }

    protected String extractTrust(Oaf e) {
        if (e == null || e.getDataInfo() == null || e.getDataInfo().getTrust() == null) {
            return "0.0";
        }
        return e.getDataInfo().getTrust();
    }

    protected int compareTrust(Oaf a, Oaf b) {
        return this.extractTrust(a).compareTo(this.extractTrust(b));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Oaf oaf = (Oaf)o;
        return Objects.equals(this.getDataInfo(), oaf.getDataInfo()) && Objects.equals(this.lastupdatetimestamp, oaf.lastupdatetimestamp);
    }

    public int hashCode() {
        return Objects.hash(this.dataInfo, this.lastupdatetimestamp);
    }
}

