/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.sx.scholix;

import eu.dnetlib.dhp.schema.sx.scholix.ScholixCollectedFrom;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixComparator;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixEntityId;
import eu.dnetlib.dhp.schema.sx.scholix.ScholixIdentifier;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ScholixResource
implements Serializable,
Comparable<ScholixResource> {
    private List<ScholixIdentifier> identifier;
    private String dnetIdentifier;
    private String objectType;
    private String objectSubType;
    private String title;
    private List<ScholixEntityId> creator;
    private String publicationDate;
    private List<ScholixEntityId> publisher;
    private List<ScholixCollectedFrom> collectedFrom;

    public List<ScholixIdentifier> getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(List<ScholixIdentifier> identifier) {
        this.identifier = identifier;
    }

    public String getDnetIdentifier() {
        return this.dnetIdentifier;
    }

    public void setDnetIdentifier(String dnetIdentifier) {
        this.dnetIdentifier = dnetIdentifier;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public String getObjectSubType() {
        return this.objectSubType;
    }

    public void setObjectSubType(String objectSubType) {
        this.objectSubType = objectSubType;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List<ScholixEntityId> getCreator() {
        return this.creator;
    }

    public void setCreator(List<ScholixEntityId> creator) {
        this.creator = creator;
    }

    public String getPublicationDate() {
        return this.publicationDate;
    }

    public void setPublicationDate(String publicationDate) {
        this.publicationDate = publicationDate;
    }

    public List<ScholixEntityId> getPublisher() {
        return this.publisher;
    }

    public void setPublisher(List<ScholixEntityId> publisher) {
        this.publisher = publisher;
    }

    public List<ScholixCollectedFrom> getCollectedFrom() {
        return this.collectedFrom;
    }

    public void setCollectedFrom(List<ScholixCollectedFrom> collectedFrom) {
        this.collectedFrom = collectedFrom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScholixResource)) {
            return false;
        }
        ScholixResource that = (ScholixResource)o;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        int idHash = this.identifier == null ? 0 : this.identifier.stream().sorted().collect(Collectors.toList()).hashCode();
        int creatorHash = this.creator == null ? 0 : this.creator.stream().sorted().collect(Collectors.toList()).hashCode();
        int publisherHash = this.publisher == null ? 0 : this.publisher.stream().sorted().collect(Collectors.toList()).hashCode();
        int collectedFromHash = this.collectedFrom == null ? 0 : this.collectedFrom.stream().sorted().collect(Collectors.toList()).hashCode();
        return Objects.hash(idHash, ScholixComparator.normalizeIdnetifier(this.dnetIdentifier), ScholixComparator.normalizeString(this.objectType), ScholixComparator.normalizeString(this.objectSubType), ScholixComparator.normalizeString(this.title), creatorHash, ScholixComparator.normalizeString(this.publicationDate), publisherHash, collectedFromHash);
    }

    @Override
    public int compareTo(ScholixResource other) {
        if (other == null) {
            return -1;
        }
        int compIdentifiers = ScholixComparator.compareList(this.identifier, other.getIdentifier());
        if (compIdentifiers != 0) {
            return compIdentifiers;
        }
        int dnetIdComp = StringUtils.compare((String)this.dnetIdentifier, (String)other.getDnetIdentifier());
        if (dnetIdComp != 0) {
            return dnetIdComp;
        }
        int objTypeComparator = StringUtils.compare((String)ScholixComparator.normalizeString(this.objectType), (String)ScholixComparator.normalizeString(other.getObjectType()));
        if (objTypeComparator != 0) {
            return objTypeComparator;
        }
        int objSubTypeComparator = StringUtils.compare((String)ScholixComparator.normalizeString(this.objectSubType), (String)ScholixComparator.normalizeString(other.getObjectSubType()));
        if (objSubTypeComparator != 0) {
            return objSubTypeComparator;
        }
        int titleComparator = StringUtils.compare((String)ScholixComparator.normalizeString(this.title), (String)ScholixComparator.normalizeString(other.getTitle()));
        if (titleComparator != 0) {
            return titleComparator;
        }
        int creatorComparator = ScholixComparator.compareList(this.creator, other.getCreator());
        if (creatorComparator != 0) {
            return creatorComparator;
        }
        int pubDateComparator = StringUtils.compare((String)ScholixComparator.normalizeString(this.publicationDate), (String)ScholixComparator.normalizeString(other.getPublicationDate()));
        if (pubDateComparator != 0) {
            return pubDateComparator;
        }
        int publisherComparator = ScholixComparator.compareList(this.publisher, other.getPublisher());
        if (publisherComparator != 0) {
            return publisherComparator;
        }
        return ScholixComparator.compareList(this.collectedFrom, other.getCollectedFrom());
    }
}

