
package eu.dnetlib.dhp.schema.dump.oaf;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.imifou.jsonschema.module.addon.annotation.JsonSchema;

/**
 * Represents the manifestations (i.e. different versions) of the result. For example: the pre-print and the published
 * versions are two manifestations of the same research result. It has the following parameters: - license of type
 * String to store the license applied to the instance. It corresponds to the value of the licence in the instance to be
 * dumped - accessright of type eu.dnetlib.dhp.schema.dump.oaf.AccessRight to store the accessright of the instance. -
 * type of type String to store the type of the instance as defined in the corresponding dnet vocabulary
 * (dnet:pubication_resource). It corresponds to the instancetype.classname of the instance to be mapped - url of type
 * List<String> list of locations where the instance is accessible. It corresponds to url of the instance to be dumped -
 * publicationdate of type String to store the publication date of the instance ;// dateofacceptance; - refereed of type
 * String to store information abour the review status of the instance. Possible values are 'Unknown',
 * 'nonPeerReviewed', 'peerReviewed'. It corresponds to refereed.classname of the instance to be dumped
 * - articleprocessingcharge of type APC to store the article processing charges possibly associated to the instance
 * -pid of type List<ControlledField> that is the list of pids associated to the result coming from authoritative sources for that pid
 * -alternateIdentifier of type List<ControlledField> that is the list of pids associated to the result coming from NON authoritative
 * sources for that pid
 * -measure list<KeyValue> to represent the measure computed for this instance (for example the Bip!Finder ones). It corresponds to measures in the model
 */
public class Instance implements Serializable {

	@JsonSchema(description = "Measures computed for this instance, for example Bip!Finder ones")
	private List<Measure> measures;

	private List<ResultPid> pid;

	@JsonSchema(description = "All the identifiers other than pids forged by an authorithy for the pid type (i.e. Crossref for DOIs")
	private List<AlternateIdentifier> alternateIdentifier;

	private String license;

	@JsonSchema(description = "The accessRights for this materialization of the result")
	private AccessRight accessright;

	@JsonSchema(description = "The specific sub-type of this instance (see https://api.openaire.eu/vocabularies/dnet:result_typologies following the links)")
	private String type;

	@JsonSchema(description = "URLs to the instance. They may link to the actual full-text or to the landing page at the hosting source. ")
	private List<String> url;

	@JsonSchema(description = "The money spent to make this book or article available in Open Access. Source for this information is the OpenAPC initiative.")
	private APC articleprocessingcharge;

	@JsonSchema(description = "Date of the research product")
	private String publicationdate;// dateofacceptance;

	@JsonSchema(description = "If this instance has been peer-reviewed or not. Allowed values are peerReviewed, " +
			"nonPeerReviewed, UNKNOWN (as defined in https://api.openaire.eu/vocabularies/dnet:review_levels)")
	private String refereed; // peer-review status



	public String getLicense() {
		return license;
	}

	public void setLicense(String license) {
		this.license = license;
	}

	public AccessRight getAccessright() {
		return accessright;
	}

	public void setAccessright(AccessRight accessright) {
		this.accessright = accessright;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public List<String> getUrl() {
		return url;
	}

	public void setUrl(List<String> url) {
		this.url = url;
	}

	public String getPublicationdate() {
		return publicationdate;
	}

	public void setPublicationdate(String publicationdate) {
		this.publicationdate = publicationdate;
	}

	public String getRefereed() {
		return refereed;
	}

	public void setRefereed(String refereed) {
		this.refereed = refereed;
	}

	public APC getArticleprocessingcharge() {
		return articleprocessingcharge;
	}

	public void setArticleprocessingcharge(APC articleprocessingcharge) {
		this.articleprocessingcharge = articleprocessingcharge;
	}

	public List<ResultPid> getPid() {
		return pid;
	}

	public void setPid(List<ResultPid> pid) {
		this.pid = pid;
	}

	public List<AlternateIdentifier> getAlternateIdentifier() {
		return alternateIdentifier;
	}

	public void setAlternateIdentifier(List<AlternateIdentifier> alternateIdentifier) {
		this.alternateIdentifier = alternateIdentifier;
	}

	public List<Measure> getMeasures() {
		return measures;
	}

	public void setMeasures(List<Measure> measures) {
		this.measures = measures;
	}
}



