/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.schema.oaf.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.utils.CleaningFunctions;
import eu.dnetlib.dhp.schema.oaf.utils.PidComparator;
import eu.dnetlib.dhp.schema.oaf.utils.PidType;
import eu.dnetlib.dhp.schema.oaf.utils.PidValueComparator;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;

public class IdentifierFactory
implements Serializable {
    public static final String ID_SEPARATOR = "::";
    public static final String ID_PREFIX_SEPARATOR = "|";
    public static final int ID_PREFIX_LEN = 12;
    public static final Map<PidType, HashBiMap<String, String>> PID_AUTHORITY = Maps.newHashMap();

    public static List<StructuredProperty> getPids(List<StructuredProperty> pid, KeyValue collectedFrom) {
        return IdentifierFactory.pidFromInstance(pid, collectedFrom, true).distinct().collect(Collectors.toList());
    }

    public static <T extends Result> String createDOIBoostIdentifier(T entity) {
        if (entity == null) {
            return null;
        }
        StructuredProperty pid = null;
        if (entity.getPid() != null) {
            pid = entity.getPid().stream().filter(Objects::nonNull).filter(s -> s.getQualifier() != null && "doi".equalsIgnoreCase(s.getQualifier().getClassid())).filter(CleaningFunctions::pidFilter).findAny().orElse(null);
        } else if (entity.getInstance() != null) {
            pid = entity.getInstance().stream().filter(i -> i.getPid() != null).flatMap(i -> i.getPid().stream()).filter(CleaningFunctions::pidFilter).findAny().orElse(null);
        }
        if (pid != null) {
            return IdentifierFactory.idFromPid(entity, pid, true);
        }
        return null;
    }

    public static <T extends OafEntity> String createIdentifier(T entity, boolean md5) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{entity.getId()}), (Object)"missing entity identifier");
        Map<String, Set<StructuredProperty>> pids = IdentifierFactory.extractPids(entity);
        return pids.values().stream().flatMap(s -> s.stream()).min(new PidComparator<T>(entity)).map(min -> Optional.ofNullable(pids.get(min.getQualifier().getClassid())).map(p -> p.stream().sorted(new PidValueComparator()).findFirst().map(s -> IdentifierFactory.idFromPid(entity, s, md5)).orElseGet(entity::getId)).orElseGet(entity::getId)).orElseGet(entity::getId);
    }

    private static <T extends OafEntity> Map<String, Set<StructuredProperty>> extractPids(T entity) {
        if (entity instanceof Result) {
            return Optional.ofNullable(((Result)entity).getInstance()).map(instance -> IdentifierFactory.mapPids(instance)).orElse(new HashMap());
        }
        return entity.getPid().stream().map(CleaningFunctions::normalizePidValue).filter(CleaningFunctions::pidFilter).collect(Collectors.groupingBy(p -> p.getQualifier().getClassid(), Collectors.mapping(p -> p, Collectors.toCollection(HashSet::new))));
    }

    private static Map<String, Set<StructuredProperty>> mapPids(List<Instance> instance) {
        return instance.stream().map(i -> IdentifierFactory.pidFromInstance(i.getPid(), i.getCollectedfrom(), false)).flatMap(Function.identity()).collect(Collectors.groupingBy(p -> p.getQualifier().getClassid(), Collectors.mapping(p -> p, Collectors.toCollection(HashSet::new))));
    }

    private static Stream<StructuredProperty> pidFromInstance(List<StructuredProperty> pid, KeyValue collectedFrom, boolean mapHandles) {
        return Optional.ofNullable(pid).map(pp -> pp.stream().filter(p -> IdentifierFactory.shouldFilterPid(collectedFrom, p, mapHandles)).map(CleaningFunctions::normalizePidValue).filter(CleaningFunctions::pidFilter)).orElse(Stream.empty());
    }

    private static boolean shouldFilterPid(KeyValue collectedFrom, StructuredProperty p, boolean mapHandles) {
        PidType pType = PidType.tryValueOf(p.getQualifier().getClassid());
        return mapHandles && pType.equals((Object)PidType.handle) || Optional.ofNullable(collectedFrom).isPresent() && Optional.ofNullable(PID_AUTHORITY.get((Object)pType)).map(authorities -> authorities.containsKey((Object)collectedFrom.getKey()) || authorities.containsValue((Object)collectedFrom.getValue())).orElse(false) != false;
    }

    public static <T extends OafEntity> String createIdentifier(T entity) {
        return IdentifierFactory.createIdentifier(entity, true);
    }

    private static <T extends OafEntity> String idFromPid(T entity, StructuredProperty s, boolean md5) {
        return IdentifierFactory.idFromPid(ModelSupport.getIdPrefix(entity.getClass()), s.getQualifier().getClassid(), s.getValue(), md5);
    }

    public static String idFromPid(String numericPrefix, String pidType, String pidValue, boolean md5) {
        return numericPrefix + ID_PREFIX_SEPARATOR + IdentifierFactory.createPrefix(pidType) + ID_SEPARATOR + (md5 ? IdentifierFactory.md5(pidValue) : pidValue);
    }

    private static String createPrefix(String pidType) {
        StringBuilder prefix = new StringBuilder(StringUtils.left((String)pidType, (int)12));
        while (prefix.length() < 12) {
            prefix.append("_");
        }
        return prefix.substring(0, 12);
    }

    public static String md5(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(s.getBytes(StandardCharsets.UTF_8));
            return new String(Hex.encodeHex((byte[])md.digest()));
        }
        catch (Exception e) {
            System.err.println("Error creating id");
            return null;
        }
    }

    static {
        PID_AUTHORITY.put(PidType.doi, (HashBiMap<String, String>)HashBiMap.create());
        PID_AUTHORITY.get((Object)PidType.doi).put((Object)"10|openaire____::081b82f96300b6a6e3d282bad31cb6e2", (Object)"Crossref");
        PID_AUTHORITY.get((Object)PidType.doi).put((Object)"10|openaire____::9e3be59865b2c1c335d32dae2fe7b254", (Object)"Datacite");
        PID_AUTHORITY.put(PidType.pmc, (HashBiMap<String, String>)HashBiMap.create());
        PID_AUTHORITY.get((Object)PidType.pmc).put((Object)"10|opendoar____::8b6dd7db9af49e67306feb59a8bdc52c", (Object)"Europe PubMed Central");
        PID_AUTHORITY.get((Object)PidType.pmc).put((Object)"10|opendoar____::eda80a3d5b344bc40f3bc04f65b7a357", (Object)"PubMed Central");
        PID_AUTHORITY.put(PidType.pmid, (HashBiMap<String, String>)HashBiMap.create());
        PID_AUTHORITY.get((Object)PidType.pmid).put((Object)"10|opendoar____::8b6dd7db9af49e67306feb59a8bdc52c", (Object)"Europe PubMed Central");
        PID_AUTHORITY.get((Object)PidType.pmid).put((Object)"10|opendoar____::eda80a3d5b344bc40f3bc04f65b7a357", (Object)"PubMed Central");
        PID_AUTHORITY.put(PidType.arXiv, (HashBiMap<String, String>)HashBiMap.create());
        PID_AUTHORITY.get((Object)PidType.arXiv).put((Object)"10|opendoar____::6f4922f45568161a8cdf4ad2299f6d23", (Object)"arXiv.org e-Print Archive");
    }
}

